/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.api.pipe;

import com.sun.xml.internal.ws.api.pipe.Fiber;
import com.sun.xml.internal.ws.api.server.Container;
import com.sun.xml.internal.ws.api.server.ContainerResolver;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class Engine {
    private volatile Executor threadPool;
    public final String id;
    private final Container container;

    String getId() {
        return this.id;
    }

    Container getContainer() {
        return this.container;
    }

    Executor getExecutor() {
        return this.threadPool;
    }

    public Engine(String string, Executor executor) {
        this(string, ContainerResolver.getDefault().getContainer(), executor);
    }

    public Engine(String string, Container container, Executor executor) {
        this(string, container);
        this.threadPool = executor != null ? this.wrap(executor) : null;
    }

    public Engine(String string) {
        this(string, ContainerResolver.getDefault().getContainer());
    }

    public Engine(String string, Container container) {
        this.id = string;
        this.container = container;
    }

    public void setExecutor(Executor executor) {
        this.threadPool = executor != null ? this.wrap(executor) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addRunnable(Fiber fiber) {
        if (this.threadPool == null) {
            Engine engine = this;
            synchronized (engine) {
                this.threadPool = this.wrap(Executors.newCachedThreadPool(new DaemonThreadFactory()));
            }
        }
        this.threadPool.execute(fiber);
    }

    private Executor wrap(Executor executor) {
        return ContainerResolver.getDefault().wrapExecutor(this.container, executor);
    }

    public Fiber createFiber() {
        return new Fiber(this);
    }

    private static class DaemonThreadFactory
    implements ThreadFactory {
        static final AtomicInteger poolNumber = new AtomicInteger(1);
        final AtomicInteger threadNumber = new AtomicInteger(1);
        final String namePrefix = "jaxws-engine-" + poolNumber.getAndIncrement() + "-thread-";

        DaemonThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(null, runnable, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            if (!thread.isDaemon()) {
                thread.setDaemon(true);
            }
            if (thread.getPriority() != 5) {
                thread.setPriority(5);
            }
            return thread;
        }
    }
}

