/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import mods.flammpfeil.slashblade.ItemSlashBlade;
import mods.flammpfeil.slashblade.entity.EntityBladeStand;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.event.entity.living.LivingDropsEvent;

public class DropEventHandler {
    public static final String header = "flammpfeil.slashblade.entitydrops.";
    public static Set<String> registerdEntityNames = Sets.newHashSet();
    public static Map<String, Multimap<Float, ItemStack>> dropData = Maps.newHashMap();

    public static void registerEntityDrop(String entityName, float rate, ItemStack item) {
        Multimap<Float, ItemStack> drops = null;
        if (!dropData.containsKey(entityName)) {
            drops = HashMultimap.create();
            dropData.put(entityName, drops);
        } else {
            drops = dropData.get(entityName);
        }
        drops.put((Object)Float.valueOf(rate), (Object)item);
    }

    @SubscribeEvent
    public void LivingDrops(LivingDropsEvent event) {
        String key = EntityList.func_75621_b((Entity)event.entityLiving);
        if (dropData.containsKey(key)) {
            Random rand = event.entityLiving.func_70681_au();
            Multimap<Float, ItemStack> drops = dropData.get(key);
            for (Map.Entry drop : drops.entries()) {
                NBTTagCompound tag;
                boolean forceDrop;
                boolean isDrop = false;
                float rate = Math.abs(((Float)drop.getKey()).floatValue());
                boolean requiredBlade = ((Float)drop.getKey()).floatValue() < 0.0f;
                isDrop = rate * (1.0f + 0.5f * (float)event.lootingLevel) > rand.nextFloat();
                boolean bl = forceDrop = rate > 1.1f;
                if (requiredBlade) {
                    EntityLivingBase target = event.entityLiving.getAITarget();
                    if (target == null) {
                        return;
                    }
                    ItemStack attackItem = target.getHeldItem();
                    if (attackItem == null) {
                        return;
                    }
                    if (!(attackItem.func_77973_b() instanceof ItemSlashBlade)) {
                        return;
                    }
                }
                if (!event.recentlyHit && !forceDrop || !isDrop || drop.getValue() == null) continue;
                ItemStack dropitem = ((ItemStack)drop.getValue()).func_77946_l();
                dropitem.field_77994_a = Math.max(dropitem.func_77976_d(), Math.max(1, Math.round((float)dropitem.field_77994_a * rand.nextFloat())));
                if (dropitem.func_77973_b() instanceof ItemSlashBlade && !(tag = ItemSlashBlade.getItemTagCompound(dropitem)).func_74767_n("IsNoStandDrop")) {
                    EntityBladeStand e = new EntityBladeStand(event.entityLiving.worldObj, event.entityLiving.field_70165_t, event.entityLiving.field_70163_u, event.entityLiving.field_70161_v, dropitem);
                    e.func_184195_f(true);
                    event.entityLiving.worldObj.spawnEntityInWorld((Entity)e);
                    return;
                }
                if (dropitem.field_77994_a == 0) continue;
                event.entityLiving.func_70099_a(dropitem, 1.0f);
            }
        }
    }
}

