/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade;

import com.google.common.collect.Maps;
import java.util.Map;
import mods.flammpfeil.slashblade.ItemSlashBladeNamed;
import mods.flammpfeil.slashblade.ItemSlashBladeWrapper;
import mods.flammpfeil.slashblade.SlashBlade;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import mods.flammpfeil.slashblade.named.NamedBladeManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class RecipeWrapBlade
extends ShapedRecipes {
    ItemStack proudSoul = new ItemStack((Item)SlashBlade.proudSoul, 1, 0);
    public static Map<String, String> wrapableTextureNames = Maps.newHashMap();
    private static Map<String, Float> wrapableBaseAttackModifiers = Maps.newHashMap();

    public RecipeWrapBlade() {
        super("flammpfeil.slashblade:wrap", 3, 3, NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])new Ingredient[]{Ingredient.field_193370_a, Ingredient.field_193370_a, Ingredient.func_193369_a((ItemStack[])new ItemStack[]{SlashBlade.findItemStack("flammpfeil.slashblade", "proudsoul", 1)}), Ingredient.field_193370_a, Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((Item)SlashBlade.wrapBlade, 1, 0)}), Ingredient.field_193370_a, Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack(Items.field_151041_m)}), Ingredient.field_193370_a, Ingredient.field_193370_a}), new ItemStack((Item)SlashBlade.wrapBlade, 1, 0));
        RecipeWrapBlade.RegisterWrapable("reforged:wooden_katana", "BalkonWood", 2.0f);
        RecipeWrapBlade.RegisterWrapable("reforged:stone_katana", "BalkonStone", 4.0f);
        RecipeWrapBlade.RegisterWrapable("reforged:iron_katana", "BalkonIron", 6.0f);
        RecipeWrapBlade.RegisterWrapable("reforged:diamond_katana", "BalkonDiamond", 8.0f);
        RecipeWrapBlade.RegisterWrapable("reforged:golden_katana", "BalkonGold", 2.0f);
    }

    public static void RegisterWrapable(String name, String texture, float attackModifier) {
        wrapableTextureNames.put(name, texture);
        wrapableBaseAttackModifiers.put(name, Float.valueOf(attackModifier));
        ItemStack blade = RecipeWrapBlade.getWrapSampleBlade(name, texture);
        NBTTagCompound tag = ItemSlashBlade.getItemTagCompound(blade);
        ItemSlashBladeNamed.BaseAttackModifier.set(tag, Float.valueOf(attackModifier));
        tag.func_82580_o("display");
        NamedBladeManager.registerBladeSoul(tag, blade.func_82833_r());
    }

    public static ItemStack getWrapSampleBlade(String name, String texture) {
        ItemStack innerBlade = SlashBlade.findItemStack("minecraft", "wooden_sword", 1);
        ItemStack reqiredBlade = SlashBlade.findItemStack("flammpfeil.slashblade", "slashbladeWrapper", 1);
        SlashBlade.wrapBlade.setWrapItem(reqiredBlade, innerBlade);
        reqiredBlade.func_77966_a(Enchantments.field_185304_p, 1);
        NBTTagCompound tag = reqiredBlade.func_77978_p();
        ItemSlashBladeNamed.CurrentItemName.set(tag, "wrap." + name.replace(':', '.'));
        ItemSlashBladeNamed.BaseAttackModifier.set(tag, Float.valueOf(4.0f));
        ItemSlashBlade.TextureName.set(tag, texture);
        NBTTagCompound displayTag = new NBTTagCompound();
        reqiredBlade.func_77983_a("display", (NBTBase)displayTag);
        NBTTagList loreList = new NBTTagList();
        loreList.func_74742_a((NBTBase)new NBTTagString("is demo item. is wooden sword"));
        loreList.func_74742_a((NBTBase)new NBTTagString("true performance : please crafting"));
        displayTag.func_74782_a("Lore", (NBTBase)loreList);
        reqiredBlade.func_151001_c(reqiredBlade.func_82833_r());
        String reqiredStr = "wrap." + name.replace(':', '.') + ".sample";
        SlashBlade.registerCustomItemStack(reqiredStr, reqiredBlade);
        ItemSlashBladeNamed.NamedBlades.add("flammpfeil.slashblade:" + reqiredStr);
        return reqiredBlade;
    }

    public boolean func_77569_a(InventoryCrafting cInv, World par2World) {
        ItemStack ps = cInv.func_70463_b(2, 0);
        boolean hasProudSuol = !ps.func_190926_b() && ps.func_77969_a(this.proudSoul);
        ItemStack sc = cInv.func_70463_b(1, 1);
        boolean hasScabbard = !sc.func_190926_b() && sc.func_77973_b() == SlashBlade.wrapBlade && !ItemSlashBladeWrapper.hasWrapedItem(sc);
        boolean hasTarget = false;
        ItemStack target = cInv.func_70463_b(0, 2);
        if (!target.func_190926_b()) {
            ResourceLocation targetName = target.func_77973_b().getRegistryName();
            hasTarget = wrapableTextureNames.containsKey(targetName.toString());
        }
        return hasProudSuol && hasScabbard && hasTarget;
    }

    public ItemStack func_77572_b(InventoryCrafting cInv) {
        ItemStack scabbard = cInv.func_70463_b(1, 1);
        if (scabbard.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        scabbard = scabbard.func_77946_l();
        ItemStack target = cInv.func_70463_b(0, 2);
        if (target.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        target = target.func_77946_l();
        ResourceLocation targetName = target.func_77973_b().getRegistryName();
        SlashBlade.wrapBlade.removeWrapItem(scabbard);
        SlashBlade.wrapBlade.setWrapItem(scabbard, target);
        NBTTagCompound tag = scabbard.func_77978_p();
        ItemSlashBladeNamed.CurrentItemName.set(tag, "wrap." + targetName.toString().replace(':', '.'));
        ItemSlashBladeNamed.TextureName.set(tag, wrapableTextureNames.get(targetName.toString()));
        ItemSlashBladeNamed.BaseAttackModifier.set(tag, wrapableBaseAttackModifiers.get(targetName.toString()));
        if (target.func_82837_s()) {
            scabbard.func_151001_c(I18n.func_135052_a((String)"item.flammpfeil.slashblade.wrapformat", (Object[])new Object[]{target.func_82833_r()}));
        } else if (target.func_77948_v()) {
            scabbard.func_151001_c(scabbard.func_82833_r());
        } else {
            scabbard.func_151001_c(I18n.func_135052_a((String)"item.flammpfeil.slashblade.wrapformat.low", (Object[])new Object[]{target.func_82833_r()}));
        }
        if (target.func_77948_v()) {
            tag.func_74782_a("ench", target.func_77978_p().func_74781_a("ench"));
        }
        return scabbard;
    }
}

