/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.ability;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import mods.flammpfeil.slashblade.ItemSlashBlade;
import mods.flammpfeil.slashblade.SlashBlade;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EntityDamageSource;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

public class AttackLimitter {
    public boolean enabled = false;

    public void loadConfig(Configuration config) {
        try {
            config.load();
            Property prop = SlashBlade.mainConfiguration.get("general", "enabledAttackAttenuation", true);
            this.enabled = prop.getBoolean();
        }
        finally {
            config.save();
        }
    }

    @SubscribeEvent
    public void onLivingHurtEvent(LivingHurtEvent event) {
        if (!this.enabled) {
            return;
        }
        if (!(event.source.getEntity() instanceof EntityLivingBase)) {
            return;
        }
        if (!(event.source instanceof EntityDamageSource)) {
            return;
        }
        EntityLivingBase attacker = (EntityLivingBase)event.source.getEntity();
        ItemStack stack = attacker.getHeldItem();
        if (stack == null) {
            return;
        }
        if (!(stack.func_77973_b() instanceof ItemSlashBlade)) {
            return;
        }
        NBTTagCompound tag = ItemSlashBlade.getItemTagCompound(stack);
        String LAST_ATTACK_TIME = "SB.LastAttackTime";
        long last = attacker.getEntityData().func_74763_f("SB.LastAttackTime");
        long now = attacker.worldObj.func_82737_E();
        long actionTime = ItemSlashBlade.LastActionTime.get(tag);
        attacker.getEntityData().func_74772_a("SB.LastAttackTime", actionTime);
        long dist = now - last;
        float chargeTicks = 13.0f;
        float charge = (float)dist / chargeTicks;
        charge = Math.max(0.0f, charge);
        if (1.0f < charge) {
            return;
        }
        charge = charge * 0.8f + 0.2f;
        event.ammount *= charge;
    }
}

