/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.client.model;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import mods.flammpfeil.slashblade.client.model.obj.WavefrontObject;
import mods.flammpfeil.slashblade.util.ResourceLocationRaw;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class BladeModelManager {
    WavefrontObject defaultModel = new WavefrontObject(resourceDefaultModel);
    static final ResourceLocationRaw resourceDefaultModel = new ResourceLocationRaw("flammpfeil.slashblade", "model/blade.obj");
    public static final ResourceLocationRaw resourceDurabilityModel = new ResourceLocationRaw("flammpfeil.slashblade", "model/util/durability.obj");
    public static final ResourceLocationRaw resourceDurabilityTexture = new ResourceLocationRaw("flammpfeil.slashblade", "model/util/durability.png");
    LoadingCache<ResourceLocationRaw, WavefrontObject> cache = CacheBuilder.newBuilder().build(CacheLoader.asyncReloading((CacheLoader)new CacheLoader<ResourceLocationRaw, WavefrontObject>(){

        public WavefrontObject load(ResourceLocationRaw key) throws Exception {
            try {
                return new WavefrontObject(key);
            }
            catch (Exception e) {
                return BladeModelManager.this.defaultModel;
            }
        }
    }, (Executor)Executors.newCachedThreadPool()));

    public static BladeModelManager getInstance() {
        return SingletonHolder.instance;
    }

    private BladeModelManager() {
    }

    @SubscribeEvent
    public void reload(TextureStitchEvent.Pre event) {
        this.cache.invalidateAll();
        this.defaultModel = new WavefrontObject(resourceDefaultModel);
    }

    public WavefrontObject getModel(ResourceLocationRaw loc) {
        try {
            return (WavefrontObject)this.cache.get((Object)loc);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            return this.defaultModel;
        }
    }

    private static final class SingletonHolder {
        private static final BladeModelManager instance = new BladeModelManager();

        private SingletonHolder() {
        }
    }
}

