/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.core;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import mods.flammpfeil.slashblade.SlashBlade;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.IAnimals;
import net.minecraft.entity.projectile.EntityFireball;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.IThrowableEntity;
import net.minecraftforge.fml.relauncher.Side;

public class ConfigEntityListManager {
    public static Map<String, Boolean> attackableTargets = new HashMap<String, Boolean>();
    public static Map<String, Boolean> destructableTargets = new HashMap<String, Boolean>();

    private static String escape(String source) {
        return String.format("\"%s\"", source.replace("\\", "\\\\").replace("\"", "\\quot;").replace("\r", "\\r;").replace("\n", "\\n;"));
    }

    private static String unescape(String source) {
        return source.replace("\"", "").replace("\\quot;", "\"").replace("\\r;", "\r").replace("\\n;", "\n").replace("\\\\", "\\");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void onWorldTickEvent(TickEvent.WorldTickEvent event) {
        if (event.side == Side.SERVER && event.phase == TickEvent.Phase.START && event.type == TickEvent.Type.WORLD) {
            try {
                Boolean name;
                String attackableStr;
                String name2;
                if (!SlashBlade.mainConfiguration.hasCategory("general")) {
                    SlashBlade.mainConfiguration.load();
                }
                for (String[] entry : ForgeRegistries.ENTITIES) {
                    Class cls = entry.getEntityClass();
                    String name3 = entry.getName();
                    if (name3 == null || name3.length() == 0) continue;
                    Entity instance = null;
                    try {
                        Constructor constructor = cls.getConstructor(World.class);
                        if (constructor != null) {
                            instance = (Entity)constructor.newInstance(event.world);
                        }
                    }
                    catch (Throwable e) {
                        instance = null;
                    }
                    if (EntityLivingBase.class.isAssignableFrom(cls)) {
                        boolean attackable = true;
                        if (instance == null) {
                            attackable = true;
                        } else if (IMob.class.isAssignableFrom(cls)) {
                            attackable = true;
                        } else if (instance instanceof IAnimals || instance instanceof IEntityOwnable || instance instanceof IMerchant) {
                            attackable = false;
                        }
                        attackableTargets.put(name3, attackable);
                        continue;
                    }
                    boolean destructable = false;
                    if (instance instanceof IProjectile || instance instanceof EntityTNTPrimed || instance instanceof EntityFireball || instance instanceof IThrowableEntity) {
                        destructable = true;
                    }
                    destructableTargets.put(cls.getSimpleName(), destructable);
                }
                Property propAttackableTargets = SlashBlade.mainConfiguration.get("general", "AttackableTargets", new String[0]);
                propAttackableTargets.setShowInGui(false);
                for (String curEntry : propAttackableTargets.getStringList()) {
                    curEntry = ConfigEntityListManager.unescape(curEntry);
                    int spliterIdx = curEntry.lastIndexOf(":");
                    name2 = curEntry.substring(0, spliterIdx);
                    attackableStr = curEntry.substring(spliterIdx + 1, curEntry.length());
                    boolean attackable = attackableStr.toLowerCase().equals("true");
                    attackableTargets.put(name2, attackable);
                }
                String[] profAttackableTargets = new ArrayList();
                for (String key : attackableTargets.keySet()) {
                    name = attackableTargets.get(key);
                    String keyStr = key;
                    profAttackableTargets.add(ConfigEntityListManager.escape(String.format("%s:%b", keyStr, name)));
                }
                String[] data = profAttackableTargets.toArray(new String[0]);
                propAttackableTargets.set(data);
                Property propDestructableTargets = SlashBlade.mainConfiguration.get("general", "DestructableTargets", new String[0]);
                propDestructableTargets.setShowInGui(false);
                for (String curEntry : propDestructableTargets.getStringList()) {
                    curEntry = ConfigEntityListManager.unescape(curEntry);
                    int spliterIdx = curEntry.lastIndexOf(":");
                    name2 = curEntry.substring(0, spliterIdx);
                    attackableStr = curEntry.substring(spliterIdx + 1, curEntry.length());
                    boolean destructable = attackableStr.toLowerCase().equals("true");
                    destructableTargets.put(name2, destructable);
                }
                ArrayList<String> profDestructableTargets = new ArrayList<String>();
                for (String key : destructableTargets.keySet()) {
                    name = destructableTargets.get(key);
                    String keyStr = key;
                    profDestructableTargets.add(ConfigEntityListManager.escape(String.format("%s:%b", keyStr, name)));
                }
                String[] data2 = profDestructableTargets.toArray(new String[0]);
                propDestructableTargets.set(data2);
            }
            finally {
                SlashBlade.mainConfiguration.save();
            }
            MinecraftForge.EVENT_BUS.unregister((Object)this);
        }
    }
}

