/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.entity;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import mods.flammpfeil.slashblade.ability.StylishRankManager;
import mods.flammpfeil.slashblade.entity.selector.EntitySelectorAttackable;
import mods.flammpfeil.slashblade.entity.selector.EntitySelectorDestructable;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import mods.flammpfeil.slashblade.util.ReflectionAccessHelper;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityFireball;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IThrowableEntity;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntitySummonedSword
extends Entity
implements IThrowableEntity {
    protected Entity thrower;
    protected ItemStack blade = ItemStack.field_190927_a;
    protected List<Entity> alreadyHitEntity = new ArrayList<Entity>();
    protected float AttackLevel = 0.0f;
    private static final DataParameter<Integer> LIFETIME = EntityDataManager.func_187226_a(EntitySummonedSword.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Float> ROLL = EntityDataManager.func_187226_a(EntitySummonedSword.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Integer> TARGET_ENTITY_ID = EntityDataManager.func_187226_a(EntitySummonedSword.class, (DataSerializer)DataSerializers.field_187192_b);
    float speed = 0.0f;
    float iniYaw = Float.NaN;
    float iniPitch = Float.NaN;
    double hitX;
    double hitY;
    double hitZ;
    float hitYaw;
    float hitPitch;
    Entity ridingEntity2 = null;

    public EntitySummonedSword(World par1World) {
        super(par1World);
    }

    public EntitySummonedSword(World par1World, EntityLivingBase entityLiving, float AttackLevel, float roll) {
        this(par1World, entityLiving, AttackLevel);
        this.setRoll(roll);
    }

    public EntitySummonedSword(World par1World, EntityLivingBase entityLiving, float AttackLevel) {
        this(par1World);
        this.AttackLevel = AttackLevel;
        this.thrower = entityLiving;
        this.blade = entityLiving.func_184586_b(EnumHand.MAIN_HAND);
        if (!this.blade.func_190926_b() && !(this.blade.func_77973_b() instanceof ItemSlashBlade)) {
            this.blade = ItemStack.field_190927_a;
        }
        this.alreadyHitEntity.clear();
        this.alreadyHitEntity.add(this.thrower);
        this.alreadyHitEntity.add(this.thrower.func_184187_bx());
        this.alreadyHitEntity.addAll(this.thrower.func_184188_bt());
        this.field_70173_aa = 0;
        this.func_70105_a(0.5f, 0.5f);
        float dist = 2.0f;
        double ran = ((double)this.field_70146_Z.nextFloat() - 0.5) * 2.0;
        double yaw = Math.toRadians(-this.thrower.field_70177_z + 90.0f);
        double x = ran * Math.sin(yaw);
        double y = 1.0 - Math.abs(ran);
        double z = ran * Math.cos(yaw);
        this.func_70012_b(this.thrower.field_70165_t + (x *= (double)dist), this.thrower.field_70163_u + (y *= (double)dist), this.thrower.field_70161_v + (z *= (double)dist), this.thrower.field_70177_z, this.thrower.field_70125_A);
        this.iniYaw = this.thrower.field_70177_z;
        this.iniPitch = this.thrower.field_70125_A;
        this.setDriveVector(1.75f);
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(TARGET_ENTITY_ID, (Object)0);
        this.func_184212_Q().func_187214_a(ROLL, (Object)Float.valueOf(0.0f));
        this.func_184212_Q().func_187214_a(LIFETIME, (Object)20);
    }

    public int getTargetEntityId() {
        return (Integer)this.func_184212_Q().func_187225_a(TARGET_ENTITY_ID);
    }

    public void setTargetEntityId(int entityid) {
        this.func_184212_Q().func_187227_b(TARGET_ENTITY_ID, (Object)entityid);
    }

    public float getRoll() {
        return ((Float)this.func_184212_Q().func_187225_a(ROLL)).floatValue();
    }

    public void setRoll(float roll) {
        this.func_184212_Q().func_187227_b(ROLL, (Object)Float.valueOf(roll));
    }

    public int getLifeTime() {
        return (Integer)this.func_184212_Q().func_187225_a(LIFETIME);
    }

    public void setLifeTime(int lifetime) {
        this.func_184212_Q().func_187227_b(LIFETIME, (Object)lifetime);
    }

    public void doTargeting() {
        Entity target;
        int targetid = this.getTargetEntityId();
        if (targetid != 0 && (target = this.field_70170_p.func_73045_a(targetid)) != null) {
            if (Float.isNaN(this.iniPitch)) {
                this.iniYaw = this.thrower.field_70177_z;
                this.iniPitch = this.thrower.field_70125_A;
            }
            this.faceEntity(this, target, (float)this.field_70173_aa * 1.0f, (float)this.field_70173_aa * 1.0f);
            this.setDriveVector(1.75f, false);
        }
    }

    public void faceEntity(Entity viewer, Entity target, float yawStep, float pitchStep) {
        double d2;
        double d0 = target.field_70165_t - viewer.field_70165_t;
        double d1 = target.field_70161_v - viewer.field_70161_v;
        if (target instanceof EntityLivingBase) {
            EntityLivingBase entitylivingbase = (EntityLivingBase)target;
            d2 = entitylivingbase.field_70163_u + (double)entitylivingbase.func_70047_e() - (viewer.field_70163_u + (double)viewer.func_70047_e());
        } else {
            AxisAlignedBB boundingBox = target.func_174813_aQ();
            d2 = (boundingBox.field_72338_b + boundingBox.field_72337_e) / 2.0 - (viewer.field_70163_u + (double)viewer.func_70047_e());
        }
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1));
        float f2 = (float)(Math.atan2(d1, d0) * 180.0 / Math.PI) - 90.0f;
        float f3 = (float)(-(Math.atan2(d2, d3) * 180.0 / Math.PI));
        this.iniPitch = this.updateRotation(this.iniPitch, f3, pitchStep);
        this.iniYaw = this.updateRotation(this.iniYaw, f2, yawStep);
    }

    private float updateRotation(float par1, float par2, float par3) {
        float f3 = MathHelper.func_76142_g((float)(par2 - par1));
        if (f3 > par3) {
            f3 = par3;
        }
        if (f3 < -par3) {
            f3 = -par3;
        }
        return par1 + f3;
    }

    public void setDriveVector(float fYVecOfset) {
        this.setDriveVector(fYVecOfset, true);
    }

    public void setDriveVector(float fYVecOfst, boolean init) {
        float fYawDtoR = this.iniYaw / 180.0f * (float)Math.PI;
        float fPitDtoR = this.iniPitch / 180.0f * (float)Math.PI;
        this.field_70159_w = -MathHelper.func_76126_a((float)fYawDtoR) * MathHelper.func_76134_b((float)fPitDtoR) * fYVecOfst;
        this.field_70181_x = -MathHelper.func_76126_a((float)fPitDtoR) * fYVecOfst;
        this.field_70179_y = MathHelper.func_76134_b((float)fYawDtoR) * MathHelper.func_76134_b((float)fPitDtoR) * fYVecOfst;
        float f3 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
        this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / Math.PI);
        this.field_70125_A = (float)(Math.atan2(this.field_70181_x, f3) * 180.0 / Math.PI);
        if (init) {
            this.speed = fYVecOfst;
            this.field_70126_B = this.field_70177_z;
            this.field_70127_C = this.field_70125_A;
        }
    }

    public void func_70098_U() {
        Entity ridingEntity = this.ridingEntity2;
        if (ridingEntity.field_70128_L) {
            this.func_70106_y();
            return;
        }
        this.field_70142_S = this.field_70165_t;
        this.field_70137_T = this.field_70163_u;
        this.field_70136_U = this.field_70161_v;
        this.field_70165_t = ridingEntity.field_70165_t + (this.hitX * Math.cos(Math.toRadians(ridingEntity.field_70177_z)) - this.hitZ * Math.sin(Math.toRadians(ridingEntity.field_70177_z)));
        this.field_70163_u = ridingEntity.field_70163_u + this.hitY;
        this.field_70161_v = ridingEntity.field_70161_v + (this.hitX * Math.sin(Math.toRadians(ridingEntity.field_70177_z)) + this.hitZ * Math.cos(Math.toRadians(ridingEntity.field_70177_z)));
        this.field_70125_A = ridingEntity.field_70125_A + this.hitPitch;
        this.field_70177_z = ridingEntity.field_70177_z + this.hitYaw;
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.func_70101_b(this.field_70177_z, this.field_70125_A);
        if (this.field_70173_aa >= this.getLifeTime()) {
            if (!ridingEntity.field_70128_L) {
                float magicDamage = Math.max(1.0f, this.AttackLevel / 2.0f);
                ridingEntity.field_70172_ad = 0;
                DamageSource ds = new EntityDamageSource("directMagic", this.getThrower()).func_76348_h().func_82726_p();
                ridingEntity.func_70097_a(ds, magicDamage);
                if (!this.blade.func_190926_b() && ridingEntity instanceof EntityLivingBase) {
                    StylishRankManager.setNextAttackType(this.thrower, StylishRankManager.AttackTypes.BreakPhantomSword);
                    ((ItemSlashBlade)this.blade.func_77973_b()).func_77644_a(this.blade, (EntityLivingBase)ridingEntity, (EntityLivingBase)this.thrower);
                }
            }
            this.func_70106_y();
        }
    }

    public void func_70071_h_() {
        if (this.ridingEntity2 != null) {
            this.func_70098_U();
        } else {
            Entity target;
            this.field_70142_S = this.field_70165_t;
            this.field_70137_T = this.field_70163_u;
            this.field_70136_U = this.field_70161_v;
            double dAmbit = 0.75;
            AxisAlignedBB bb = new AxisAlignedBB(this.field_70165_t - dAmbit, this.field_70163_u - dAmbit, this.field_70161_v - dAmbit, this.field_70165_t + dAmbit, this.field_70163_u + dAmbit, this.field_70161_v + dAmbit);
            if (this.getThrower() instanceof EntityLivingBase) {
                EntityLivingBase entityLiving = (EntityLivingBase)this.getThrower();
                List list = this.field_70170_p.func_175674_a(this.getThrower(), bb, EntitySelectorDestructable.getInstance());
                StylishRankManager.setNextAttackType(this.thrower, StylishRankManager.AttackTypes.DestructObject);
                list.removeAll(this.alreadyHitEntity);
                this.alreadyHitEntity.addAll(list);
                for (Entity curEntity : list) {
                    if (this.blade.func_190926_b()) break;
                    boolean isDestruction = true;
                    if (curEntity instanceof EntityFireball) {
                        isDestruction = ((EntityFireball)curEntity).field_70235_a != null && ((EntityFireball)curEntity).field_70235_a.func_145782_y() == entityLiving.func_145782_y() ? false : !curEntity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)entityLiving), this.AttackLevel);
                    } else if (curEntity instanceof EntityArrow) {
                        if (((EntityArrow)curEntity).field_70250_c != null && ((EntityArrow)curEntity).field_70250_c.func_145782_y() == entityLiving.func_145782_y()) {
                            isDestruction = false;
                        }
                    } else if (curEntity instanceof IThrowableEntity) {
                        if (((IThrowableEntity)curEntity).getThrower() != null && ((IThrowableEntity)curEntity).getThrower().func_145782_y() == entityLiving.func_145782_y()) {
                            isDestruction = false;
                        }
                    } else if (curEntity instanceof EntityThrowable && ((EntityThrowable)curEntity).func_85052_h() != null && ((EntityThrowable)curEntity).func_85052_h().func_145782_y() == entityLiving.func_145782_y()) {
                        isDestruction = false;
                    }
                    if (!isDestruction) continue;
                    ReflectionAccessHelper.setVelocity(curEntity, 0.0, 0.0, 0.0);
                    curEntity.func_70106_y();
                    for (int var1 = 0; var1 < 10; ++var1) {
                        Random rand = this.getRand();
                        double var2 = rand.nextGaussian() * 0.02;
                        double var4 = rand.nextGaussian() * 0.02;
                        double var6 = rand.nextGaussian() * 0.02;
                        double var8 = 10.0;
                        this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, curEntity.field_70165_t + (double)(rand.nextFloat() * curEntity.field_70130_N * 2.0f) - (double)curEntity.field_70130_N - var2 * var8, curEntity.field_70163_u + (double)(rand.nextFloat() * curEntity.field_70131_O) - var4 * var8, curEntity.field_70161_v + (double)(rand.nextFloat() * curEntity.field_70130_N * 2.0f) - (double)curEntity.field_70130_N - var6 * var8, var2, var4, var6, new int[0]);
                    }
                    StylishRankManager.doAttack(this.thrower);
                    this.func_70106_y();
                    return;
                }
            }
            List list = this.field_70170_p.func_175674_a(this.getThrower(), bb, EntitySelectorAttackable.getInstance());
            list.removeAll(this.alreadyHitEntity);
            if (this.getTargetEntityId() != 0 && (target = this.field_70170_p.func_73045_a(this.getTargetEntityId())) != null && target.func_174813_aQ().func_72326_a(bb)) {
                list.add(target);
            }
            this.alreadyHitEntity.addAll(list);
            Vec3d Vec3d1 = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            Vec3d Vec3d2 = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
            double d0 = 10.0;
            Entity hitEntity = null;
            for (Entity curEntity : list) {
                double d1;
                if (!curEntity.func_70067_L() || !((d1 = (double)curEntity.func_70032_d((Entity)this)) < d0) && d0 != 0.0) continue;
                hitEntity = curEntity;
                d0 = d1;
            }
            if (hitEntity != null) {
                float magicDamage = Math.max(1.0f, this.AttackLevel);
                hitEntity.field_70172_ad = 0;
                DamageSource ds = new EntityDamageSource("directMagic", this.getThrower()).func_76348_h().func_82726_p();
                hitEntity.func_70097_a(ds, magicDamage);
                if (!this.blade.func_190926_b() && hitEntity instanceof EntityLivingBase) {
                    StylishRankManager.setNextAttackType(this.thrower, StylishRankManager.AttackTypes.PhantomSword);
                    ((ItemSlashBlade)this.blade.func_77973_b()).func_77644_a(this.blade, (EntityLivingBase)hitEntity, (EntityLivingBase)this.thrower);
                }
                this.mountEntity(hitEntity);
            }
            int nPosX = MathHelper.func_76128_c((double)this.field_70165_t);
            int nPosY = MathHelper.func_76128_c((double)this.field_70163_u);
            int nPosZ = MathHelper.func_76128_c((double)this.field_70161_v);
            if (this.ridingEntity2 == null && !this.field_70170_p.func_184144_a((Entity)this, this.func_174813_aQ()).isEmpty()) {
                this.func_70106_y();
                return;
            }
            if (7 < this.field_70173_aa) {
                this.field_70165_t += this.field_70159_w;
                this.field_70163_u += this.field_70181_x;
                this.field_70161_v += this.field_70179_y;
            } else {
                this.doTargeting();
            }
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            if (this.field_70173_aa >= this.getLifeTime()) {
                this.func_70106_y();
            }
        }
    }

    public void func_70106_y() {
        if (this.thrower instanceof EntityPlayer) {
            ((EntityPlayer)this.thrower).func_71009_b((Entity)this);
        }
        super.func_70106_y();
    }

    public Random getRand() {
        return this.field_70146_Z;
    }

    public boolean func_70038_c(double par1, double par3, double par5) {
        return false;
    }

    public void func_70091_d(MoverType moverType, double par1, double par3, double par5) {
    }

    protected void func_70081_e(int par1) {
    }

    public boolean func_70072_I() {
        return false;
    }

    public boolean func_70055_a(Material par1Material) {
        return false;
    }

    public boolean func_180799_ab() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b() {
        float f1 = 0.5f;
        if (f1 < 0.0f) {
            f1 = 0.0f;
        }
        if (f1 > 1.0f) {
            f1 = 1.0f;
        }
        int i = super.func_70070_b();
        int j = i & 0xFF;
        int k = i >> 16 & 0xFF;
        if ((j += (int)(f1 * 15.0f * 16.0f)) > 240) {
            j = 240;
        }
        return j | k << 16;
    }

    public float func_70013_c() {
        float f1 = super.func_70013_c();
        float f2 = 0.9f;
        f2 = f2 * f2 * f2 * f2;
        return f1 * (1.0f - f2) + f2;
    }

    protected void func_70037_a(NBTTagCompound nbttagcompound) {
    }

    protected void func_70014_b(NBTTagCompound nbttagcompound) {
    }

    public void mountEntity(Entity par1Entity) {
        if (par1Entity != null) {
            this.hitYaw = this.field_70177_z - par1Entity.field_70177_z;
            this.hitPitch = this.field_70125_A - par1Entity.field_70125_A;
            this.hitX = this.field_70165_t - par1Entity.field_70165_t;
            this.hitY = this.field_70163_u - par1Entity.field_70163_u;
            this.hitZ = this.field_70161_v - par1Entity.field_70161_v;
            this.ridingEntity2 = par1Entity;
            this.field_70173_aa = Math.max(0, this.getLifeTime() - 20);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void setPositionAndRotation2(double par1, double par3, double par5, float par7, float par8, int par9) {
    }

    public void func_181015_d(BlockPos p_181015_1_) {
    }

    public boolean func_70027_ad() {
        return false;
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 1;
    }

    public void func_70110_aj() {
    }

    public Entity getThrower() {
        return this.thrower;
    }

    public void setThrower(Entity entity) {
        this.thrower = entity;
    }
}

