/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.advancement;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.advancements.ICriterionTrigger;
import net.minecraft.advancements.PlayerAdvancements;
import net.minecraft.advancements.critereon.AbstractCriterionInstance;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.tslat.aoa3.library.Enums;

public class AoALevelUpTrigger
implements ICriterionTrigger<Instance> {
    private static final ResourceLocation triggerId = new ResourceLocation("aoa3", "level_up");
    private final HashMap<PlayerAdvancements, Listeners> listeners = new HashMap();

    public ResourceLocation func_192163_a() {
        return triggerId;
    }

    public void func_192165_a(PlayerAdvancements playerAdvancements, ICriterionTrigger.Listener<Instance> listener) {
        Listeners playerListeners = this.listeners.get(playerAdvancements);
        if (playerListeners == null) {
            playerListeners = new Listeners(playerAdvancements);
            this.listeners.put(playerAdvancements, playerListeners);
        }
        playerListeners.add(listener);
    }

    public void func_192164_b(PlayerAdvancements playerAdvancements, ICriterionTrigger.Listener<Instance> listener) {
        Listeners playerListeners = this.listeners.get(playerAdvancements);
        if (playerListeners != null) {
            playerListeners.remove(listener);
            if (playerListeners.isEmpty()) {
                this.listeners.remove(playerAdvancements);
            }
        }
    }

    public void func_192167_a(PlayerAdvancements playerAdvancements) {
        this.listeners.remove(playerAdvancements);
    }

    public Instance deserializeInstance(JsonObject json, JsonDeserializationContext context) {
        Enums.Skills skill = json.has("skill") ? Enums.Skills.valueOf(JsonUtils.func_151200_h((JsonObject)json, (String)"skill").toUpperCase()) : null;
        int lvl = json.has("level") ? JsonUtils.func_151203_m((JsonObject)json, (String)"level") : 0;
        return new Instance(skill, lvl);
    }

    public void trigger(EntityPlayerMP player, Enums.Skills skill, int level) {
        Listeners playerListeners = this.listeners.get(player.func_192039_O());
        if (playerListeners != null) {
            playerListeners.trigger(skill, level);
        }
    }

    static class Listeners {
        private final PlayerAdvancements advancements;
        private final HashSet<ICriterionTrigger.Listener<Instance>> listeners = new HashSet();

        public Listeners(PlayerAdvancements playerAdvancements) {
            this.advancements = playerAdvancements;
        }

        public boolean isEmpty() {
            return this.listeners.isEmpty();
        }

        public void add(ICriterionTrigger.Listener<Instance> listener) {
            this.listeners.add(listener);
        }

        public void remove(ICriterionTrigger.Listener<Instance> listener) {
            this.listeners.remove(listener);
        }

        public void trigger(Enums.Skills skill, int lvl) {
            ArrayList<ICriterionTrigger.Listener<Instance>> list = null;
            for (ICriterionTrigger.Listener<Instance> listener : this.listeners) {
                if (!((Instance)listener.func_192158_a()).test(skill, lvl)) continue;
                if (list == null) {
                    list = new ArrayList<ICriterionTrigger.Listener<Instance>>();
                }
                list.add(listener);
            }
            if (list != null) {
                for (ICriterionTrigger.Listener listener : list) {
                    listener.func_192159_a(this.advancements);
                }
            }
        }
    }

    public static class Instance
    extends AbstractCriterionInstance {
        @Nullable
        private final Enums.Skills skill;
        private final int level;

        public Instance(@Nullable Enums.Skills skill, int lvl) {
            super(triggerId);
            this.skill = skill;
            this.level = lvl;
        }

        public boolean test(Enums.Skills skill, int level) {
            return !(this.skill != null && this.skill != skill || this.level != 0 && this.level != level);
        }
    }
}

