/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.block.functional.crops;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.ForgeEventFactory;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.library.Enums;

public class CropBlock
extends BlockCrops {
    private static final AxisAlignedBB[] GROWTH_AABB = new AxisAlignedBB[]{new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.125, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.25, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.375, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.625, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.75, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.875, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0)};
    private IPlantable seeds;
    private Item crop;
    private boolean dropsSeeds;

    public CropBlock(String name, String registryName, boolean harvestDropsSeeds) {
        this.func_149663_c(name);
        this.setRegistryName("aoa3:" + registryName);
        this.func_149711_c(0.0f);
        this.func_149675_a(true);
        this.func_149649_H();
        this.func_149672_a(SoundType.field_185850_c);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)field_176488_a, (Comparable)Integer.valueOf(0)));
        this.dropsSeeds = harvestDropsSeeds;
    }

    protected int func_185529_b(World world) {
        return AdventOfAscension.rand.nextInt(3) + 1;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return GROWTH_AABB[(Integer)state.func_177229_b((IProperty)field_176488_a)];
    }

    public void setSeeds(IPlantable seeds) {
        this.seeds = seeds;
    }

    public void setCrop(Item crop) {
        if (this.crop == null) {
            this.crop = crop;
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (this.func_185527_x(state) >= this.func_185526_g()) {
            if (!world.field_72995_K) {
                NonNullList drops = NonNullList.func_191196_a();
                int fortune = Math.max(EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)player.func_184586_b(EnumHand.MAIN_HAND)), EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)player.func_184586_b(EnumHand.OFF_HAND)));
                this.getDrops((NonNullList<ItemStack>)drops, (IBlockAccess)world, pos, state, fortune);
                float dropChance = ForgeEventFactory.fireBlockHarvesting((List)drops, (World)world, (BlockPos)pos, (IBlockState)state, (int)fortune, (float)1.0f, (boolean)false, (EntityPlayer)player);
                for (ItemStack stack : drops) {
                    if (!(world.field_73012_v.nextFloat() <= dropChance)) continue;
                    CropBlock.func_180635_a((World)world, (BlockPos)pos, (ItemStack)stack);
                }
                world.func_180501_a(pos, this.func_176223_P(), Enums.BlockUpdateFlags.SYNC_CLIENT.value);
                ForgeEventFactory.onPlayerBlockPlace((EntityPlayer)player, (BlockSnapshot)BlockSnapshot.getBlockSnapshot((World)world, (BlockPos)pos), (EnumFacing)facing, (EnumHand)hand);
            }
            return true;
        }
        return false;
    }

    public void func_180653_a(World worldIn, BlockPos pos, IBlockState state, float chance, int fortune) {
        super.func_180653_a(worldIn, pos, state, chance, fortune + 1);
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        Random rand = world instanceof World ? ((World)world).field_73012_v : RANDOM;
        int count = this.quantityDropped(state, fortune, rand);
        for (int i = 0; i < count; ++i) {
            Item item = this.func_180660_a(state, rand, fortune);
            if (item == Items.field_190931_a) continue;
            drops.add((Object)new ItemStack(item, 1, this.func_180651_a(state)));
        }
        int age = this.func_185527_x(state);
        if (age >= this.func_185526_g()) {
            for (int i = 0; i < fortune + (this.dropsSeeds ? 3 : 1); ++i) {
                if (rand.nextInt(2 * this.func_185526_g()) > age) continue;
                drops.add((Object)new ItemStack(this.func_149866_i(), 1, 0));
            }
        }
    }

    public Item func_149865_P() {
        return this.crop;
    }

    protected Item func_149866_i() {
        return (Item)this.seeds;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{field_176488_a});
    }
}

