/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.block.functional.lamps;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.block.CustomStateMapperBlock;
import net.tslat.aoa3.block.functional.lights.LightBlock;
import net.tslat.aoa3.common.registration.CreativeTabsRegister;

public class LampBlock
extends LightBlock
implements CustomStateMapperBlock {
    public static final PropertyBool FIXED_LAMP = PropertyBool.func_177716_a((String)"fixed_state");
    protected boolean turnedOn = true;
    protected LampBlock offLamp;
    protected LampBlock onLamp;

    public LampBlock(String name, String registryName, Material material, float luminosity, float hardness, float resistance) {
        super(name, registryName, material, luminosity, hardness, resistance);
        this.func_149675_a(true);
        this.func_149647_a(CreativeTabsRegister.decorationBlocksTab);
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)FIXED_LAMP, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public StateMap getStateMapper() {
        return new StateMap.Builder().func_178442_a(new IProperty[]{FIXED_LAMP}).func_178441_a();
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (!world.field_72995_K) {
            if (this.turnedOn && !world.func_175640_z(pos)) {
                world.func_180501_a(pos, this.offLamp.func_176223_P(), 2);
            } else if (!this.turnedOn && world.func_175640_z(pos)) {
                world.func_180501_a(pos, this.onLamp.func_176223_P(), 2);
            }
        }
    }

    public LampBlock getOffLamp() {
        if (this.offLamp != null) {
            return this.offLamp;
        }
        LampBlock offLamp = new LampBlock(this.func_149739_a().replace("tile.", "") + "Off", this.getRegistryName().func_110623_a() + "_off", this.func_176223_P().func_185904_a(), 0.0f, this.field_149782_v, this.field_149781_w);
        offLamp.turnedOn = false;
        this.offLamp = offLamp;
        this.onLamp = this;
        offLamp.offLamp = offLamp;
        offLamp.onLamp = this.onLamp;
        this.onLamp.func_149647_a(null);
        return offLamp;
    }

    public LampBlock getOnLamp() {
        return this.onLamp;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        if (!world.field_72995_K && !((Boolean)state.func_177229_b((IProperty)FIXED_LAMP)).booleanValue()) {
            if (this.turnedOn && !world.func_175640_z(pos)) {
                world.func_175684_a(pos, (Block)this, 4);
            } else if (!this.turnedOn && world.func_175640_z(pos)) {
                world.func_180501_a(pos, this.onLamp.func_176223_P(), 2);
            }
        }
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!world.field_72995_K && !((Boolean)state.func_177229_b((IProperty)FIXED_LAMP)).booleanValue() && this.turnedOn && !world.func_175640_z(pos)) {
            world.func_180501_a(pos, this.offLamp.func_176223_P(), 2);
        }
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)this.offLamp);
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack((Block)this.offLamp);
    }

    public IBlockState func_176203_a(int meta) {
        if (meta == 0) {
            return this.func_176223_P();
        }
        return this.func_176223_P().func_177226_a((IProperty)FIXED_LAMP, (Comparable)Boolean.valueOf(true));
    }

    @Override
    public int func_149745_a(Random random) {
        return 1;
    }

    public int func_176201_c(IBlockState state) {
        if (((Boolean)state.func_177229_b((IProperty)FIXED_LAMP)).booleanValue()) {
            return 1;
        }
        return 0;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FIXED_LAMP});
    }

    protected ItemStack func_180643_i(IBlockState state) {
        return new ItemStack((Block)this.offLamp);
    }
}

