/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.block.functional.misc;

import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.tslat.aoa3.block.functional.misc.CarvedRunicBlock;
import net.tslat.aoa3.block.functional.portal.PortalBlock;
import net.tslat.aoa3.common.registration.BlockRegister;
import net.tslat.aoa3.item.misc.BlankRealmstone;
import net.tslat.aoa3.item.misc.Realmstone;
import net.tslat.aoa3.library.misc.AoAPortalFrame;
import net.tslat.aoa3.utils.StringUtil;

public class CarvedRunicPortalBlock
extends CarvedRunicBlock {
    public CarvedRunicPortalBlock(String name, String registryName) {
        super(name, registryName);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (state.func_177230_c() == BlockRegister.carvedRunePower) {
            if (!world.field_72995_K) {
                if (player.func_184586_b(hand).func_77973_b() instanceof Realmstone) {
                    Realmstone realmstone = (Realmstone)player.func_184586_b(hand).func_77973_b();
                    PortalBlock portalBlock = realmstone.getPortalBlock();
                    AoAPortalFrame.PortalDirection direction = AoAPortalFrame.testFrameForActivation(world, pos, facing, portalBlock);
                    if (direction == AoAPortalFrame.PortalDirection.EXISTING) {
                        player.func_145747_a((ITextComponent)StringUtil.getLocale("message.feedback.teleporterFrame.existing"));
                    } else if (direction == AoAPortalFrame.PortalDirection.INVALID) {
                        player.func_145747_a((ITextComponent)StringUtil.getLocale("message.feedback.teleporterFrame.fail"));
                    } else {
                        AoAPortalFrame.lightPortalFrame(world, pos, direction, portalBlock);
                        player.func_145747_a((ITextComponent)StringUtil.getLocale("message.feedback.teleporterFrame." + realmstone.getMsgSuffix()));
                        world.func_184148_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), realmstone.getPortalSound(), SoundCategory.MASTER, 1.0f, 1.0f);
                    }
                } else if (player.func_184586_b(hand).func_77973_b() instanceof BlankRealmstone && world.func_180495_p(pos.func_177972_a(EnumFacing.UP)).func_177230_c() instanceof PortalBlock) {
                    world.func_175698_g(pos.func_177972_a(EnumFacing.UP));
                }
            }
            return true;
        }
        return false;
    }
}

