/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.block.functional.portal;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.block.UnbreakableBlock;
import net.tslat.aoa3.block.functional.misc.CarvedRunicPortalBlock;
import net.tslat.aoa3.client.fx.FXPortalFloater;
import net.tslat.aoa3.common.registration.BlockRegister;
import net.tslat.aoa3.dimension.AoATeleporter;
import net.tslat.aoa3.dimension.AoAWorldProvider;
import net.tslat.aoa3.dimension.nether.NetherTeleporter;
import net.tslat.aoa3.library.misc.PortalCoordinatesContainer;
import net.tslat.aoa3.utils.ConfigurationUtil;
import net.tslat.aoa3.utils.EntityUtil;
import net.tslat.aoa3.utils.player.PlayerDataManager;
import net.tslat.aoa3.utils.player.PlayerUtil;

public class PortalBlock
extends UnbreakableBlock {
    private static final AxisAlignedBB latAABB = new AxisAlignedBB(0.375, 0.0, 0.0, 0.625, 1.0, 1.0);
    private static final AxisAlignedBB longAABB = new AxisAlignedBB(0.0, 0.0, 0.375, 1.0, 1.0, 0.625);
    private final int dimId;
    private final int particleColour;

    public PortalBlock(String name, String registryName, int dimId, int particleColour) {
        super(name, registryName, Material.field_151567_E);
        this.dimId = dimId;
        this.particleColour = particleColour;
        this.func_149647_a(null);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)EnumFacing.NORTH));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch ((EnumFacing)state.func_177229_b((IProperty)BlockHorizontal.field_185512_D)) {
            case NORTH: 
            case SOUTH: {
                return longAABB;
            }
        }
        return latAABB;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return field_185506_k;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState state, IBlockAccess access, BlockPos pos, EnumFacing side) {
        IBlockState adjacent = access.func_180495_p(pos.func_177972_a(side));
        if (adjacent.func_177230_c() == this) {
            switch ((EnumFacing)state.func_177229_b((IProperty)BlockHorizontal.field_185512_D)) {
                case NORTH: 
                case SOUTH: {
                    EnumFacing direction = (EnumFacing)adjacent.func_177229_b((IProperty)BlockHorizontal.field_185512_D);
                    if (direction != EnumFacing.SOUTH && direction != EnumFacing.NORTH) break;
                    return false;
                }
                case EAST: 
                case WEST: {
                    EnumFacing direction = (EnumFacing)adjacent.func_177229_b((IProperty)BlockHorizontal.field_185512_D);
                    if (direction != EnumFacing.EAST && direction != EnumFacing.WEST) break;
                    return false;
                }
            }
        }
        return true;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    public boolean func_149710_n(IBlockState state) {
        return true;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block changedBlock, BlockPos changedPos) {
        if (this.isCompatibleNeighbour(changedBlock.func_176223_P())) {
            EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)BlockHorizontal.field_185512_D);
            switch (facing) {
                case NORTH: 
                case SOUTH: {
                    if (this.isCompatibleNeighbour(world.func_180495_p(pos.func_177984_a())) && this.isCompatibleNeighbour(world.func_180495_p(pos.func_177977_b())) && this.isCompatibleNeighbour(world.func_180495_p(pos.func_177974_f())) && this.isCompatibleNeighbour(world.func_180495_p(pos.func_177976_e()))) break;
                    world.func_175698_g(pos);
                    break;
                }
                case EAST: 
                case WEST: {
                    if (this.isCompatibleNeighbour(world.func_180495_p(pos.func_177984_a())) && this.isCompatibleNeighbour(world.func_180495_p(pos.func_177977_b())) && this.isCompatibleNeighbour(world.func_180495_p(pos.func_177978_c())) && this.isCompatibleNeighbour(world.func_180495_p(pos.func_177968_d()))) break;
                    world.func_175698_g(pos);
                }
            }
        }
    }

    public void func_180649_a(World world, BlockPos pos, EntityPlayer player) {
        if (world.func_175623_d(pos.func_177984_a()) || world.func_175623_d(pos.func_177977_b())) {
            world.func_175698_g(pos);
            return;
        }
        switch ((EnumFacing)world.func_180495_p(pos).func_177229_b((IProperty)BlockHorizontal.field_185512_D)) {
            case NORTH: 
            case SOUTH: {
                if (!world.func_175623_d(pos.func_177974_f()) && !world.func_175623_d(pos.func_177976_e())) break;
                world.func_175698_g(pos);
                break;
            }
            case EAST: 
            case WEST: {
                if (!world.func_175623_d(pos.func_177978_c()) && !world.func_175623_d(pos.func_177968_d())) break;
                world.func_175698_g(pos);
            }
        }
    }

    private boolean isCompatibleNeighbour(IBlockState state) {
        Block bl = state.func_177230_c();
        return bl == BlockRegister.ancientRock || bl instanceof CarvedRunicPortalBlock || bl == this;
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (!(world.field_72995_K || entity.func_184218_aH() || entity.func_184207_aI())) {
            if (!ConfigurationUtil.MainConfig.allowNonPlayerPortalTravel & !(entity instanceof EntityPlayer)) {
                return;
            }
            if (entity.field_71088_bW > 0) {
                entity.field_71088_bW = 30;
                return;
            }
            WorldProvider provider = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a((int)this.dimId).field_73011_w;
            AoATeleporter teleporter = provider instanceof AoAWorldProvider ? ((AoAWorldProvider)provider).getTeleporter((WorldServer)world) : (this.dimId == -1 ? new NetherTeleporter((WorldServer)world) : ((WorldServer)world).func_85176_s());
            PortalCoordinatesContainer portalLoc = null;
            if (entity instanceof EntityPlayer) {
                PlayerDataManager plData = PlayerUtil.getAdventPlayer((EntityPlayer)((EntityPlayerMP)entity));
                portalLoc = plData.getPortalReturnLocation(world.field_73011_w.getDimension());
                ((EntityPlayerMP)entity).field_71135_a.func_147364_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), entity.field_70177_z, entity.field_70125_A);
            } else {
                entity.func_70634_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
            }
            entity = portalLoc == null ? (world.field_73011_w.getDimension() == this.dimId ? entity.changeDimension(0, (ITeleporter)teleporter) : entity.changeDimension(this.dimId, (ITeleporter)teleporter)) : (world.field_73011_w.getDimension() != this.dimId ? entity.changeDimension(this.dimId, (ITeleporter)teleporter) : entity.changeDimension(portalLoc.fromDim, (ITeleporter)teleporter));
            if (entity != null) {
                entity.field_71088_bW = 100;
            }
        }
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)EntityUtil.getDirectionFacing((Entity)placer, true));
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return ItemStack.field_190927_a;
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    public BlockFaceShape func_193383_a(IBlockAccess p_193383_1_, IBlockState p_193383_2_, BlockPos p_193383_3_, EnumFacing p_193383_4_) {
        return BlockFaceShape.UNDEFINED;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BlockHorizontal.field_185512_D});
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)BlockHorizontal.field_185512_D)).func_176736_b();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)EnumFacing.func_176731_b((int)meta));
    }

    public int getParticleColour() {
        return this.particleColour;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState blockState, World world, BlockPos pos, Random rand) {
        for (int i = 0; i < 4; ++i) {
            double posXStart = (float)pos.func_177958_n() + rand.nextFloat();
            double posYStart = (float)pos.func_177956_o() + rand.nextFloat();
            double posZStart = (float)pos.func_177952_p() + rand.nextFloat();
            double motionX = ((double)rand.nextFloat() - 0.5) * 0.5;
            double motionY = ((double)rand.nextFloat() - 0.5) * 0.5;
            double motionZ = ((double)rand.nextFloat() - 0.5) * 0.5;
            int randomMod = rand.nextInt(2) * 2 - 1;
            if (world.func_180495_p(pos.func_177976_e()).func_177230_c() != this && world.func_180495_p(pos.func_177974_f()).func_177230_c() != this) {
                posXStart = (double)pos.func_177958_n() + 0.5 + 0.25 * (double)randomMod;
                motionX = rand.nextFloat() * 2.0f * (float)randomMod;
            } else {
                posZStart = (double)pos.func_177952_p() + 0.5 + 0.25 * (double)randomMod;
                motionZ = rand.nextFloat() * 2.0f * (float)randomMod;
            }
            new FXPortalFloater(world, posXStart, posYStart, posZStart, motionX, motionY, motionZ, this.getParticleColour(), new float[0]).create();
        }
    }
}

