/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.block.functional.utility;

import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.ItemRegister;
import net.tslat.aoa3.entity.boss.flash.EntityFlash;
import net.tslat.aoa3.entity.boss.klobber.EntityKlobber;
import net.tslat.aoa3.entity.boss.mirage.EntityMirage;
import net.tslat.aoa3.entity.boss.proshield.EntityProshield;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.ItemUtil;
import net.tslat.aoa3.utils.StringUtil;
import net.tslat.aoa3.utils.player.PlayerDataManager;
import net.tslat.aoa3.utils.player.PlayerUtil;

public class ImmortallisProgressor
extends Block {
    private final int place;

    public ImmortallisProgressor(String name, String registryName, int place) {
        super(Material.field_151576_e);
        this.func_149663_c(name);
        this.setRegistryName("aoa3:" + registryName);
        this.func_149711_c(-1.0f);
        this.func_149752_b(1.0E9f);
        this.place = place;
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149647_a(null);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            switch (this.place) {
                case 1: {
                    if (!ItemUtil.consumeItem(player, new ItemStack((Item)ItemRegister.progressCoin0))) break;
                    if (!player.func_191521_c(new ItemStack((Item)ItemRegister.returnCrystal))) {
                        PlayerDataManager plData = PlayerUtil.getAdventPlayer(player);
                        plData.sendThrottledChatMessage("message.feedback.item.returnCrystal.noSpace", new Object[0]);
                        plData.stats().resetAllTribute();
                        player.func_70099_a(new ItemStack((Item)ItemRegister.progressCoin0), 0.5f);
                    } else {
                        player.func_145747_a((ITextComponent)StringUtil.getColourLocale("message.feedback.immortallisProgression.goldStart.0", TextFormatting.GOLD));
                        player.func_145747_a((ITextComponent)StringUtil.getColourLocale("message.feedback.immortallisProgression.goldStart.1", TextFormatting.GOLD));
                        player.func_70634_a(28.0, 20.0, 2.0);
                    }
                    return true;
                }
                case 2: {
                    if (PlayerUtil.getAdventPlayer(player).stats().getTribute(Enums.Deities.PLUTON) < 100) break;
                    EntityKlobber klobber = new EntityKlobber(world);
                    klobber.func_70634_a(69.0, 21.0, 4.0);
                    world.func_72838_d((Entity)klobber);
                    player.func_70634_a(67.0, 21.0, 2.0);
                    player.func_145747_a((ITextComponent)StringUtil.getColourLocale("message.feedback.immortallisProgression.klobberStart", TextFormatting.DARK_AQUA));
                    return true;
                }
                case 3: {
                    if (!ItemUtil.consumeItem(player, new ItemStack((Item)ItemRegister.progressCoin1))) break;
                    player.func_145747_a((ITextComponent)StringUtil.getColourLocale("message.feedback.immortallisProgression.skeletalSpiritsStart", TextFormatting.RED));
                    player.func_70634_a(81.0, 21.0, 2.0);
                    return true;
                }
                case 4: {
                    if (PlayerUtil.getAdventPlayer(player).stats().getTribute(Enums.Deities.EREBON) < 100) break;
                    EntityProshield proshield = new EntityProshield(world);
                    proshield.func_70634_a(123.0, 21.0, 6.0);
                    world.func_72838_d((Entity)proshield);
                    player.func_70634_a(122.0, 21.0, 2.0);
                    player.func_145747_a((ITextComponent)StringUtil.getColourLocale("message.feedback.immortallisProgression.proshieldStart", TextFormatting.DARK_AQUA));
                    return true;
                }
                case 5: {
                    if (!ItemUtil.consumeItem(player, new ItemStack((Item)ItemRegister.progressCoin2))) break;
                    player.func_145747_a((ITextComponent)StringUtil.getColourLocale("message.feedback.immortallisProgression.pureGoldStart.0", TextFormatting.GOLD));
                    player.func_145747_a((ITextComponent)StringUtil.getColourLocale("message.feedback.immortallisProgression.pureGoldStart.1", TextFormatting.GOLD));
                    player.func_70634_a(141.0, 24.0, 2.0);
                    return true;
                }
                case 6: {
                    if (PlayerUtil.getAdventPlayer(player).stats().getTribute(Enums.Deities.PLUTON) != 200) break;
                    EntityMirage mirage = new EntityMirage(world);
                    mirage.func_70634_a(177.0, 24.0, -2.0);
                    world.func_72838_d((Entity)mirage);
                    player.func_70634_a(168.0, 24.0, 7.0);
                    player.func_145747_a((ITextComponent)StringUtil.getColourLocale("message.feedback.immortallisProgression.mirageStart", TextFormatting.DARK_AQUA));
                    return true;
                }
                case 7: {
                    if (!ItemUtil.consumeItem(player, new ItemStack((Item)ItemRegister.progressCoin3))) break;
                    player.func_145747_a((ITextComponent)StringUtil.getColourLocale("message.feedback.immortallisProgression.evilSpiritsStart", TextFormatting.RED));
                    player.func_70634_a(189.0, 20.0, 2.0);
                    return true;
                }
                case 8: {
                    if (PlayerUtil.getAdventPlayer(player).stats().getTribute(Enums.Deities.EREBON) != 200) break;
                    EntityFlash flash = new EntityFlash(world);
                    flash.func_70634_a(235.0, 22.0, 10.0);
                    world.func_72838_d((Entity)flash);
                    player.func_70634_a(233.0, 21.0, 3.0);
                    player.func_145747_a((ITextComponent)StringUtil.getColourLocale("message.feedback.immortallisProgression.flashStart", TextFormatting.DARK_AQUA));
                    return true;
                }
                case 9: {
                    if (!ItemUtil.consumeItem(player, new ItemStack((Item)ItemRegister.progressCoin4))) break;
                    player.func_70634_a(0.0, 20.0, 0.0);
                    ItemUtil.consumeItem(player, new ItemStack((Item)ItemRegister.returnCrystal));
                    PlayerUtil.getAdventPlayer(player).stats().resetAllTribute();
                    return true;
                }
            }
        }
        return true;
    }
}

