/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.block.functional.utility;

import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.common.registration.CreativeTabsRegister;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.item.misc.InfusionStone;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.ItemUtil;
import net.tslat.aoa3.utils.player.PlayerDataManager;
import net.tslat.aoa3.utils.player.PlayerUtil;

public class InfusionTable
extends Block {
    public InfusionTable() {
        super(Material.field_151576_e);
        this.func_149663_c("InfusionTable");
        this.setRegistryName("aoa3:infusion_table");
        this.func_149711_c(10.0f);
        this.func_149752_b(15.0f);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149647_a(CreativeTabsRegister.functionalBlocksTab);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            ItemStack stack = player.func_184586_b(hand);
            Item item = stack.func_77973_b();
            if (item instanceof InfusionStone) {
                PlayerDataManager plData = PlayerUtil.getAdventPlayer(player);
                InfusionStone stone = (InfusionStone)item;
                int count = stack.func_190916_E();
                if (player.field_71075_bZ.field_75098_d || plData.stats().getLevel(Enums.Skills.INFUSION) >= stone.getLvl()) {
                    plData.stats().addXp(Enums.Skills.INFUSION, stone.getXp() * (float)count, false, false);
                    world.func_184148_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundsRegister.infusionSuccess, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    int chanceMod = plData.equipment().getCurrentFullArmourSet() == Enums.ArmourSets.INFUSION ? 33 : 100;
                    int powerStoneCount = 0;
                    for (int i = 0; i < count; ++i) {
                        if (AdventOfAscension.rand.nextInt(chanceMod) != 0) continue;
                        ++powerStoneCount;
                    }
                    if (!player.field_71075_bZ.field_75098_d) {
                        if (powerStoneCount > 0) {
                            player.func_184611_a(hand, new ItemStack(stone.getPowerStone(), powerStoneCount));
                        } else {
                            player.func_184611_a(hand, ItemStack.field_190927_a);
                        }
                    } else {
                        ItemUtil.givePlayerItemOrDrop(player, new ItemStack(stone.getPowerStone(), powerStoneCount));
                    }
                }
            } else {
                player.openGui((Object)AdventOfAscension.instance(), Enums.ModGuis.INFUSION_TABLE.guiId, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            }
        }
        return true;
    }
}

