/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.fx;

import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.client.render.FXRenders;

@SideOnly(value=Side.CLIENT)
public class FXLastingFluffyTrail
extends Particle {
    public static final int particleId = 3;
    public static final ResourceLocation texture = new ResourceLocation("aoa3", "fx/fluffy_trail");
    public final int textureOffsetIndex;

    public FXLastingFluffyTrail(World world, double posX, double posY, double posZ, int colour) {
        this(world, posX, posY, posZ, 0.0, 0.0, 0.0, colour, 0, 1.0f);
    }

    public FXLastingFluffyTrail(World world, double posX, double posY, double posZ, double speedX, double speedY, double speedZ, int colour, int textureOffsetIndex, float scale) {
        super(world, posX, posY, posZ, speedX, speedY, speedZ);
        this.textureOffsetIndex = textureOffsetIndex;
        this.field_187129_i = speedX + (double)((float)(Math.random() * 2.0 - 1.0) * 0.05f);
        this.field_187130_j = speedY + (double)((float)(Math.random() * 2.0 - 1.0) * 0.05f);
        this.field_187131_k = speedZ + (double)((float)(Math.random() * 2.0 - 1.0) * 0.05f);
        this.field_70544_f = (this.field_187136_p.nextFloat() * this.field_187136_p.nextFloat() * 6.0f + 1.0f) * scale;
        this.field_70547_e = (int)(20.0 / ((double)this.field_187136_p.nextFloat() * 0.8 + 0.2));
        this.field_70552_h = (float)(colour >> 16) / 255.0f;
        this.field_70553_i = (float)(colour >> 8 & 0xFF) / 255.0f;
        this.field_70551_j = (float)(colour & 0xFF) / 255.0f;
        this.field_82339_as = (float)(colour >> 24) / 255.0f;
        if (this.field_82339_as == 0.0f) {
            this.field_82339_as = 1.0f;
        }
        this.func_187117_a(Minecraft.func_71410_x().func_147117_R().func_110572_b(texture.toString()));
    }

    public int func_70537_b() {
        return this.field_187119_C == null ? 1 : 0;
    }

    public boolean func_187111_c() {
        return false;
    }

    public void func_189213_a() {
        this.field_187123_c = this.field_187126_f;
        this.field_187124_d = this.field_187127_g;
        this.field_187125_e = this.field_187128_h;
        if (this.field_70546_d++ >= this.field_70547_e) {
            this.func_187112_i();
        }
        int textureIndex = 7 - this.field_70546_d * this.textureOffsetIndex / this.field_70547_e;
        this.field_94054_b = textureIndex % 16;
        this.field_94055_c = textureIndex / 16;
        this.field_187130_j += 0.004;
        this.field_187129_i *= (double)0.9f;
        this.field_187130_j *= (double)0.9f;
        this.field_187131_k *= (double)0.9f;
        if (this.field_187132_l) {
            this.field_187129_i *= (double)0.7f;
            this.field_187131_k *= (double)0.7f;
        }
    }

    public void func_180434_a(BufferBuilder buffer, Entity entity, float partialTick, float edgeLRdirectionX, float edgeUDdirectionY, float edgeLRdirectionZ, float edgeUDdirectionX, float edgeUDdirectionZ) {
        double minU = (float)this.field_94054_b / 16.0f;
        double maxU = minU + (double)0.0624375f;
        double minV = (float)this.field_94055_c / 16.0f;
        double maxV = minV + (double)0.0624375f;
        double x = this.field_187123_c + (this.field_187126_f - this.field_187123_c) * (double)partialTick - field_70556_an;
        double y = this.field_187124_d + (this.field_187127_g - this.field_187124_d) * (double)partialTick - field_70554_ao;
        double z = this.field_187125_e + (this.field_187128_h - this.field_187125_e) * (double)partialTick - field_70555_ap;
        double scale = 0.1f * this.field_70544_f;
        double scaledUDDirX = (double)edgeUDdirectionX * scale;
        double scaledUDDirY = (double)edgeUDdirectionY * scale;
        double scaledUDDirZ = (double)edgeUDdirectionZ * scale;
        double scaledLRDirX = (double)edgeLRdirectionX * scale;
        double scaledLRDirZ = (double)edgeLRdirectionZ * scale;
        int combinedBrightness = this.func_189214_a(partialTick);
        int skyLightTimes16 = combinedBrightness >> 16 & 0xFFFF;
        int blockLightTimes16 = combinedBrightness & 0xFFFF;
        buffer.func_181662_b(x - scaledLRDirX - scaledUDDirX, y - scaledUDDirY, z - scaledLRDirZ - scaledUDDirZ).func_187315_a(maxU, maxV).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(skyLightTimes16, blockLightTimes16).func_181675_d();
        buffer.func_181662_b(x - scaledLRDirX + scaledUDDirX, y + scaledUDDirY, z - scaledLRDirZ + scaledUDDirZ).func_187315_a(maxU, minV).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(skyLightTimes16, blockLightTimes16).func_181675_d();
        buffer.func_181662_b(x + scaledLRDirX + scaledUDDirX, y + scaledUDDirY, z + scaledLRDirZ + scaledUDDirZ).func_187315_a(minU, minV).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(skyLightTimes16, blockLightTimes16).func_181675_d();
        buffer.func_181662_b(x + scaledLRDirX - scaledUDDirX, y - scaledUDDirY, z + scaledLRDirZ - scaledUDDirZ).func_187315_a(minU, maxV).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(skyLightTimes16, blockLightTimes16).func_181675_d();
    }

    public void create() {
        Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)this);
    }

    @SideOnly(value=Side.CLIENT)
    public static class Factory
    implements FXRenders.FXFactory {
        @Override
        @Nullable
        public Particle createParticle(double posX, double posY, double posZ, double velocityX, double velocityY, double velocityZ, int textureOffsetIndex, float scale, int ... args) {
            FXLastingFluffyTrail particle = new FXLastingFluffyTrail((World)Minecraft.func_71410_x().field_71441_e, posX, posY, posZ, velocityX, velocityY, velocityZ, args.length > 0 ? args[0] : 0xFFFFFF, textureOffsetIndex, scale);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)particle);
            return particle;
        }
    }
}

