/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.gui.mainwindow;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.IProgressMeter;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.CPacketClientStatus;
import net.minecraft.stats.StatisticsManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.client.gui.lib.ScrollablePane;
import net.tslat.aoa3.client.gui.mainwindow.AdventMainGui;
import net.tslat.aoa3.entity.base.AoAAmbientNPC;
import net.tslat.aoa3.entity.base.AoAFlyingMeleeMob;
import net.tslat.aoa3.entity.base.AoAFlyingRangedMob;
import net.tslat.aoa3.entity.base.AoAMeleeMob;
import net.tslat.aoa3.entity.base.AoARangedAttacker;
import net.tslat.aoa3.entity.base.AoARangedMob;
import net.tslat.aoa3.entity.base.AoATrader;
import net.tslat.aoa3.entity.properties.BossEntity;
import net.tslat.aoa3.entity.properties.SpecialPropertyEntity;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.ModUtil;
import net.tslat.aoa3.utils.RenderUtil;
import net.tslat.aoa3.utils.StringUtil;
import net.tslat.aoa3.utils.skills.HunterUtil;

@SideOnly(value=Side.CLIENT)
public class AdventGuiTabBestiary
extends GuiScreen
implements IProgressMeter {
    private static final ResourceLocation iconsTextures = new ResourceLocation("aoa3", "textures/gui/maingui/icons.png");
    public static String currentLanguage = FMLCommonHandler.instance().getCurrentLanguage();
    private StatisticsManager stats;
    private BestiaryMenu scrollMenu;
    private ArrayList<EntityList.EntityEggInfo> mobList;
    private boolean receivedStats = false;
    private int lastOpenIndex = -1;
    private int openEntryIndex = -1;
    private int openEntryHeight = 0;
    private long lastSelectionTime = 0L;
    private float lastDistanceScrolled = 0.0f;
    private EntityLivingBase openEntryInstance = null;
    private List<String> openEntryInfoLines = null;
    private List<String> openEntryStatsLines = null;
    private int adjustedMouseX;
    private int adjustedMouseY;

    public void func_73866_w_() {
        this.receivedStats = false;
        this.openEntryIndex = -1;
        this.stats = this.field_146297_k.field_71439_g.func_146107_m();
        currentLanguage = FMLCommonHandler.instance().getCurrentLanguage();
        if (this.scrollMenu == null) {
            this.scrollMenu = new BestiaryMenu(this.field_146297_k, AdventMainGui.scaledTabRootY, AdventMainGui.scaledTabRootX, 340, 764, 0.45f);
        }
        this.field_146297_k.func_147114_u().func_147297_a((Packet)new CPacketClientStatus(CPacketClientStatus.State.REQUEST_STATS));
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.adjustedMouseX = (int)((float)mouseX * 2.2222223f);
        this.adjustedMouseY = (int)((float)mouseY * 2.2222223f);
        this.scrollMenu.drawScreen(this.adjustedMouseX, this.adjustedMouseY, partialTicks);
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        this.scrollMenu.handleMouseInput(-1, -1);
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        if (this.scrollMenu != null) {
            this.scrollMenu.handleMouseInput(this.adjustedMouseX, this.adjustedMouseY);
        }
    }

    public void func_175273_b(Minecraft mcIn, int w, int h) {
        super.func_175273_b(mcIn, w, h);
        if (this.scrollMenu != null) {
            this.scrollMenu.onResize(this.field_146297_k, AdventMainGui.scaledTabRootX, AdventMainGui.scaledTabRootY, 764, 340);
        }
    }

    public void func_193026_g() {
        this.mobList = new ArrayList();
        for (EntityList.EntityEggInfo entityEggInfo : EntityList.field_75627_a.values()) {
            if (entityEggInfo.field_151512_d == null || this.stats.func_77444_a(entityEggInfo.field_151512_d) <= 0) continue;
            this.mobList.add(entityEggInfo);
        }
        this.mobList.sort(Comparator.comparing(eggInfo -> eggInfo.field_75613_a.func_110623_a()));
        this.receivedStats = true;
    }

    @Nullable
    private EntityLivingBase getEntityFromEgg(EntityList.EntityEggInfo eggInfo) {
        EntityLivingBase entity = null;
        try {
            entity = (EntityLivingBase)((EntityEntry)ForgeRegistries.ENTITIES.getValue(eggInfo.field_75613_a)).getEntityClass().getConstructor(World.class).newInstance(this.field_146297_k.field_71439_g.field_70170_p);
        }
        catch (Exception e) {
            AdventOfAscension.logOptionalMessage("Unable to retrieve entity from egg info: " + eggInfo.field_75613_a.toString());
        }
        return entity;
    }

    private void gatherEntityStats(EntityList.EntityEggInfo eggInfo) {
        this.openEntryInstance = this.getEntityFromEgg(eggInfo);
        this.openEntryStatsLines = new ArrayList<String>();
        this.openEntryInfoLines = new ArrayList<String>(0);
        if (this.openEntryInstance != null) {
            String info;
            IAttributeInstance attackAttribute;
            String attribute;
            String type = this.openEntryInstance instanceof BossEntity ? StringUtil.getLocaleString("gui.aoamain.bestiary.type.boss") : (this.openEntryInstance instanceof AoAMeleeMob ? (this.openEntryInstance instanceof AoARangedAttacker ? StringUtil.getLocaleString("gui.aoamain.bestiary.type.hybrid") : StringUtil.getLocaleString("gui.aoamain.bestiary.type.melee")) : (this.openEntryInstance instanceof AoARangedMob ? StringUtil.getLocaleString("gui.aoamain.bestiary.type.ranged") : (this.openEntryInstance instanceof AoAFlyingMeleeMob ? StringUtil.getLocaleString("gui.aoamain.bestiary.type.flyingMelee") : (this.openEntryInstance instanceof AoAFlyingRangedMob ? StringUtil.getLocaleString("gui.aoamain.bestiary.type.flyingRanged") : (this.openEntryInstance instanceof EntityAnimal ? StringUtil.getLocaleString("gui.aoamain.bestiary.type.animal") : (this.openEntryInstance instanceof AoAAmbientNPC ? StringUtil.getLocaleString("gui.aoamain.bestiary.type.ambient") : (this.openEntryInstance instanceof AoATrader ? StringUtil.getLocaleString("gui.aoamain.bestiary.type.trader") : (eggInfo.field_75613_a.func_110624_b().equals("aoa3") ? StringUtil.getLocaleString("gui.aoamain.bestiary.type.other") : (this.openEntryInstance instanceof IRangedAttackMob ? StringUtil.getLocaleString("gui.aoamain.bestiary.type.ranged") : StringUtil.getLocaleString("gui.aoamain.bestiary.type.melee"))))))))));
            switch (this.openEntryInstance.func_70668_bt()) {
                case ARTHROPOD: {
                    attribute = StringUtil.getLocaleString("gui.aoamain.bestiary.attribute.arthropod");
                    break;
                }
                case ILLAGER: {
                    attribute = StringUtil.getLocaleString("gui.aoamain.bestiary.attribute.illager");
                    break;
                }
                case UNDEAD: {
                    attribute = StringUtil.getLocaleString("gui.aoamain.bestiary.attribute.undead");
                    break;
                }
                default: {
                    attribute = StringUtil.getLocaleString("gui.aoamain.bestiary.attribute.none");
                }
            }
            this.openEntryStatsLines.add(TextFormatting.BOLD + StringUtil.getLocaleString("gui.aoamain.bestiary.type") + TextFormatting.RESET + " " + type);
            if (HunterUtil.isHunterCreature(this.openEntryInstance)) {
                this.openEntryStatsLines.add(TextFormatting.BOLD + StringUtil.getLocaleString("gui.aoamain.bestiary.hunterReq") + TextFormatting.RESET + " " + HunterUtil.getHunterLevel(this.openEntryInstance));
                this.openEntryStatsLines.add(TextFormatting.BOLD + StringUtil.getLocaleString("gui.aoamain.bestiary.hunterXp") + TextFormatting.RESET + " " + HunterUtil.getHunterXp(this.openEntryInstance));
            }
            if (this.openEntryInstance instanceof SpecialPropertyEntity) {
                this.openEntryStatsLines.add(TextFormatting.BOLD + StringUtil.getLocaleString("gui.aoamain.bestiary.immunity.immunities"));
                for (Enums.MobProperties property : ((SpecialPropertyEntity)this.openEntryInstance).getMobProperties()) {
                    this.openEntryStatsLines.add("    " + StringUtil.getLocaleString("gui.aoamain.bestiary.immunity." + property.toString().toLowerCase()));
                }
            }
            this.openEntryStatsLines.add(TextFormatting.BOLD + StringUtil.getLocaleString("gui.aoamain.bestiary.attribute") + TextFormatting.RESET + " " + attribute);
            this.openEntryStatsLines.add(TextFormatting.BOLD + StringUtil.getLocaleString("gui.aoamain.bestiary.size") + TextFormatting.RESET + " " + (float)((int)(this.openEntryInstance.field_70130_N * 1000.0f)) / 1000.0f + "x" + (float)((int)(this.openEntryInstance.field_70131_O * 1000.0f)) / 1000.0f);
            this.openEntryStatsLines.add("");
            this.openEntryStatsLines.add(TextFormatting.BOLD + StringUtil.getLocaleString("gui.aoamain.bestiary.health") + TextFormatting.RESET + " " + this.openEntryInstance.func_110138_aP());
            if (this.openEntryInstance.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111126_e() > 0.0) {
                this.openEntryStatsLines.add(TextFormatting.BOLD + StringUtil.getLocaleString("gui.aoamain.bestiary.armour") + TextFormatting.RESET + " " + this.openEntryInstance.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111126_e());
            }
            if (this.openEntryInstance.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111126_e() > 0.0) {
                this.openEntryStatsLines.add(TextFormatting.BOLD + StringUtil.getLocaleString("gui.aoamain.bestiary.knockback") + TextFormatting.RESET + " " + (int)(this.openEntryInstance.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111126_e() * 100.0) + "%");
            }
            if ((attackAttribute = this.openEntryInstance.func_110148_a(SharedMonsterAttributes.field_111264_e)) != null && attackAttribute.func_111126_e() > 0.0) {
                this.openEntryStatsLines.add(TextFormatting.BOLD + StringUtil.getLocaleString("gui.aoamain.bestiary.strength") + TextFormatting.RESET + " " + this.openEntryInstance.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e());
            }
            if (this.openEntryInstance instanceof AoARangedAttacker) {
                if (this.openEntryInstance instanceof AoARangedMob) {
                    this.openEntryStatsLines.add(TextFormatting.BOLD + StringUtil.getLocaleString("gui.aoamain.bestiary.projectileStrength") + TextFormatting.RESET + " " + ((AoARangedMob)this.openEntryInstance).getBaseProjectileDamage());
                } else if (this.openEntryInstance instanceof AoAFlyingRangedMob) {
                    this.openEntryStatsLines.add(TextFormatting.BOLD + StringUtil.getLocaleString("gui.aoamain.bestiary.projectileStrength") + TextFormatting.RESET + " " + ((AoAFlyingRangedMob)this.openEntryInstance).getBaseProjectileDamage());
                }
            }
            this.openEntryStatsLines.add(TextFormatting.BOLD + StringUtil.getLocaleString("gui.aoamain.bestiary.speed") + TextFormatting.RESET + " " + (float)((int)(this.openEntryInstance.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e() * 1000.0)) / 1000.0f);
            if (eggInfo.field_75613_a.func_110624_b().equals("aoa3") && (info = ModUtil.getTextFromResourceFile(new ResourceLocation("aoa3", "lang/other/" + currentLanguage + "/bestiary/" + eggInfo.field_75613_a.func_110623_a().toLowerCase()), "txt", new ResourceLocation("aoa3", "lang/other/en_us/bestiary/" + eggInfo.field_75613_a.func_110623_a().toLowerCase()))) != null) {
                this.openEntryInfoLines = this.field_146297_k.field_71466_p.func_78271_c(info, 489);
            }
        } else {
            this.openEntryIndex = -1;
            this.openEntryHeight = 0;
        }
    }

    private class BestiaryMenu
    extends ScrollablePane {
        public BestiaryMenu(Minecraft mc, int top, int left, int viewHeight, int viewWidth, float ... renderingScale) {
            super(mc, top, left, viewHeight, viewWidth, renderingScale);
        }

        @Override
        public int getFullPaneHeight() {
            return AdventGuiTabBestiary.this.receivedStats ? (AdventGuiTabBestiary.this.openEntryIndex < 0 ? (AdventGuiTabBestiary.this.mobList.size() + AdventGuiTabBestiary.this.mobList.size() % 2) * 100 + 20 : AdventGuiTabBestiary.this.openEntryHeight) : 0;
        }

        @Override
        public void drawPaneContents(int top, int left, int right, int bottom, float scrollDistance) {
            GlStateManager.func_179094_E();
            if (!AdventGuiTabBestiary.this.receivedStats) {
                RenderUtil.drawCenteredScaledString(AdventGuiTabBestiary.this.field_146297_k.field_71466_p, StringUtil.getLocaleString("gui.aoamain.bestiary.downloading"), left + (int)((float)this.viewWidth / 2.0f), top + (int)((float)this.viewHeight / 2.0f) - 20, 2.0f, 0xFFFFFF, RenderUtil.StringRenderType.OUTLINED);
                RenderUtil.drawCenteredScaledString(AdventGuiTabBestiary.this.field_146297_k.field_71466_p, IProgressMeter.field_146510_b_[(int)(Minecraft.func_71386_F() / 150L % (long)IProgressMeter.field_146510_b_.length)], left + (int)((float)this.viewWidth / 2.0f), top + (int)((float)this.viewHeight / 2.0f), 2.0f, 0xFFFFFF, RenderUtil.StringRenderType.OUTLINED);
            } else if (AdventGuiTabBestiary.this.mobList.isEmpty()) {
                RenderUtil.drawCenteredScaledString(AdventGuiTabBestiary.this.field_146297_k.field_71466_p, StringUtil.getLocaleString("gui.aoamain.bestiary.empty"), left + (int)((float)this.viewWidth / 2.0f), top + (int)((float)this.viewHeight / 2.0f) - 20, 2.0f, 0xFFFFFF, RenderUtil.StringRenderType.OUTLINED);
            } else if (AdventGuiTabBestiary.this.openEntryIndex < 0) {
                for (int i = Math.max(0, (int)(scrollDistance / 200.0f) * 2); i * 100 <= bottom - top && i < AdventGuiTabBestiary.this.mobList.size(); i += 2) {
                    EntityList.EntityEggInfo entityEggInfo = (EntityList.EntityEggInfo)AdventGuiTabBestiary.this.mobList.get(i);
                    int rowTop = top + 20 + i * 100;
                    int rowBottom = rowTop + 180;
                    EntityLivingBase entity = AdventGuiTabBestiary.this.getEntityFromEgg(entityEggInfo);
                    String entityName = entity != null ? entity.func_70005_c_() : StringUtil.getLocaleString("entity." + entityEggInfo.field_75613_a.func_110624_b() + "." + entityEggInfo.field_75613_a.func_110623_a() + ".name").replace(".minecraft", "");
                    Gui.func_73734_a((int)(left + 40), (int)(rowTop + 30), (int)(left + 360), (int)rowBottom, (int)-14671840);
                    if (entity != null) {
                        this.drawEntity(entity, left + 200, rowTop + 170, 50.0f);
                    }
                    Gui.func_73734_a((int)(left + 40), (int)rowTop, (int)(left + 360), (int)(rowTop + 30), (int)-16711423);
                    RenderUtil.drawCenteredScaledString(AdventGuiTabBestiary.this.field_146297_k.field_71466_p, entityName, left + 200, rowTop + 8, 2.0f, 0xFFFFFF, RenderUtil.StringRenderType.NORMAL);
                    AdventGuiTabBestiary.this.field_146297_k.func_110434_K().func_110577_a(iconsTextures);
                    RenderUtil.drawScaledCustomSizeModalRect(left + 300, rowTop + 160, 0.0f, 0.0f, 16.0f, 16.0f, 16.0, 16.0, 16.0f, 32.0f);
                    RenderUtil.drawScaledCustomSizeModalRect(left + 43, rowTop + 160, 0.0f, 16.0f, 16.0f, 16.0f, 16.0, 16.0, 16.0f, 32.0f);
                    RenderUtil.drawScaledString(AdventGuiTabBestiary.this.field_146297_k.field_71466_p, StringUtil.floorAndAppendSuffix(AdventGuiTabBestiary.this.stats.func_77444_a(entityEggInfo.field_151512_d), true), left + 60, rowTop + 163, 1.5f, 0xFFFFFF, RenderUtil.StringRenderType.NORMAL);
                    RenderUtil.drawScaledString(AdventGuiTabBestiary.this.field_146297_k.field_71466_p, StringUtil.floorAndAppendSuffix(AdventGuiTabBestiary.this.stats.func_77444_a(entityEggInfo.field_151513_e), true), left + 320, rowTop + 163, 1.5f, 0xFFFFFF, RenderUtil.StringRenderType.NORMAL);
                    if (i + 1 >= AdventGuiTabBestiary.this.mobList.size()) continue;
                    entityEggInfo = (EntityList.EntityEggInfo)AdventGuiTabBestiary.this.mobList.get(i + 1);
                    entity = AdventGuiTabBestiary.this.getEntityFromEgg(entityEggInfo);
                    entityName = entity != null ? entity.func_70005_c_() : StringUtil.getLocaleString("entity." + entityEggInfo.field_75613_a.func_110624_b() + "." + entityEggInfo.field_75613_a.func_110623_a() + ".name").replace(".minecraft", "");
                    Gui.func_73734_a((int)(right - 360), (int)(rowTop + 30), (int)(right - 40), (int)rowBottom, (int)-14671840);
                    if (entity != null) {
                        this.drawEntity(entity, right - 200, rowTop + 170, 50.0f);
                    }
                    Gui.func_73734_a((int)(right - 360), (int)rowTop, (int)(right - 40), (int)(rowTop + 30), (int)-16711423);
                    RenderUtil.drawCenteredScaledString(AdventGuiTabBestiary.this.field_146297_k.field_71466_p, entityName, right - 200, rowTop + 8, 2.0f, 0xFFFFFF, RenderUtil.StringRenderType.NORMAL);
                    AdventGuiTabBestiary.this.field_146297_k.func_110434_K().func_110577_a(iconsTextures);
                    RenderUtil.drawScaledCustomSizeModalRect(right - 100, rowTop + 160, 0.0f, 0.0f, 16.0f, 16.0f, 16.0, 16.0, 16.0f, 32.0f);
                    RenderUtil.drawScaledCustomSizeModalRect(right - 357, rowTop + 160, 0.0f, 16.0f, 16.0f, 16.0f, 16.0, 16.0, 16.0f, 32.0f);
                    RenderUtil.drawScaledString(AdventGuiTabBestiary.this.field_146297_k.field_71466_p, StringUtil.floorAndAppendSuffix(AdventGuiTabBestiary.this.stats.func_77444_a(entityEggInfo.field_151512_d), true), right - 340, rowTop + 163, 1.5f, 0xFFFFFF, RenderUtil.StringRenderType.NORMAL);
                    RenderUtil.drawScaledString(AdventGuiTabBestiary.this.field_146297_k.field_71466_p, StringUtil.floorAndAppendSuffix(AdventGuiTabBestiary.this.stats.func_77444_a(entityEggInfo.field_151513_e), true), right - 80, rowTop + 163, 1.5f, 0xFFFFFF, RenderUtil.StringRenderType.NORMAL);
                }
            } else {
                int i;
                EntityList.EntityEggInfo entityEggInfo = (EntityList.EntityEggInfo)AdventGuiTabBestiary.this.mobList.get(AdventGuiTabBestiary.this.openEntryIndex);
                AdventGuiTabBestiary.this.openEntryHeight = Math.max(this.viewHeight - 30, 320 + (int)((float)(AdventGuiTabBestiary.this.openEntryInfoLines.size() * AdventGuiTabBestiary.this.field_146297_k.field_71466_p.field_78288_b) * 1.5f));
                Gui.func_73734_a((int)left, (int)(top + 30), (int)right, (int)bottom, (int)-14671840);
                Gui.func_73734_a((int)left, (int)top, (int)right, (int)(top + 30), (int)-16711423);
                String entityName = AdventGuiTabBestiary.this.openEntryInstance != null ? AdventGuiTabBestiary.this.openEntryInstance.func_70005_c_() : StringUtil.getLocaleString("entity." + entityEggInfo.field_75613_a.func_110624_b() + "." + entityEggInfo.field_75613_a.func_110623_a() + ".name").replace(".minecraft", "");
                RenderUtil.drawCenteredScaledString(AdventGuiTabBestiary.this.field_146297_k.field_71466_p, entityName, left + (int)((float)this.viewWidth / 2.0f), top + 8, 2.0f, 0xFFFFFF, RenderUtil.StringRenderType.NORMAL);
                if (AdventGuiTabBestiary.this.openEntryInstance != null) {
                    this.drawEntity(AdventGuiTabBestiary.this.openEntryInstance, left + 200, top + 240, 75.0f);
                }
                AdventGuiTabBestiary.this.field_146297_k.func_110434_K().func_110577_a(iconsTextures);
                RenderUtil.drawScaledCustomSizeModalRect(left + 425, top + 45, 0.0f, 16.0f, 16.0f, 16.0f, 16.0, 16.0, 16.0f, 32.0f);
                RenderUtil.drawScaledCustomSizeModalRect(left + 425, top + 65, 0.0f, 0.0f, 16.0f, 16.0f, 16.0, 16.0, 16.0f, 32.0f);
                RenderUtil.drawScaledString(AdventGuiTabBestiary.this.field_146297_k.field_71466_p, "X", right - 20, top + 5, 1.5f, 0xFFFFFF, RenderUtil.StringRenderType.NORMAL);
                RenderUtil.drawScaledString(AdventGuiTabBestiary.this.field_146297_k.field_71466_p, StringUtil.floorAndAppendSuffix(AdventGuiTabBestiary.this.stats.func_77444_a(entityEggInfo.field_151512_d), true), left + 445, top + 48, 1.5f, 0xFFFFFF, RenderUtil.StringRenderType.NORMAL);
                RenderUtil.drawScaledString(AdventGuiTabBestiary.this.field_146297_k.field_71466_p, StringUtil.floorAndAppendSuffix(AdventGuiTabBestiary.this.stats.func_77444_a(entityEggInfo.field_151513_e), true), left + 445, top + 68, 1.5f, 0xFFFFFF, RenderUtil.StringRenderType.NORMAL);
                GlStateManager.func_179152_a((float)1.5f, (float)1.5f, (float)1.5f);
                for (i = 0; i < AdventGuiTabBestiary.this.openEntryStatsLines.size(); ++i) {
                    AdventGuiTabBestiary.this.field_146297_k.field_71466_p.func_175065_a((String)AdventGuiTabBestiary.this.openEntryStatsLines.get(i), (float)((int)((float)(left + 425) / 1.5f)), (float)((int)((float)(top + 100 + 14 * i) / 1.5f)), 0xFFFFFF, true);
                }
                for (i = 0; i < AdventGuiTabBestiary.this.openEntryInfoLines.size(); ++i) {
                    AdventGuiTabBestiary.this.field_146297_k.field_71466_p.func_78276_b((String)AdventGuiTabBestiary.this.openEntryInfoLines.get(i), (int)((float)(left + 20) / 1.5f), (int)((float)(top + 300 + i * 14) / 1.5f), 0xFFFFFF);
                }
            }
            GlStateManager.func_179121_F();
        }

        @Override
        public void drawBackground() {
        }

        private void drawEntity(EntityLivingBase entity, int posX, int posY, float scale) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179126_j();
            GlStateManager.func_179098_w();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179142_g();
            GlStateManager.func_179109_b((float)posX, (float)posY, (float)200.0f);
            if ((double)entity.field_70131_O > 2.5) {
                scale = (float)((double)scale * (2.3 / (double)entity.field_70131_O));
            }
            if (entity.field_70130_N > 3.0f) {
                scale *= 3.0f / entity.field_70130_N;
            }
            GlStateManager.func_179152_a((float)(-scale), (float)scale, (float)scale);
            GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179114_b((float)135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            RenderHelper.func_74519_b();
            GlStateManager.func_179114_b((float)-125.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            RenderManager rendermanager = AdventGuiTabBestiary.this.field_146297_k.func_175598_ae();
            entity.field_70173_aa = AdventGuiTabBestiary.this.field_146297_k.field_71439_g.field_70173_aa;
            entity.field_70177_z = 0.0f;
            entity.field_70125_A = 0.0f;
            entity.field_70759_as = 0.0f;
            rendermanager.func_178631_a(180.0f);
            rendermanager.func_178633_a(false);
            rendermanager.func_188391_a((Entity)entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, false);
            rendermanager.func_178633_a(true);
            RenderHelper.func_74518_a();
            GlStateManager.func_179101_C();
            GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
            GlStateManager.func_179090_x();
            GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179121_F();
        }

        @Override
        public void handleMouseInput(int mouseX, int mouseY) {
            super.handleMouseInput(mouseX, mouseY);
            if (mouseX != -1) {
                int relativeMouseX = mouseX - this.left + 2;
                if (AdventGuiTabBestiary.this.openEntryIndex < 0 && (relativeMouseX < 40 || relativeMouseX > this.right - this.left - 40)) {
                    return;
                }
                int newTop = this.top - Math.max(0, (int)this.distanceScrolled);
                int relativeMouseY = mouseY - newTop + 2;
                if (mouseY - this.top < 0 || mouseY > this.top + this.viewHeight) {
                    return;
                }
                if (AdventGuiTabBestiary.this.openEntryIndex < 0) {
                    float preIndexY;
                    int selectedIndex = -1;
                    if (relativeMouseX < 360) {
                        float preIndexY2 = (float)relativeMouseY / 200.0f;
                        if ((double)(preIndexY2 - (float)((int)preIndexY2)) > 0.11) {
                            selectedIndex = 2 * (int)preIndexY2;
                        }
                    } else if (relativeMouseX > this.right - this.left - 360 && (double)((preIndexY = (float)relativeMouseY / 200.0f) - (float)((int)preIndexY)) > 0.11) {
                        selectedIndex = 1 + (int)preIndexY * 2;
                    }
                    if (selectedIndex >= 0 && AdventGuiTabBestiary.this.mobList.size() > selectedIndex) {
                        AdventGuiTabBestiary.this.openEntryIndex = selectedIndex;
                        AdventGuiTabBestiary.this.lastSelectionTime = System.currentTimeMillis();
                        AdventGuiTabBestiary.this.openEntryHeight = 600;
                        AdventGuiTabBestiary.this.lastDistanceScrolled = this.distanceScrolled;
                        this.distanceScrolled = 0.0f;
                        if (AdventGuiTabBestiary.this.lastOpenIndex != selectedIndex) {
                            if (AdventGuiTabBestiary.this.openEntryInstance != null) {
                                AdventGuiTabBestiary.this.openEntryInstance.func_70106_y();
                            }
                            AdventGuiTabBestiary.this.gatherEntityStats((EntityList.EntityEggInfo)AdventGuiTabBestiary.this.mobList.get(selectedIndex));
                        }
                        AdventGuiTabBestiary.this.lastOpenIndex = selectedIndex;
                    }
                } else if (relativeMouseY <= 30) {
                    AdventGuiTabBestiary.this.lastOpenIndex = AdventGuiTabBestiary.this.openEntryIndex;
                    AdventGuiTabBestiary.this.openEntryIndex = -1;
                    AdventGuiTabBestiary.this.openEntryHeight = 0;
                    this.distanceScrolled = AdventGuiTabBestiary.this.lastDistanceScrolled;
                }
            }
        }
    }
}

