/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.gui.mainwindow;

import java.net.URI;
import java.net.URISyntaxException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.client.gui.mainwindow.AdventMainGui;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.ConfigurationUtil;
import net.tslat.aoa3.utils.RenderUtil;
import net.tslat.aoa3.utils.StringUtil;
import org.apache.logging.log4j.Level;

@SideOnly(value=Side.CLIENT)
public class AdventGuiTabHelp
extends GuiScreen {
    private int adjustedMouseX;
    private int adjustedMouseY;
    private int tipNumber = AdventOfAscension.rand.nextInt(16);

    AdventGuiTabHelp() {
    }

    public void func_73866_w_() {
        String wikiDownloadLink;
        String wikiLink;
        super.func_73866_w_();
        String language = FMLCommonHandler.instance().getCurrentLanguage();
        if (language.equals("zh_cn") || language.equals("zh_tw")) {
            wikiLink = "https://adventofascension-zh.gamepedia.com/Advent_of_Ascension_Wiki";
            wikiDownloadLink = "https://adventofascension-zh.gamepedia.com/%E4%B8%8B%E8%BD%BD";
        } else {
            wikiLink = "https://adventofascension.gamepedia.com/Advent_of_Ascension_Wiki";
            wikiDownloadLink = "https://adventofascension.gamepedia.com/Download";
        }
        this.field_146292_n.add(new ThemeButton(0, 640, 35, 30, 40));
        this.field_146292_n.add(new WebLinkButton(this.field_146297_k, 1, 640, 130, 76, 18, StringUtil.getLocaleString("gui.aoamain.link.discord"), this.stringtoURI("https://discord.gg/DNYqNNq")));
        this.field_146292_n.add(new WebLinkButton(this.field_146297_k, 2, 640, 170, 108, 18, StringUtil.getLocaleString("gui.aoamain.link.wiki"), this.stringtoURI(wikiLink)));
        this.field_146292_n.add(new WebLinkButton(this.field_146297_k, 3, 640, 210, 60, 18, StringUtil.getLocaleString("gui.aoamain.link.github"), this.stringtoURI("https://github.com/Tslat/Advent-Of-Ascension")));
        this.field_146292_n.add(new WebLinkButton(this.field_146297_k, 4, 640, 250, 80, 18, StringUtil.getLocaleString("gui.aoamain.link.patreon"), this.stringtoURI("https://www.patreon.com/Tslat")));
        this.field_146292_n.add(new WebLinkButton(this.field_146297_k, 5, 640, 290, 68, 18, StringUtil.getLocaleString("gui.aoamain.link.update"), this.stringtoURI(wikiDownloadLink)));
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.adjustedMouseX = (int)((float)mouseX * 2.2222223f);
        this.adjustedMouseY = (int)((float)mouseY * 2.2222223f);
        this.func_73733_a(AdventMainGui.scaledTabRootX + 35, AdventMainGui.scaledTabRootY + 55, AdventMainGui.scaledTabRootX + 590, AdventMainGui.scaledTabRootY + 280, -1072689136, -804253680);
        RenderUtil.drawCenteredScaledString(this.field_146297_k.field_71466_p, StringUtil.getLocaleString("gui.aoamain.theme"), AdventMainGui.scaledTabRootX + 672, AdventMainGui.scaledTabRootY + 10, 2.0f, 0xFFFFFF, RenderUtil.StringRenderType.OUTLINED);
        RenderUtil.drawCenteredScaledString(this.field_146297_k.field_71466_p, StringUtil.getLocaleString("gui.aoamain.links"), AdventMainGui.scaledTabRootX + 672, AdventMainGui.scaledTabRootY + 100, 2.0f, 0xFFFFFF, RenderUtil.StringRenderType.OUTLINED);
        RenderUtil.drawScaledString(this.field_146297_k.field_71466_p, StringUtil.getLocaleString("gui.aoamain.help.1"), AdventMainGui.scaledTabRootX + 80, AdventMainGui.scaledTabRootY + 25, 2.5f, 15698295, RenderUtil.StringRenderType.OUTLINED);
        GlStateManager.func_179152_a((float)1.5625f, (float)1.5625f, (float)1.5625f);
        this.field_146297_k.field_71466_p.func_78279_b(StringUtil.getLocaleString("gui.aoamain.help.2").replace("<br>", "\n"), (int)((float)(AdventMainGui.scaledTabRootX + 40) / 1.5625f), (int)((float)(AdventMainGui.scaledTabRootY + 60) / 1.5625f), 360, 0xFFFFFF);
        GlStateManager.func_179152_a((float)0.64f, (float)0.64f, (float)0.64f);
        RenderUtil.drawScaledString(this.field_146297_k.field_71466_p, StringUtil.getLocaleStringWithArguments("gui.aoamain.help.tip", StringUtil.getLocaleString("gui.aoamain.tip." + this.tipNumber)), AdventMainGui.scaledTabRootX + 30, AdventMainGui.scaledTabRootY + 310, 1.8f, 0xFFFFFF, RenderUtil.StringRenderType.DROP_SHADOW);
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    protected void func_146284_a(GuiButton button) {
        if (button instanceof ThemeButton) {
            int newOrdinal = AdventMainGui.currentTheme.ordinal() + 1;
            if (newOrdinal >= Enums.MainWindowThemes.values().length) {
                newOrdinal = 0;
            }
            Enums.MainWindowThemes theme = Enums.MainWindowThemes.values()[newOrdinal];
            AdventMainGui.changeTheme(theme);
        } else if (button instanceof WebLinkButton) {
            this.openURL(((WebLinkButton)button).url);
        }
    }

    private void openURL(URI url) {
        try {
            Class<?> oclass = Class.forName("java.awt.Desktop");
            Object object = oclass.getMethod("getDesktop", new Class[0]).invoke(null, new Object[0]);
            oclass.getMethod("browse", URI.class).invoke(object, url);
        }
        catch (Throwable throwable1) {
            Throwable throwable = throwable1.getCause();
            AdventOfAscension.logMessage(Level.ERROR, "Couldn't open link: " + (throwable == null ? "<UNKNOWN>" : throwable.getMessage()));
        }
    }

    private URI stringtoURI(String url) {
        try {
            return new URI(url);
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    private static class ThemeButton
    extends GuiButton {
        public ThemeButton(int buttonId, int x, int y, int width, int height) {
            super(buttonId, x, y, width, height, ConfigurationUtil.MainConfig.mainWindowTheme.toString().replace("_", " "));
        }

        public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
            if (this.field_146125_m) {
                mc.func_110434_K().func_110577_a(AdventMainGui.menuButtonTexture);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.field_146123_n = this.isMouseInRegion(mouseX, mouseY, this.field_146128_h, this.field_146129_i);
                this.field_146126_j = ConfigurationUtil.MainConfig.mainWindowTheme.toString().replace("_", " ");
                this.field_146120_f = (int)Math.max((float)(this.field_146120_f - 10), 10.0f + (float)mc.field_71466_p.func_78256_a(this.field_146126_j) * 1.5f);
                ThemeButton.func_152125_a((int)(AdventMainGui.scaledTabRootX + this.field_146128_h), (int)(AdventMainGui.scaledTabRootY + this.field_146129_i), (float)0.0f, (float)(this.func_146114_a(this.field_146123_n) == 2 ? 60 : 120), (int)180, (int)60, (int)this.field_146120_f, (int)this.field_146121_g, (float)180.0f, (float)180.0f);
                int stringColour = 0xE0E0E0;
                if (this.packedFGColour != 0) {
                    stringColour = this.packedFGColour;
                } else if (!this.field_146124_l) {
                    stringColour = 0xA0A0A0;
                } else if (this.field_146123_n) {
                    stringColour = 0xFFFFA0;
                }
                RenderUtil.drawCenteredScaledString(mc.field_71466_p, this.field_146126_j, (int)((float)(AdventMainGui.scaledTabRootX + this.field_146128_h) + (float)this.field_146120_f / 2.0f), (int)((double)(AdventMainGui.scaledTabRootY + this.field_146129_i) + (double)this.field_146121_g / 2.5), 1.5f, stringColour, RenderUtil.StringRenderType.DROP_SHADOW);
            }
        }

        public boolean func_146116_c(Minecraft mc, int mouseX, int mouseY) {
            return this.field_146124_l && this.field_146123_n;
        }

        private boolean isMouseInRegion(int mouseX, int mouseY, int buttonX, int buttonY) {
            return mouseX >= (int)((float)(AdventMainGui.scaledTabRootX + buttonX) * 0.45f) && mouseX <= (int)((float)(AdventMainGui.scaledTabRootX + buttonX + this.field_146120_f) * 0.45f) && mouseY >= (int)((float)(AdventMainGui.scaledTabRootY + buttonY) * 0.45f) && mouseY <= (int)((float)(AdventMainGui.scaledTabRootY + buttonY + this.field_146121_g) * 0.45f);
        }
    }

    private static class WebLinkButton
    extends GuiButton {
        private final URI url;

        public WebLinkButton(Minecraft mc, int buttonId, int x, int y, int width, int height, String name, URI link) {
            super(buttonId, x, y, width, height, name);
            this.url = link;
            if (this.url == null) {
                this.field_146124_l = false;
                this.field_146125_m = false;
            } else {
                this.field_146120_f = (int)((float)mc.field_71466_p.func_78256_a(this.field_146126_j) * 2.0f);
            }
        }

        public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
            if (this.field_146125_m) {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.field_146123_n = this.isMouseInRegion(mouseX, mouseY, this.field_146128_h, this.field_146129_i);
                int stringColour = 15698295;
                if (this.field_146123_n) {
                    stringColour = 16248576;
                }
                RenderUtil.drawCenteredScaledString(mc.field_71466_p, this.field_146126_j, (int)((float)(AdventMainGui.scaledTabRootX + this.field_146128_h) + (float)this.field_146120_f / 2.0f), AdventMainGui.scaledTabRootY + this.field_146129_i, 2.0f, stringColour, RenderUtil.StringRenderType.OUTLINED);
            }
        }

        public boolean func_146116_c(Minecraft mc, int mouseX, int mouseY) {
            return this.field_146124_l && this.field_146123_n;
        }

        private boolean isMouseInRegion(int mouseX, int mouseY, int buttonX, int buttonY) {
            return mouseX >= (int)((float)(AdventMainGui.scaledTabRootX + buttonX) * 0.45f) && mouseX <= (int)((float)(AdventMainGui.scaledTabRootX + buttonX + this.field_146120_f) * 0.45f) && mouseY >= (int)((float)(AdventMainGui.scaledTabRootY + buttonY) * 0.45f) && mouseY <= (int)((float)(AdventMainGui.scaledTabRootY + buttonY + this.field_146121_g) * 0.45f);
        }
    }
}

