/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.gui.mainwindow;

import java.io.IOException;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.IProgressMeter;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.client.event.KeyBinder;
import net.tslat.aoa3.client.gui.mainwindow.AdventGuiTabBestiary;
import net.tslat.aoa3.client.gui.mainwindow.AdventGuiTabGuides;
import net.tslat.aoa3.client.gui.mainwindow.AdventGuiTabHelp;
import net.tslat.aoa3.client.gui.mainwindow.AdventGuiTabPlayer;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.ConfigurationUtil;
import net.tslat.aoa3.utils.RenderUtil;
import net.tslat.aoa3.utils.StringUtil;
import net.tslat.aoa3.utils.WebUtil;
import org.lwjgl.input.Keyboard;

@SideOnly(value=Side.CLIENT)
public class AdventMainGui
extends GuiScreen
implements IProgressMeter {
    @Nullable
    protected static ResourceLocation overlayTexture = null;
    protected static ResourceLocation backgroundTexture;
    protected static ResourceLocation menuButtonTexture;
    private static ADVENT_WINDOW_TAB selectedTab;
    protected static Enums.MainWindowThemes currentTheme;
    @Nullable
    private static GuiScreen tabScreen;
    protected EntityPlayer player;
    protected static final int guiWidth = 976;
    protected static final int guiHeight = 480;
    protected static final float scale = 0.45f;
    protected static final float scaleInverse = 2.2222223f;
    protected static int scaledRootX;
    protected static int scaledRootY;
    protected static int scaledTabRootX;
    protected static int scaledTabRootY;
    private static int updateMessageTicker;

    public AdventMainGui(EntityPlayer player) {
        this.player = player;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.add(new AdventMainGuiTabButton(0, 11, 129, StringUtil.getLocaleString("gui.aoamain.tab.player"), ADVENT_WINDOW_TAB.PLAYER));
        this.field_146292_n.add(new AdventMainGuiTabButton(1, 11, 199, StringUtil.getLocaleString("gui.aoamain.tab.bestiary"), ADVENT_WINDOW_TAB.BESTIARY));
        this.field_146292_n.add(new AdventMainGuiTabButton(2, 11, 269, "", ADVENT_WINDOW_TAB.LEADERBOARDS));
        this.field_146292_n.add(new AdventMainGuiTabButton(3, 11, 339, StringUtil.getLocaleString("gui.aoamain.tab.guides"), ADVENT_WINDOW_TAB.GUIDES));
        this.field_146292_n.add(new AdventMainGuiTabButton(4, 11, 409, StringUtil.getLocaleString("gui.aoamain.tab.help"), ADVENT_WINDOW_TAB.HELP));
        ((GuiButton)this.field_146292_n.get((int)2)).field_146124_l = false;
        this.correctGuiPositions();
        if (tabScreen == null) {
            this.initTabScreen();
        } else {
            tabScreen.func_73866_w_();
        }
        AdventMainGui.setThemeTextures();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        this.field_146297_k.func_110434_K().func_110577_a(backgroundTexture);
        GlStateManager.func_179094_E();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179152_a((float)0.45f, (float)0.45f, (float)0.45f);
        AdventMainGui.func_146110_a((int)scaledRootX, (int)scaledRootY, (float)24.0f, (float)16.0f, (int)976, (int)480, (float)1024.0f, (float)512.0f);
        GlStateManager.func_179152_a((float)2.2222223f, (float)2.2222223f, (float)2.2222223f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        super.func_73863_a(mouseX, mouseY, partialTicks);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179152_a((float)0.45f, (float)0.45f, (float)0.45f);
        if (overlayTexture != null) {
            this.field_146297_k.func_110434_K().func_110577_a(overlayTexture);
            AdventMainGui.func_146110_a((int)(scaledRootX - 24), (int)(scaledRootY - 16), (float)0.0f, (float)0.0f, (int)1024, (int)512, (float)1024.0f, (float)512.0f);
        }
        GlStateManager.func_179139_a((double)1.25, (double)1.25, (double)1.25);
        this.field_146297_k.field_71466_p.func_175065_a("v3.2.7", (float)(scaledRootX + 175) / 1.25f, (float)(scaledRootY + 85) / 1.25f, 0xFFDF00, true);
        if (WebUtil.isUpdateAvailable()) {
            if (--updateMessageTicker <= -30) {
                updateMessageTicker = 90;
            }
            if (updateMessageTicker > 0) {
                String msg = StringUtil.getLocaleStringWithArguments("gui.aoamain.update", WebUtil.getLatestVersion());
                this.field_146297_k.field_71466_p.func_175065_a(msg, (float)((int)((float)(scaledRootX + 925 - this.field_146297_k.field_71466_p.func_78256_a(msg)) / 1.25f)), (float)((int)((float)(scaledRootY + 105) / 1.25f)), 0xE50000, true);
            }
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179139_a((double)0.8, (double)0.8, (double)0.8);
        if (tabScreen != null) {
            tabScreen.func_73863_a(mouseX, mouseY, partialTicks);
        }
        GlStateManager.func_179152_a((float)2.2222223f, (float)2.2222223f, (float)2.2222223f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
    }

    public void func_193026_g() {
        if (tabScreen instanceof IProgressMeter) {
            ((IProgressMeter)tabScreen).func_193026_g();
        }
    }

    private static void setThemeTextures() {
        currentTheme = ConfigurationUtil.MainConfig.mainWindowTheme;
        switch (currentTheme) {
            case Jungle: {
                backgroundTexture = new ResourceLocation("aoa3", "textures/gui/maingui/themes/jungle/background.png");
                menuButtonTexture = new ResourceLocation("aoa3", "textures/gui/maingui/themes/jungle/tab_buttons.png");
                overlayTexture = new ResourceLocation("aoa3", "textures/gui/maingui/themes/jungle/overlay.png");
                break;
            }
            case Ancient_Ruins: {
                backgroundTexture = new ResourceLocation("aoa3", "textures/gui/maingui/themes/default/background.png");
                menuButtonTexture = new ResourceLocation("aoa3", "textures/gui/maingui/themes/default/tab_buttons.png");
                overlayTexture = new ResourceLocation("aoa3", "textures/gui/maingui/themes/ancientruins/overlay.png");
                break;
            }
            case Hell: {
                backgroundTexture = new ResourceLocation("aoa3", "textures/gui/maingui/themes/hell/background.png");
                menuButtonTexture = new ResourceLocation("aoa3", "textures/gui/maingui/themes/hell/tab_buttons.png");
                overlayTexture = new ResourceLocation("aoa3", "textures/gui/maingui/themes/hell/overlay.png");
                break;
            }
            case Crystals: {
                backgroundTexture = new ResourceLocation("aoa3", "textures/gui/maingui/themes/crystals/background.png");
                menuButtonTexture = new ResourceLocation("aoa3", "textures/gui/maingui/themes/crystals/tab_buttons.png");
                overlayTexture = new ResourceLocation("aoa3", "textures/gui/maingui/themes/crystals/overlay.png");
                break;
            }
            default: {
                ConfigurationUtil.MainConfig.mainWindowTheme = Enums.MainWindowThemes.Default;
                currentTheme = Enums.MainWindowThemes.Default;
            }
            case Default: {
                backgroundTexture = new ResourceLocation("aoa3", "textures/gui/maingui/themes/default/background.png");
                menuButtonTexture = new ResourceLocation("aoa3", "textures/gui/maingui/themes/default/tab_buttons.png");
                overlayTexture = null;
            }
        }
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        if (tabScreen != null) {
            tabScreen.func_146274_d();
        }
    }

    public void func_146282_l() throws IOException {
        if (Keyboard.getEventKey() == KeyBinder.keyAdventGui.func_151463_i() && Keyboard.getEventKeyState()) {
            Minecraft.func_71410_x().func_147108_a(null);
        }
        super.func_146282_l();
    }

    private void initTabScreen() {
        switch (selectedTab) {
            case PLAYER: {
                tabScreen = new AdventGuiTabPlayer();
                tabScreen.func_146280_a(this.field_146297_k, (int)((float)(this.field_146294_l + 182) * 0.45f), (int)((float)(this.field_146295_m + 118) * 0.45f));
                break;
            }
            case HELP: {
                tabScreen = new AdventGuiTabHelp();
                tabScreen.func_146280_a(this.field_146297_k, (int)((float)(this.field_146294_l + 182) * 0.45f), (int)((float)(this.field_146295_m + 118) * 0.45f));
                break;
            }
            case BESTIARY: {
                tabScreen = new AdventGuiTabBestiary();
                tabScreen.func_146280_a(this.field_146297_k, (int)((float)(this.field_146294_l + 182) * 0.45f), (int)((float)(this.field_146295_m + 118) * 0.45f));
                break;
            }
            case GUIDES: {
                tabScreen = new AdventGuiTabGuides();
                tabScreen.func_146280_a(this.field_146297_k, (int)((float)(this.field_146294_l + 182) * 0.45f), (int)((float)(this.field_146295_m + 118) * 0.45f));
                break;
            }
            default: {
                tabScreen = null;
            }
        }
    }

    public boolean func_73868_f() {
        return ConfigurationUtil.MainConfig.mainWindowPausesGame;
    }

    private void correctGuiPositions() {
        ScaledResolution res = new ScaledResolution(this.field_146297_k);
        scaledRootX = (int)(Math.round((double)res.func_78326_a() / 2.0 / (double)0.45f) - Math.round(488.0));
        scaledRootY = (int)(Math.round((double)res.func_78328_b() / 2.0 / (double)0.45f) - Math.round(240.0));
        scaledTabRootX = scaledRootX + 201;
        scaledTabRootY = scaledRootY + 129;
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button instanceof AdventMainGuiTabButton) {
            selectedTab = ((AdventMainGuiTabButton)button).tabID;
            this.initTabScreen();
        }
    }

    public void func_175273_b(Minecraft mcIn, int width, int height) {
        super.func_175273_b(mcIn, width, height);
        this.correctGuiPositions();
        if (tabScreen != null) {
            tabScreen.func_175273_b(this.field_146297_k, (int)((float)(width + 182) * 0.45f), (int)((float)(height + 118) * 0.45f));
        }
    }

    public void func_146281_b() {
        super.func_146281_b();
        if (tabScreen != null) {
            tabScreen.func_146281_b();
        }
    }

    protected static void changeTheme(Enums.MainWindowThemes theme) {
        ConfigurationUtil.changeMainWindowTheme(theme);
        AdventMainGui.setThemeTextures();
    }

    static {
        selectedTab = ADVENT_WINDOW_TAB.PLAYER;
        updateMessageTicker = 0;
    }

    private static class AdventMainGuiTabButton
    extends GuiButton {
        private static final int buttonWidth = 180;
        private static final int buttonHeight = 60;
        private final ADVENT_WINDOW_TAB tabID;

        private AdventMainGuiTabButton(int buttonId, int x, int y, String buttonText, ADVENT_WINDOW_TAB tab) {
            super(buttonId, x, y, 180, 60, buttonText);
            this.tabID = tab;
        }

        public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
            if (this.field_146125_m) {
                mc.func_110434_K().func_110577_a(menuButtonTexture);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179152_a((float)0.45f, (float)0.45f, (float)0.45f);
                this.field_146123_n = this.isMouseInRegion(mouseX, mouseY, this.field_146128_h, this.field_146129_i);
                boolean textureX = false;
                int textureY = 60 * (this.tabID == selectedTab ? 0 : (this.func_146114_a(this.field_146123_n) == 2 ? 1 : 2));
                AdventMainGuiTabButton.func_152125_a((int)(scaledRootX + this.field_146128_h), (int)(scaledRootY + this.field_146129_i), (float)((float)textureX), (float)textureY, (int)180, (int)60, (int)180, (int)60, (float)180.0f, (float)180.0f);
                int stringColour = 15698295;
                if (this.packedFGColour != 0) {
                    stringColour = this.packedFGColour;
                } else if (!this.field_146124_l) {
                    stringColour = 0xA0A0A0;
                } else if (this.field_146123_n || this.tabID == selectedTab) {
                    stringColour = 16248576;
                }
                RenderUtil.drawCenteredScaledString(mc.field_71466_p, this.field_146126_j, scaledRootX + this.field_146128_h + 90, scaledRootY + this.field_146129_i + 25, 2.0f, stringColour, RenderUtil.StringRenderType.OUTLINED);
                GlStateManager.func_179152_a((float)2.2222223f, (float)2.2222223f, (float)2.2222223f);
            }
        }

        public boolean func_146116_c(Minecraft mc, int mouseX, int mouseY) {
            return this.field_146124_l && this.field_146123_n && selectedTab != this.tabID;
        }

        private boolean isMouseInRegion(int mouseX, int mouseY, int buttonX, int buttonY) {
            return mouseX >= (int)((float)(scaledRootX + buttonX) * 0.45f) && mouseX <= (int)((float)(scaledRootX + buttonX + 180) * 0.45f) && mouseY >= (int)((float)(scaledRootY + buttonY) * 0.45f) && mouseY <= (int)((float)(scaledRootY + buttonY + 60) * 0.45f);
        }
    }

    protected static enum ADVENT_WINDOW_TAB {
        PLAYER,
        BESTIARY,
        GUIDES,
        LEADERBOARDS,
        HELP;

    }
}

