/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.gui.toasts;

import net.minecraft.client.gui.toasts.GuiToast;
import net.minecraft.client.gui.toasts.IToast;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.RenderUtil;
import net.tslat.aoa3.utils.StringUtil;

@SideOnly(value=Side.CLIENT)
public class LevelRequirementToast
implements IToast {
    private static final ResourceLocation skillsTextures = new ResourceLocation("aoa3", "textures/gui/maingui/skills.png");
    private final Enums.Skills skill;
    private int iconUvX = 0;
    private int iconUvY = 0;
    private final int levelRequired;
    private final String title;
    private final String subtitle;

    public LevelRequirementToast(Enums.Skills relevantSkill, int levelRequirement) {
        this.skill = relevantSkill;
        this.levelRequired = levelRequirement;
        this.title = StringUtil.getColourLocaleString("gui.aoatoast.levelReq.title", TextFormatting.DARK_RED);
        this.subtitle = StringUtil.getLocaleStringWithArguments("gui.aoatoast.levelReq.subtitle", StringUtil.capitaliseFirstLetter(relevantSkill.toString()), String.valueOf(levelRequirement));
        this.applyIconUvs(relevantSkill);
    }

    public Enums.Skills getSkill() {
        return this.skill;
    }

    public int getLevelReq() {
        return this.levelRequired;
    }

    public IToast.Visibility func_193653_a(GuiToast toastGui, long delta) {
        toastGui.func_192989_b().func_110434_K().func_110577_a(field_193654_a);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        toastGui.func_73729_b(0, 0, 0, 0, 160, 32);
        toastGui.func_192989_b().func_110434_K().func_110577_a(skillsTextures);
        RenderUtil.drawScaledCustomSizeModalRect(6.0, 6.0, this.iconUvX, this.iconUvY, 50.0f, 50.0f, 20.0, 20.0, 450.0f, 240.0f);
        toastGui.func_192989_b().field_71466_p.func_78276_b(this.title, 30, 7, -11534256);
        toastGui.func_192989_b().field_71466_p.func_78276_b(this.subtitle, 30, 18, 0xFFFFFF);
        return delta >= 3000L ? IToast.Visibility.HIDE : IToast.Visibility.SHOW;
    }

    private void applyIconUvs(Enums.Skills skill) {
        switch (skill) {
            case ALCHEMY: {
                this.iconUvX = 0;
                this.iconUvY = 0;
                break;
            }
            case ANIMA: {
                this.iconUvX = 50;
                this.iconUvY = 0;
                break;
            }
            case AUGURY: {
                this.iconUvX = 100;
                this.iconUvY = 0;
                break;
            }
            case BUTCHERY: {
                this.iconUvX = 150;
                this.iconUvY = 0;
                break;
            }
            case CREATION: {
                this.iconUvX = 200;
                this.iconUvY = 0;
                break;
            }
            case ENGINEERING: {
                this.iconUvX = 250;
                this.iconUvY = 0;
                break;
            }
            case EXPEDITION: {
                this.iconUvX = 300;
                this.iconUvY = 0;
                break;
            }
            case EXTRACTION: {
                this.iconUvX = 350;
                this.iconUvY = 0;
                break;
            }
            case FORAGING: {
                this.iconUvX = 400;
                this.iconUvY = 0;
                break;
            }
            case HAULING: {
                this.iconUvX = 0;
                this.iconUvY = 100;
                break;
            }
            case HUNTER: {
                this.iconUvX = 50;
                this.iconUvY = 100;
                break;
            }
            case INFUSION: {
                this.iconUvX = 100;
                this.iconUvY = 100;
                break;
            }
            case INNERVATION: {
                this.iconUvX = 150;
                this.iconUvY = 100;
                break;
            }
            case LOGGING: {
                this.iconUvX = 200;
                this.iconUvY = 100;
                break;
            }
            case RUNATION: {
                this.iconUvX = 250;
                this.iconUvY = 100;
            }
        }
    }
}

