/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.render;

import java.util.HashMap;
import javax.annotation.Nullable;
import net.minecraft.client.particle.Particle;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.client.fx.FXFlickeringFluffyTrail;
import net.tslat.aoa3.client.fx.FXFluffyRainbowParticle;
import net.tslat.aoa3.client.fx.FXFluffyTrail;
import net.tslat.aoa3.client.fx.FXLastingFluffyTrail;
import net.tslat.aoa3.client.fx.FXPortalFloater;
import net.tslat.aoa3.client.fx.FXSwirlyTrail;

@SideOnly(value=Side.CLIENT)
public class FXRenders {
    private static HashMap<Integer, FXFactory> particleFactoryMap = new HashMap();

    public static void spawnParticle(int id, double posX, double posY, double posZ, double speedX, double speedY, double speedZ, int textureOffsetIndex, float scale, int ... args) {
        FXFactory factory = particleFactoryMap.get(id);
        if (factory != null) {
            factory.createParticle(posX, posY, posZ, speedX, speedY, speedZ, textureOffsetIndex, scale, args);
        }
    }

    @SubscribeEvent
    public void stitchEvent(TextureStitchEvent.Pre ev) {
        ev.getMap().func_174942_a(FXFluffyTrail.texture);
        ev.getMap().func_174942_a(FXSwirlyTrail.texture);
        ev.getMap().func_174942_a(FXPortalFloater.texture);
    }

    static {
        particleFactoryMap.put(0, new FXFluffyTrail.Factory());
        particleFactoryMap.put(1, new FXFlickeringFluffyTrail.Factory());
        particleFactoryMap.put(2, new FXSwirlyTrail.Factory());
        particleFactoryMap.put(3, new FXLastingFluffyTrail.Factory());
        particleFactoryMap.put(4, new FXFluffyRainbowParticle.Factory());
        particleFactoryMap.put(5, new FXPortalFloater.Factory());
    }

    public static interface FXFactory {
        @Nullable
        public Particle createParticle(double var1, double var3, double var5, double var7, double var9, double var11, int var13, float var14, int ... var15);
    }
}

