/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.render.entities.minions;

import javax.annotation.Nullable;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelCreeper;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.tslat.aoa3.client.render.entities.layers.RenderLayerFriendlyCreeperCharge;
import net.tslat.aoa3.entity.minions.EntityFriendlyCreeper;

public class FriendlyCreeperRenderer
extends RenderLiving<EntityFriendlyCreeper> {
    private static final ResourceLocation textures = new ResourceLocation("minecraft", "textures/entity/creeper/creeper.png");

    public FriendlyCreeperRenderer(RenderManager renderManager) {
        super(renderManager, (ModelBase)new ModelCreeper(), 0.2f);
        this.func_177094_a(new RenderLayerFriendlyCreeperCharge(this, this.field_77045_g));
    }

    protected void preRenderCallback(EntityFriendlyCreeper creeper, float partialTicks) {
        float flashIntensity = creeper.getCreeperFlashIntensity(partialTicks);
        float scaleRotationMod = 1.0f + MathHelper.func_76126_a((float)(flashIntensity * 100.0f)) * flashIntensity * 0.01f;
        flashIntensity = (float)Math.pow(MathHelper.func_76131_a((float)flashIntensity, (float)0.0f, (float)1.0f), 3.0);
        float scaleHorizontal = (1.0f + flashIntensity * 0.4f) * scaleRotationMod;
        float scaleVertical = (1.0f + flashIntensity * 0.1f) / scaleRotationMod;
        GlStateManager.func_179152_a((float)scaleHorizontal, (float)scaleVertical, (float)scaleHorizontal);
    }

    protected int getColorMultiplier(EntityFriendlyCreeper creeper, float lightBrightness, float partialTickTime) {
        float flashIntensity = creeper.getCreeperFlashIntensity(partialTickTime);
        if ((int)(flashIntensity * 10.0f) % 2 == 0) {
            return 0;
        }
        int flashColourMod = MathHelper.func_76125_a((int)((int)(flashIntensity * 0.2f * 255.0f)), (int)0, (int)255);
        return flashColourMod << 24 | 0x30FFFFFF;
    }

    @Nullable
    protected ResourceLocation getEntityTexture(EntityFriendlyCreeper entity) {
        return textures;
    }
}

