/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.render.entities.mobs.overworld;

import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelZombie;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.entity.RenderBiped;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.layers.LayerHeldItem;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.entity.mobs.overworld.EntityClown;

@SideOnly(value=Side.CLIENT)
public class ClownRenderer
extends RenderBiped<EntityClown> {
    private final ResourceLocation texture;

    public ClownRenderer(RenderManager renderManager, ResourceLocation resource) {
        super(renderManager, (ModelBiped)new ModelZombie(), 0.16666667f);
        this.texture = resource;
    }

    protected void renderLayers(EntityClown entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scaleIn) {
        for (LayerRenderer layer : this.field_177097_h) {
            boolean flag = this.func_177092_a((EntityLivingBase)entitylivingbaseIn, partialTicks, layer.func_177142_b());
            if (layer.getClass().isAssignableFrom(LayerHeldItem.class)) {
                this.renderWeaponCorrectly((LayerRenderer<EntityClown>)layer, entitylivingbaseIn, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, scaleIn);
            } else {
                layer.func_177141_a((EntityLivingBase)entitylivingbaseIn, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, scaleIn);
            }
            if (!flag) continue;
            this.func_177091_f();
        }
    }

    private void renderWeaponCorrectly(LayerRenderer<EntityClown> layer, EntityClown entity, float limbWing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scaleIn) {
        ItemStack itemstack1;
        boolean flag = entity.func_184591_cq() == EnumHandSide.RIGHT;
        ItemStack itemstack = flag ? entity.func_184592_cb() : entity.func_184614_ca();
        ItemStack itemStack = itemstack1 = flag ? entity.func_184614_ca() : entity.func_184592_cb();
        if (!itemstack.func_190926_b() || !itemstack1.func_190926_b()) {
            GlStateManager.func_179094_E();
            if (this.func_177087_b().field_78091_s) {
                GlStateManager.func_179109_b((float)0.0f, (float)0.75f, (float)0.0f);
                GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
            }
            this.renderHeldItem((EntityLivingBase)entity, itemstack1, ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, EnumHandSide.RIGHT);
            this.renderHeldItem((EntityLivingBase)entity, itemstack, ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, EnumHandSide.LEFT);
            GlStateManager.func_179121_F();
        }
    }

    private void renderHeldItem(EntityLivingBase entity, ItemStack heldStack, ItemCameraTransforms.TransformType transform, EnumHandSide hand) {
        if (!heldStack.func_190926_b()) {
            GlStateManager.func_179094_E();
            if (entity.func_70093_af()) {
                GlStateManager.func_179109_b((float)0.0f, (float)0.2f, (float)0.0f);
            }
            this.translateToHand(hand);
            GlStateManager.func_179114_b((float)-45.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            boolean flag = hand == EnumHandSide.LEFT;
            GlStateManager.func_179109_b((float)((float)(flag ? -1 : 1) / 16.0f), (float)0.125f, (float)-0.625f);
            Minecraft.func_71410_x().func_175597_ag().func_187462_a(entity, heldStack, transform, flag);
            GlStateManager.func_179121_F();
        }
    }

    private void translateToHand(EnumHandSide hand) {
        ((ModelBiped)this.func_177087_b()).func_187073_a(0.0625f, hand);
    }

    @Nullable
    protected ResourceLocation getEntityTexture(EntityClown entity) {
        return this.texture;
    }
}

