/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.command;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.ConfigurationUtil;
import net.tslat.aoa3.utils.StringUtil;

public class CommandAoAWiki
extends CommandBase {
    private static final TextComponentString commandPrefix = new TextComponentString(TextFormatting.DARK_RED + "[AoA" + TextFormatting.GOLD + "Wiki" + TextFormatting.DARK_RED + "] ");

    public String func_71517_b() {
        return "aoawiki";
    }

    public String func_71518_a(ICommandSender sender) {
        return "command.aoawiki.usage";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length == 0) {
            this.messageSender(sender, Enums.CommandFeedbackType.INFO, "command.aoawiki.desc", new String[0]);
            return;
        }
        if (sender.func_130014_f_().field_72995_K) {
            String searchQuery;
            String baseUrl;
            block7: {
                baseUrl = "?";
                StringBuilder builder = new StringBuilder();
                for (int i = 0; i < args.length; ++i) {
                    builder.append(args[i]);
                    builder.append(" ");
                }
                searchQuery = builder.toString().trim();
                String currentLang = FMLCommonHandler.instance().getCurrentLanguage();
                if (searchQuery.equalsIgnoreCase("random")) {
                    searchQuery = "Special:Random";
                }
                try {
                    baseUrl = currentLang.equals("zh_cn") || currentLang.equals("zh_tw") ? "https://adventofascension-zh.gamepedia.com/index.php?search=" + URLEncoder.encode(searchQuery, "UTF-8") + "&title=Special:Search&go=Go" : "https://adventofascension.gamepedia.com/index.php?search=" + URLEncoder.encode(searchQuery, "UTF-8") + "&title=Special:Search&go=Go";
                }
                catch (UnsupportedEncodingException e) {
                    if (!ConfigurationUtil.MainConfig.doVerboseDebugging) break block7;
                    e.printStackTrace();
                }
            }
            if (searchQuery.equals("Special:Random")) {
                searchQuery = "???";
            }
            ITextComponent responseComponent = this.getComponentFromKeys("command.aoawiki.response", baseUrl, StringUtil.capitaliseFirstLetter(searchQuery));
            sender.func_145747_a(commandPrefix.func_150259_f().func_150257_a((ITextComponent)(responseComponent != null ? responseComponent : new TextComponentTranslation("command.aoawiki.response", new Object[]{baseUrl}))));
        }
    }

    @Nullable
    private ITextComponent getComponentFromKeys(String langKey, String url, String pageTitle) {
        return ITextComponent.Serializer.func_150699_a((String)("{\"translate\":\"" + langKey + "\",\"with\":[{\"text\":\"" + pageTitle + "\",\"color\":\"red\",\"underlined\":true,\"clickEvent\":{\"action\":\"open_url\",\"value\":\"" + url + "\"}}]}"));
    }

    public int func_82362_a() {
        return 0;
    }

    private void messageSender(ICommandSender sender, Enums.CommandFeedbackType type, String langKey, String ... args) {
        sender.func_145747_a(commandPrefix.func_150259_f().func_150257_a(StringUtil.getLocaleWithArguments(langKey, args).func_150255_a(new Style().func_150238_a(type.getColour()))));
    }
}

