/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.common.containers;

import net.minecraft.client.util.RecipeItemHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.Slot;
import net.minecraft.inventory.SlotCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketSetSlot;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.BlockRegister;
import net.tslat.aoa3.crafting.recipes.UpgradeKitRecipe;
import net.tslat.aoa3.utils.StringUtil;

public class ContainerDivineStation
extends Container {
    public InventoryDivineStation inputs = new InventoryDivineStation(this);
    public InventoryCraftResult output = new InventoryCraftResult();
    private final World world;
    private final BlockPos pos;
    private final EntityPlayer player;

    public ContainerDivineStation(EntityPlayer player, World world, BlockPos pos) {
        this.world = world;
        this.pos = pos;
        this.player = player;
        this.func_75146_a((Slot)new SlotCrafting(player, (InventoryCrafting)this.inputs, (IInventory)this.output, 0, 134, 23));
        this.func_75146_a(new Slot((IInventory)this.inputs, 0, 27, 23));
        this.func_75146_a(new Slot((IInventory)this.inputs, 1, 76, 23));
        for (int inventoryY = 0; inventoryY < 3; ++inventoryY) {
            for (int inventoryX = 0; inventoryX < 9; ++inventoryX) {
                this.func_75146_a(new Slot((IInventory)player.field_71071_by, inventoryX + inventoryY * 9 + 9, 8 + inventoryX * 18, 60 + inventoryY * 18));
            }
        }
        for (int hotbarSlot = 0; hotbarSlot < 9; ++hotbarSlot) {
            this.func_75146_a(new Slot((IInventory)player.field_71071_by, hotbarSlot, 8 + hotbarSlot * 18, 118));
        }
    }

    public void func_75130_a(IInventory inventory) {
        super.func_75130_a(inventory);
        if (inventory == this.inputs) {
            this.func_192389_a(this.world, this.player, this.inputs, this.output);
        }
    }

    public boolean func_75145_c(EntityPlayer playerIn) {
        if (this.world.func_180495_p(this.pos).func_177230_c() != BlockRegister.divineStation) {
            return false;
        }
        return this.player.func_70092_e((double)this.pos.func_177958_n() + 0.5, (double)this.pos.func_177956_o() + 0.5, (double)this.pos.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_75134_a(EntityPlayer player) {
        super.func_75134_a(player);
        if (!this.world.field_72995_K) {
            this.func_193327_a(player, this.world, (IInventory)this.inputs);
        }
    }

    public boolean func_94530_a(ItemStack stack, Slot slot) {
        return slot.field_75224_c != this.output && super.func_94530_a(stack, slot);
    }

    public ItemStack func_82846_b(EntityPlayer playerIn, int index) {
        ItemStack stack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack slotStack = slot.func_75211_c();
            stack = slotStack.func_77946_l();
            if (index == 0) {
                slotStack.func_77973_b().func_77622_d(slotStack, this.world, this.player);
                if (!this.func_75135_a(slotStack, 3, 39, true)) {
                    return ItemStack.field_190927_a;
                }
                slot.func_75220_a(slotStack, stack);
            } else if (index != 1 ? index < 39 && !this.func_75135_a(slotStack, 1, 2, false) : !this.func_75135_a(slotStack, 3, 39, false)) {
                return ItemStack.field_190927_a;
            }
            if (slotStack.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (slotStack.func_190916_E() == stack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            if (index == 0) {
                this.player.func_71019_a(slot.func_190901_a(this.player, slotStack), false);
            }
        }
        return stack;
    }

    protected void func_192389_a(World world, EntityPlayer player, InventoryCrafting inv, InventoryCraftResult craftResult) {
        if (!world.field_72995_K) {
            ItemStack resultStack = ItemStack.field_190927_a;
            IRecipe matchedRecipe = CraftingManager.func_192413_b((InventoryCrafting)inv, (World)world);
            if (matchedRecipe instanceof UpgradeKitRecipe && (matchedRecipe.func_192399_d() || !world.func_82736_K().func_82766_b("doLimitedCrafting") || ((EntityPlayerMP)player).func_192037_E().func_193830_f(matchedRecipe))) {
                craftResult.func_193056_a(matchedRecipe);
                resultStack = matchedRecipe.func_77572_b(inv);
            }
            craftResult.func_70299_a(0, resultStack);
            ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new SPacketSetSlot(this.field_75152_c, 0, resultStack));
        }
    }

    public static class InventoryDivineStation
    extends InventoryCrafting {
        private final NonNullList<ItemStack> stackList = NonNullList.func_191197_a((int)2, (Object)ItemStack.field_190927_a);
        private final Container eventListener;

        public InventoryDivineStation(Container container) {
            super(container, 0, 0);
            this.eventListener = container;
        }

        public int func_70302_i_() {
            return 2;
        }

        public boolean func_191420_l() {
            for (ItemStack stack : this.stackList) {
                if (stack.func_190926_b()) continue;
                return false;
            }
            return true;
        }

        public ItemStack func_70301_a(int index) {
            return index >= this.func_70302_i_() || index < 0 ? ItemStack.field_190927_a : (ItemStack)this.stackList.get(index);
        }

        public ItemStack func_70463_b(int row, int column) {
            return row == 1 && column >= 0 && column <= 1 ? this.func_70301_a(column) : ItemStack.field_190927_a;
        }

        public String func_70005_c_() {
            return "container.aoa3.divineStation";
        }

        public boolean func_145818_k_() {
            return false;
        }

        public ITextComponent func_145748_c_() {
            return StringUtil.getLocale(this.func_70005_c_());
        }

        public ItemStack func_70304_b(int index) {
            return ItemStackHelper.func_188383_a(this.stackList, (int)index);
        }

        public ItemStack func_70298_a(int index, int count) {
            ItemStack stack = ItemStackHelper.func_188382_a(this.stackList, (int)index, (int)count);
            if (!stack.func_190926_b()) {
                this.eventListener.func_75130_a((IInventory)this);
            }
            return stack;
        }

        public void func_70299_a(int index, ItemStack stack) {
            this.stackList.set(index, (Object)stack);
            this.eventListener.func_75130_a((IInventory)this);
        }

        public void func_174888_l() {
            this.stackList.clear();
        }

        public void func_194018_a(RecipeItemHelper recipeItemHelper) {
            for (ItemStack stack : this.stackList) {
                recipeItemHelper.func_194112_a(stack);
            }
        }
    }
}

