/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.common.packet;

import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.common.handlers.PlayerCrownHandler;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.ConfigurationUtil;
import org.apache.logging.log4j.Level;

public class PacketChangedCrown
implements IMessage {
    private String crownChoice;

    public PacketChangedCrown() {
    }

    public PacketChangedCrown(@Nonnull Enums.PlayerCrownTypes.ChooseableCrownTypes crownChoice) {
        this.crownChoice = crownChoice.toString();
    }

    public void fromBytes(ByteBuf buffer) {
        this.crownChoice = ByteBufUtils.readUTF8String((ByteBuf)buffer);
    }

    public void toBytes(ByteBuf buffer) {
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.crownChoice);
    }

    public static class Handler
    implements IMessageHandler<PacketChangedCrown, IMessage> {
        public IMessage onMessage(PacketChangedCrown msg, MessageContext ctx) {
            Enums.PlayerCrownTypes preferredCrown;
            block2: {
                preferredCrown = Enums.PlayerCrownTypes.Donator;
                try {
                    preferredCrown = Enums.PlayerCrownTypes.ChooseableCrownTypes.valueOf(msg.crownChoice).toBaseType();
                }
                catch (IllegalArgumentException e) {
                    if (!ConfigurationUtil.MainConfig.doVerboseDebugging) break block2;
                    AdventOfAscension.logMessage(Level.WARN, "Error parsing crown info from client: " + msg.crownChoice);
                    e.printStackTrace();
                }
            }
            PlayerCrownHandler.syncNewCrownChoice(ctx.getServerHandler().field_147369_b.func_146103_bH().getId(), preferredCrown);
            return null;
        }
    }
}

