/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.common.packet;

import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.common.handlers.PlayerCrownHandler;
import net.tslat.aoa3.library.Enums;

public class PacketPlayerCrownInfo
implements IMessage {
    private int mapSize;
    private HashMap<UUID, PlayerCrownHandler.PlayerCrownContainer> crownsMap;

    public PacketPlayerCrownInfo() {
    }

    public PacketPlayerCrownInfo(UUID uuid, Enums.PlayerCrownTypes crown) {
        this.crownsMap = new HashMap();
        this.mapSize = 1;
        this.crownsMap.put(uuid, new PlayerCrownHandler.PlayerCrownContainer(crown));
    }

    public PacketPlayerCrownInfo(HashMap<UUID, PlayerCrownHandler.PlayerCrownContainer> crownsMap) {
        this.mapSize = crownsMap.size();
        this.crownsMap = crownsMap;
    }

    public void fromBytes(ByteBuf buffer) {
        this.mapSize = buffer.readInt();
        this.crownsMap = new HashMap();
        for (int i = 0; i < this.mapSize; ++i) {
            try {
                this.crownsMap.put(UUID.fromString(ByteBufUtils.readUTF8String((ByteBuf)buffer)), new PlayerCrownHandler.PlayerCrownContainer(Enums.PlayerCrownTypes.valueOf(ByteBufUtils.readUTF8String((ByteBuf)buffer))));
                continue;
            }
            catch (Exception e) {
                ++i;
            }
        }
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeInt(this.mapSize);
        for (Map.Entry<UUID, PlayerCrownHandler.PlayerCrownContainer> entry : this.crownsMap.entrySet()) {
            ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)entry.getKey().toString());
            ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)entry.getValue().getPreferredCrown().toString());
        }
    }

    public static class Handler
    implements IMessageHandler<PacketPlayerCrownInfo, IMessage> {
        public IMessage onMessage(PacketPlayerCrownInfo msg, MessageContext ctx) {
            AdventOfAscension.logOptionalMessage("Received player crowns map update");
            for (Map.Entry entry : msg.crownsMap.entrySet()) {
                PlayerCrownHandler.setCrownChoice((UUID)entry.getKey(), ((PlayerCrownHandler.PlayerCrownContainer)entry.getValue()).getPreferredCrown());
                AdventOfAscension.logOptionalMessage("UUID: " + entry.getKey() + "; Crown: " + ((PlayerCrownHandler.PlayerCrownContainer)entry.getValue()).getPreferredCrown().toString());
            }
            return null;
        }
    }
}

