/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.common.packet;

import io.netty.buffer.ByteBuf;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.tslat.aoa3.client.gui.mainwindow.AdventGuiTabPlayer;
import net.tslat.aoa3.client.gui.render.ResourcesRenderer;

public class PacketResourceData
implements IMessage {
    private float creation;
    private float energy;
    private float rage;
    private float soul;
    private boolean revengeActive;

    public PacketResourceData() {
    }

    public PacketResourceData(float creation, float energy, float rage, float soul, boolean revengeActive) {
        this.creation = creation;
        this.energy = energy;
        this.rage = rage;
        this.soul = soul;
        this.revengeActive = revengeActive;
    }

    public void fromBytes(ByteBuf buffer) {
        this.creation = buffer.readFloat();
        this.energy = buffer.readFloat();
        this.rage = buffer.readFloat();
        this.soul = buffer.readFloat();
        this.revengeActive = buffer.readBoolean();
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeFloat(this.creation);
        buffer.writeFloat(this.energy);
        buffer.writeFloat(this.rage);
        buffer.writeFloat(this.soul);
        buffer.writeBoolean(this.revengeActive);
    }

    public static class Handler
    implements IMessageHandler<PacketResourceData, IMessage> {
        public IMessage onMessage(PacketResourceData msg, MessageContext ctx) {
            AdventGuiTabPlayer.resourceCreation = msg.creation;
            AdventGuiTabPlayer.resourceEnergy = msg.energy;
            AdventGuiTabPlayer.resourceRage = msg.rage;
            AdventGuiTabPlayer.resourceSoul = msg.soul;
            ResourcesRenderer.revengeActive = msg.revengeActive;
            return null;
        }
    }
}

