/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.common.packet;

import io.netty.buffer.ByteBuf;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.library.Enums;

public class PacketScreenOverlay
implements IMessage {
    private int durationTicks;
    private int screenId;

    public PacketScreenOverlay() {
    }

    public PacketScreenOverlay(int duration, Enums.ScreenOverlays screen) {
        this.durationTicks = duration;
        this.screenId = screen.id;
    }

    public void fromBytes(ByteBuf buffer) {
        this.durationTicks = ByteBufUtils.readVarShort((ByteBuf)buffer);
        this.screenId = ByteBufUtils.readVarShort((ByteBuf)buffer);
    }

    public void toBytes(ByteBuf buffer) {
        ByteBufUtils.writeVarShort((ByteBuf)buffer, (int)this.durationTicks);
        ByteBufUtils.writeVarShort((ByteBuf)buffer, (int)this.screenId);
    }

    public static class Handler
    implements IMessageHandler<PacketScreenOverlay, IMessage> {
        public IMessage onMessage(PacketScreenOverlay message, MessageContext ctx) {
            AdventOfAscension.proxy.displayScreenOverlay(message.durationTicks, Enums.ScreenOverlays.getById(message.screenId));
            return null;
        }
    }
}

