/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.common.packet;

import io.netty.buffer.ByteBuf;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.client.gui.mainwindow.AdventGuiTabPlayer;
import net.tslat.aoa3.library.Enums;
import org.apache.logging.log4j.Level;

public class PacketSkillData
implements IMessage {
    private int skillId;
    private int level;
    private float xp;
    private int data;

    public PacketSkillData() {
    }

    public PacketSkillData(int skill, int lvl, float xp, Integer opt) {
        this.skillId = skill;
        this.level = lvl;
        this.xp = xp;
        if (opt == null) {
            opt = 0;
        }
        this.data = opt;
    }

    public void fromBytes(ByteBuf buffer) {
        this.skillId = buffer.readInt();
        this.level = buffer.readInt();
        this.xp = buffer.readFloat();
        this.data = buffer.readInt();
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeInt(this.skillId);
        buffer.writeInt(this.level);
        buffer.writeFloat(this.xp);
        buffer.writeInt(this.data);
    }

    public static class Handler
    implements IMessageHandler<PacketSkillData, IMessage> {
        public IMessage onMessage(PacketSkillData msg, MessageContext ctx) {
            Enums.Skills skill = Enums.Skills.getById(msg.skillId);
            if (skill != null) {
                AdventGuiTabPlayer.setSkillData(skill, msg.xp, msg.level, msg.data);
            } else {
                AdventOfAscension.logMessage(Level.WARN, "Error trying to set skill data in client skills holder, skipping");
            }
            return null;
        }
    }
}

