/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.dimension.barathos.biomes;

import com.google.common.base.Predicate;
import java.awt.Color;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.common.registration.BlockRegister;
import net.tslat.aoa3.dimension.AoABiomeDecorator;
import net.tslat.aoa3.structure.StructuresHandler;
import net.tslat.aoa3.utils.ConfigurationUtil;

public class BiomeBarathos
extends Biome {
    private static final Biome.BiomeProperties properties = new Biome.BiomeProperties("Barathos");

    public BiomeBarathos() {
        super(properties);
        this.setRegistryName("aoa3", "barathos");
        this.field_76752_A = BlockRegister.getUnmappedBlock("baron_ground").func_176223_P();
        this.field_76753_B = BlockRegister.getUnmappedBlock("baron_stone").func_176223_P();
        this.field_82914_M.clear();
        this.field_76762_K.clear();
        this.field_76761_J.clear();
        this.field_76755_L.clear();
        this.field_76760_I = new BiomeBarathosDecorator();
    }

    public void biomeInit() {
        BiomeDictionary.addTypes((Biome)this, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.HOT, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.DEAD, BiomeDictionary.Type.WASTELAND, BiomeDictionary.Type.DRY});
    }

    @SideOnly(value=Side.CLIENT)
    public int func_76731_a(float currentTemperature) {
        return Color.ORANGE.getRGB();
    }

    static {
        properties.func_185396_a();
        properties.func_185410_a(2.0f);
        properties.func_185395_b(500.0f);
        properties.func_185396_a();
        properties.func_185398_c(0.0f);
        properties.func_185400_d(0.35f);
    }

    public static class BiomeBarathosDecorator
    extends AoABiomeDecorator {
        @Override
        protected void doOreGen(World world, Biome biome, Random rand, BlockPos basePos, BlockPos.MutableBlockPos pos, int posX, int posY, int posZ) {
            int i;
            for (i = 0; i < ConfigurationUtil.OreConfig.varsium.veinsPerChunk; ++i) {
                new WorldGenMinable(BlockRegister.oreVarsium.func_176223_P(), Math.max(ConfigurationUtil.OreConfig.varsium.minOresPerVein, rand.nextInt(ConfigurationUtil.OreConfig.varsium.maxOresPerVein) + 1), (Predicate)BlockMatcher.func_177642_a((Block)BlockRegister.stoneBaron)).func_180709_b(world, rand, basePos.func_177982_a(rand.nextInt(16), rand.nextInt(38) + 25, rand.nextInt(16)));
            }
            for (i = 0; i < ConfigurationUtil.OreConfig.baronyte.veinsPerChunk; ++i) {
                new WorldGenMinable(BlockRegister.oreBaronyte.func_176223_P(), Math.max(ConfigurationUtil.OreConfig.baronyte.minOresPerVein, rand.nextInt(ConfigurationUtil.OreConfig.baronyte.maxOresPerVein) + 1), (Predicate)BlockMatcher.func_177642_a((Block)BlockRegister.stoneBaron)).func_180709_b(world, rand, basePos.func_177982_a(rand.nextInt(16), rand.nextInt(10) + 25, rand.nextInt(16)));
            }
            for (i = 0; i < ConfigurationUtil.OreConfig.blazium.veinsPerChunk; ++i) {
                new WorldGenMinable(BlockRegister.oreBlazium.func_176223_P(), Math.max(ConfigurationUtil.OreConfig.blazium.minOresPerVein, rand.nextInt(ConfigurationUtil.OreConfig.blazium.maxOresPerVein) + 1), (Predicate)BlockMatcher.func_177642_a((Block)BlockRegister.stoneBarathos)).func_180709_b(world, rand, basePos.func_177982_a(rand.nextInt(16), rand.nextInt(20), rand.nextInt(16)));
            }
        }

        @Override
        protected void doMiscGen(World world, Biome biome, Random rand, BlockPos basePos, BlockPos.MutableBlockPos pos, int posX, int posY, int posZ) {
            IBlockState testBlock;
            switch (rand.nextInt(4)) {
                case 0: {
                    posX = basePos.func_177958_n() + rand.nextInt(16);
                    posZ = basePos.func_177952_p() + rand.nextInt(16);
                    posY = world.func_189649_b(posX + 3, posZ + 2);
                    testBlock = world.func_180495_p((BlockPos)pos.func_181079_c(posX + 3, posY - 1, posZ + 2));
                    if (testBlock != biome.field_76752_A && testBlock != biome.field_76753_B) break;
                    StructuresHandler.generateStructure("SmallBaronRock1", world, rand, (BlockPos)pos.func_181079_c(posX, posY, posZ));
                    break;
                }
                case 1: {
                    posX = basePos.func_177958_n() + rand.nextInt(16);
                    posZ = basePos.func_177952_p() + rand.nextInt(16);
                    posY = world.func_189649_b(posX + 1, posZ + 3);
                    testBlock = world.func_180495_p((BlockPos)pos.func_181079_c(posX + 1, posY - 1, posZ + 3));
                    if (testBlock != biome.field_76752_A && testBlock != biome.field_76753_B) break;
                    StructuresHandler.generateStructure("SmallBaronRock2", world, rand, (BlockPos)pos.func_181079_c(posX, posY, posZ));
                    break;
                }
                case 2: {
                    posX = basePos.func_177958_n() + rand.nextInt(16);
                    posZ = basePos.func_177952_p() + rand.nextInt(16);
                    posY = world.func_189649_b(posX + 2, posZ + 1);
                    testBlock = world.func_180495_p((BlockPos)pos.func_181079_c(posX + 2, posY - 1, posZ + 1));
                    if (testBlock != biome.field_76752_A && testBlock != biome.field_76753_B) break;
                    StructuresHandler.generateStructure("SmallBaronRock3", world, rand, (BlockPos)pos.func_181079_c(posX, posY, posZ));
                    break;
                }
                case 3: {
                    posX = basePos.func_177958_n() + rand.nextInt(16);
                    posZ = basePos.func_177952_p() + rand.nextInt(16);
                    posY = world.func_189649_b(posX + 1, posZ + 1);
                    testBlock = world.func_180495_p((BlockPos)pos.func_181079_c(posX + 1, posY - 1, posZ + 1));
                    if (testBlock != biome.field_76752_A && testBlock != biome.field_76753_B) break;
                    StructuresHandler.generateStructure("SmallBaronRock4", world, rand, (BlockPos)pos.func_181079_c(posX, posY, posZ));
                }
            }
            if (rand.nextInt(15) == 0) {
                switch (rand.nextInt(8)) {
                    case 0: {
                        posX = basePos.func_177958_n() + rand.nextInt(16);
                        posZ = basePos.func_177952_p() + rand.nextInt(16);
                        posY = world.func_189649_b(posX + 4, posZ + 5);
                        testBlock = world.func_180495_p((BlockPos)pos.func_181079_c(posX + 4, posY - 1, posZ + 5));
                        if (testBlock != biome.field_76752_A && testBlock != biome.field_76753_B) break;
                        StructuresHandler.generateStructure("BaronRock1", world, rand, (BlockPos)pos.func_181079_c(posX, posY - 1, posZ));
                        break;
                    }
                    case 1: {
                        posX = basePos.func_177958_n() + rand.nextInt(16);
                        posZ = basePos.func_177952_p() + rand.nextInt(16);
                        posY = world.func_189649_b(posX + 5, posZ + 5);
                        testBlock = world.func_180495_p((BlockPos)pos.func_181079_c(posX + 5, posY - 1, posZ + 5));
                        if (testBlock != biome.field_76752_A && testBlock != biome.field_76753_B) break;
                        StructuresHandler.generateStructure("BaronRock2", world, rand, (BlockPos)pos.func_181079_c(posX, posY - 1, posZ));
                        break;
                    }
                    case 2: {
                        posX = basePos.func_177958_n() + rand.nextInt(16);
                        posZ = basePos.func_177952_p() + rand.nextInt(16);
                        posY = world.func_189649_b(posX + 4, posZ + 4);
                        testBlock = world.func_180495_p((BlockPos)pos.func_181079_c(posX + 4, posY - 1, posZ + 4));
                        if (testBlock != biome.field_76752_A && testBlock != biome.field_76753_B) break;
                        StructuresHandler.generateStructure("BaronRock3", world, rand, (BlockPos)pos.func_181079_c(posX, posY - 1, posZ));
                        break;
                    }
                    case 3: {
                        posX = basePos.func_177958_n() + rand.nextInt(16);
                        posZ = basePos.func_177952_p() + rand.nextInt(16);
                        posY = world.func_189649_b(posX + 5, posZ + 5);
                        testBlock = world.func_180495_p((BlockPos)pos.func_181079_c(posX + 5, posY - 1, posZ + 5));
                        if (testBlock != biome.field_76752_A && testBlock != biome.field_76753_B) break;
                        StructuresHandler.generateStructure("BaronRock4", world, rand, (BlockPos)pos.func_181079_c(posX, posY - 1, posZ));
                        break;
                    }
                    case 4: {
                        posX = basePos.func_177958_n() + rand.nextInt(15);
                        posZ = basePos.func_177952_p() + rand.nextInt(16);
                        posY = world.func_189649_b(posX + 5, posZ + 5);
                        testBlock = world.func_180495_p((BlockPos)pos.func_181079_c(posX + 5, posY - 1, posZ + 5));
                        if (testBlock != biome.field_76752_A && testBlock != biome.field_76753_B) break;
                        StructuresHandler.generateStructure("BaronRock5", world, rand, (BlockPos)pos.func_181079_c(posX, posY - 1, posZ));
                        break;
                    }
                    case 5: {
                        posX = basePos.func_177958_n() + rand.nextInt(16);
                        posZ = basePos.func_177952_p() + rand.nextInt(16);
                        posY = world.func_189649_b(posX + 7, posZ + 4);
                        testBlock = world.func_180495_p((BlockPos)pos.func_181079_c(posX + 7, posY - 1, posZ + 4));
                        if (testBlock != biome.field_76752_A && testBlock != biome.field_76753_B) break;
                        StructuresHandler.generateStructure("BaronRock6", world, rand, (BlockPos)pos.func_181079_c(posX, posY - 1, posZ));
                        break;
                    }
                    case 6: {
                        posX = basePos.func_177958_n() + rand.nextInt(16);
                        posZ = basePos.func_177952_p() + rand.nextInt(16);
                        posY = world.func_189649_b(posX + 4, posZ + 4);
                        testBlock = world.func_180495_p((BlockPos)pos.func_181079_c(posX + 4, posY - 1, posZ + 4));
                        if (testBlock != biome.field_76752_A && testBlock != biome.field_76753_B) break;
                        StructuresHandler.generateStructure("BaronRock7", world, rand, (BlockPos)pos.func_181079_c(posX, posY - 1, posZ));
                        break;
                    }
                    case 7: {
                        posX = basePos.func_177958_n() + rand.nextInt(16);
                        posZ = basePos.func_177952_p() + rand.nextInt(16);
                        posY = world.func_189649_b(posX + 4, posZ + 5);
                        testBlock = world.func_180495_p((BlockPos)pos.func_181079_c(posX + 4, posY - 1, posZ + 5));
                        if (testBlock != biome.field_76752_A && testBlock != biome.field_76753_B) break;
                        StructuresHandler.generateStructure("BaronRock8", world, rand, (BlockPos)pos.func_181079_c(posX, posY - 1, posZ));
                    }
                }
            }
        }
    }
}

