/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.dimension.celeve.biomes;

import java.awt.Color;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.common.registration.BlockRegister;
import net.tslat.aoa3.dimension.AoABiomeDecorator;
import net.tslat.aoa3.structure.StructuresHandler;

public class BiomeCeleve
extends Biome {
    private static final Biome.BiomeProperties properties = new Biome.BiomeProperties("Celeve");

    public BiomeCeleve() {
        super(properties);
        this.setRegistryName("aoa3", "celeve");
        this.field_76752_A = BlockRegister.getUnmappedBlock("celeve_grass").func_176223_P();
        this.field_76753_B = BlockRegister.getUnmappedBlock("celeve_dirt").func_176223_P();
        this.field_82914_M.clear();
        this.field_76762_K.clear();
        this.field_76761_J.clear();
        this.field_76755_L.clear();
        this.field_76760_I = new BiomeCeleveDecorator();
    }

    public void biomeInit() {
        BiomeDictionary.addTypes((Biome)this, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.MAGICAL});
    }

    @SideOnly(value=Side.CLIENT)
    public int func_76731_a(float currentTemperature) {
        return Color.GREEN.getRGB();
    }

    static {
        properties.func_185396_a();
        properties.func_185410_a(0.5f);
        properties.func_185395_b(0.0f);
        properties.func_185396_a();
        properties.func_185398_c(0.1f);
        properties.func_185400_d(0.2f);
    }

    public class BiomeCeleveDecorator
    extends AoABiomeDecorator {
        @Override
        protected void doPlantGen(World world, Biome biome, Random rand, BlockPos basePos, BlockPos.MutableBlockPos pos, int posX, int posY, int posZ) {
            block7: for (int i = 0; i < 60; ++i) {
                posX = basePos.func_177958_n() + rand.nextInt(16);
                if (world.func_180495_p((BlockPos)pos.func_181079_c(posX, (posY = world.func_189649_b(posX, posZ = basePos.func_177952_p() + rand.nextInt(16))) - 1, posZ)) != biome.field_76752_A) continue;
                switch (rand.nextInt(5)) {
                    case 0: {
                        world.func_175656_a((BlockPos)pos.func_181079_c(posX, posY, posZ), BlockRegister.plantCeleviansBlue.func_176223_P());
                        continue block7;
                    }
                    case 1: {
                        world.func_175656_a((BlockPos)pos.func_181079_c(posX, posY, posZ), BlockRegister.plantCeleviansRed.func_176223_P());
                        continue block7;
                    }
                    case 2: {
                        world.func_175656_a((BlockPos)pos.func_181079_c(posX, posY, posZ), BlockRegister.plantCeleviansWhite.func_176223_P());
                        continue block7;
                    }
                    case 3: {
                        world.func_175656_a((BlockPos)pos.func_181079_c(posX, posY, posZ), BlockRegister.plantCeleviansPurple.func_176223_P());
                        continue block7;
                    }
                    case 4: {
                        StructuresHandler.generateStructure("Celebulb", world, rand, (BlockPos)pos.func_181079_c(posX, posY, posZ));
                    }
                }
            }
        }

        @Override
        protected void doTreeGen(World world, Biome biome, Random rand, BlockPos basePos, BlockPos.MutableBlockPos pos, int posX, int posY, int posZ) {
            block6: for (int i = 0; i < 2; ++i) {
                posX = basePos.func_177958_n() + rand.nextInt(16);
                if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 2, (posY = world.func_189649_b(posX + 2, (posZ = basePos.func_177952_p() + rand.nextInt(16)) + 2)) - 1, posZ + 2)) != biome.field_76752_A) continue;
                switch (rand.nextInt(4)) {
                    case 0: {
                        StructuresHandler.generateStructure("BlueCelevusTree", world, rand, (BlockPos)pos.func_181079_c(posX, posY, posZ));
                        continue block6;
                    }
                    case 1: {
                        StructuresHandler.generateStructure("GreenCelevusTree", world, rand, (BlockPos)pos.func_181079_c(posX, posY, posZ));
                        continue block6;
                    }
                    case 2: {
                        StructuresHandler.generateStructure("PurpleCelevusTree", world, rand, (BlockPos)pos.func_181079_c(posX, posY, posZ));
                        continue block6;
                    }
                    case 3: {
                        StructuresHandler.generateStructure("YellowCelevusTree", world, rand, (BlockPos)pos.func_181079_c(posX, posY, posZ));
                    }
                }
            }
        }

        @Override
        protected void doMiscGen(World world, Biome biome, Random rand, BlockPos basePos, BlockPos.MutableBlockPos pos, int posX, int posY, int posZ) {
            posX = basePos.func_177958_n() + rand.nextInt(16);
            if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 2, (posY = world.func_189649_b(posX + 2, (posZ = basePos.func_177952_p() + rand.nextInt(16)) + 2)) - 1, posZ + 2)) == biome.field_76752_A) {
                StructuresHandler.generateStructure("CelevePole", world, rand, (BlockPos)pos.func_181079_c(posX, posY, posZ));
            }
        }
    }
}

