/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.dimension.crystevia;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.NoiseGeneratorOctaves;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.terraingen.ChunkGeneratorEvent;
import net.minecraftforge.event.terraingen.InitNoiseGensEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.tslat.aoa3.common.registration.BiomeRegister;
import net.tslat.aoa3.common.registration.BlockRegister;
import net.tslat.aoa3.structure.AoAStructure;
import net.tslat.aoa3.structure.StructuresHandler;
import net.tslat.aoa3.utils.ConfigurationUtil;

public class ChunkGenCrystevia
implements IChunkGenerator {
    private final World world;
    private final Random rand;
    private ChunkPrimer primer;
    private int curChunkX;
    private int curChunkZ;
    private final Biome biome = BiomeRegister.biomeCrystevia;
    private double[] noiseArray;
    private double[] depthBuffer = new double[256];
    private NoiseGeneratorOctaves minLimitPerlinNoiseGen;
    private NoiseGeneratorOctaves maxLimitPerlinNoiseGen;
    private NoiseGeneratorOctaves mainPerlinNoiseGen;
    private NoiseGeneratorOctaves stoneNoiseGen;
    private NoiseGeneratorOctaves gravelAndSandNoiseGen;
    private NoiseGeneratorOctaves scaleNoiseGen;
    private NoiseGeneratorOctaves depthNoiseGen;
    private double[] pnr;
    private double[] ar;
    private double[] br;
    private double[] noiseData4;
    private double[] dr;
    private static final double depthNoiseScaleX = 200.0;
    private static final double depthNoiseScaleZ = 200.0;
    private static final double depthNoiseScaleExponent = 0.5;
    private static final double coordScale = 684.412;
    private static final int mainNoiseScaleX = 80;
    private static final int mainNoiseScaleY = 160;
    private static final int mainNoiseScaleZ = 80;
    private static final double heightScale = 684.412;
    private static final int biomeDepthOffset = 0;
    private static final int biomeScaleOffset = 0;
    private static final double heightStretch = 12.0;
    private static final double baseSize = 8.5;
    private static final double lowerLimitScale = 512.0;
    private static final double upperLimitScale = 512.0;
    private static final float biomeDepthWeight = 1.0f;
    private static final float biomeScaleWeight = 1.0f;

    protected ChunkGenCrystevia(World world) {
        this.world = world;
        this.rand = new Random(world.func_72905_C());
        this.world.func_181544_b(0);
        this.minLimitPerlinNoiseGen = new NoiseGeneratorOctaves(this.rand, 16);
        this.maxLimitPerlinNoiseGen = new NoiseGeneratorOctaves(this.rand, 16);
        this.mainPerlinNoiseGen = new NoiseGeneratorOctaves(this.rand, 8);
        this.gravelAndSandNoiseGen = new NoiseGeneratorOctaves(this.rand, 4);
        this.stoneNoiseGen = new NoiseGeneratorOctaves(this.rand, 4);
        this.scaleNoiseGen = new NoiseGeneratorOctaves(this.rand, 10);
        this.depthNoiseGen = new NoiseGeneratorOctaves(this.rand, 16);
        InitNoiseGensEvent.ContextHell context = new InitNoiseGensEvent.ContextHell(this.minLimitPerlinNoiseGen, this.maxLimitPerlinNoiseGen, this.mainPerlinNoiseGen, this.gravelAndSandNoiseGen, this.stoneNoiseGen, this.scaleNoiseGen, this.depthNoiseGen);
        context = (InitNoiseGensEvent.ContextHell)TerrainGen.getModdedNoiseGenerators((World)world, (Random)this.rand, (InitNoiseGensEvent.Context)context);
        this.minLimitPerlinNoiseGen = context.getLPerlin1();
        this.maxLimitPerlinNoiseGen = context.getLPerlin2();
        this.mainPerlinNoiseGen = context.getPerlin();
        this.gravelAndSandNoiseGen = context.getPerlin2();
        this.stoneNoiseGen = context.getPerlin3();
        this.scaleNoiseGen = context.getScale();
        this.depthNoiseGen = context.getDepth();
    }

    public Chunk func_185932_a(int chunkX, int chunkZ) {
        this.curChunkX = chunkX;
        this.curChunkZ = chunkZ;
        this.rand.setSeed((long)chunkX * 341873128712L + (long)chunkZ * 132897987541L);
        this.primer = new ChunkPrimer();
        this.setBlocksInChunk();
        this.replaceBiomeBlocks();
        Chunk chunk = new Chunk(this.world, this.primer, this.curChunkX, this.curChunkZ);
        byte[] biomeArray = chunk.func_76605_m();
        for (int i = 0; i < biomeArray.length; ++i) {
            biomeArray[i] = (byte)Biome.func_185362_a((Biome)this.biome);
        }
        return chunk;
    }

    private double[] generateNoiseField(double[] buffer, int xRef, int yRef, int zRef, int bufferX, int bufferY, int bufferZ) {
        if (buffer == null) {
            buffer = new double[bufferX * bufferY * bufferZ];
        }
        ChunkGeneratorEvent.InitNoiseField event = new ChunkGeneratorEvent.InitNoiseField((IChunkGenerator)this, buffer, xRef, yRef, zRef, bufferX, bufferY, bufferZ);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.getResult() == Event.Result.DENY) {
            return event.getNoisefield();
        }
        double d0 = 684.412;
        double d1 = 2053.236;
        this.noiseData4 = this.scaleNoiseGen.func_76304_a(this.noiseData4, xRef, yRef, zRef, bufferX, 1, bufferZ, 1.0, 0.0, 1.0);
        this.dr = this.depthNoiseGen.func_76304_a(this.dr, xRef, yRef, zRef, bufferX, 1, bufferZ, 100.0, 0.0, 100.0);
        this.pnr = this.mainPerlinNoiseGen.func_76304_a(this.pnr, xRef, yRef, zRef, bufferX, bufferY, bufferZ, 8.555150000000001, 34.2206, 8.555150000000001);
        this.ar = this.minLimitPerlinNoiseGen.func_76304_a(this.ar, xRef, yRef, zRef, bufferX, bufferY, bufferZ, 684.412, 2053.236, 684.412);
        this.br = this.maxLimitPerlinNoiseGen.func_76304_a(this.br, xRef, yRef, zRef, bufferX, bufferY, bufferZ, 684.412, 2053.236, 684.412);
        int i = 0;
        double[] adouble = new double[bufferY];
        for (int j = 0; j < bufferY; ++j) {
            adouble[j] = Math.cos((double)j * Math.PI * 6.0 / (double)bufferY) * 2.0;
            double d2 = j;
            if (j > bufferY / 2) {
                d2 = bufferY - 1 - j;
            }
            if (!(d2 < 4.0)) continue;
            d2 = 4.0 - d2;
            int n = j;
            adouble[n] = adouble[n] - d2 * d2 * d2 * 10.0;
        }
        for (int l = 0; l < bufferX; ++l) {
            for (int i1 = 0; i1 < bufferZ; ++i1) {
                for (int k = 0; k < bufferY; ++k) {
                    double d4 = adouble[k];
                    double d5 = this.ar[i] / 512.0;
                    double d6 = this.br[i] / 512.0;
                    double d7 = (this.pnr[i] / 10.0 + 1.0) / 2.0;
                    double d8 = d7 < 0.0 ? d5 : (d7 > 1.0 ? d6 : d5 + (d6 - d5) * d7);
                    d8 -= d4;
                    if (k > bufferY - 4) {
                        double d9 = (float)(k - (bufferY - 4)) / 3.0f;
                        d8 = d8 * (1.0 - d9) + -10.0 * d9;
                    }
                    if ((double)k < 0.0) {
                        double d10 = (0.0 - (double)k) / 4.0;
                        d10 = MathHelper.func_151237_a((double)d10, (double)0.0, (double)1.0);
                        d8 = d8 * (1.0 - d10) + -10.0 * d10;
                    }
                    buffer[i] = d8;
                    ++i;
                }
            }
        }
        return buffer;
    }

    private void setBlocksInChunk() {
        this.noiseArray = this.generateNoiseField(this.noiseArray, this.curChunkX * 4, 0, this.curChunkZ * 4, 5, 17, 5);
        for (int j1 = 0; j1 < 4; ++j1) {
            for (int k1 = 0; k1 < 4; ++k1) {
                for (int l1 = 0; l1 < 16; ++l1) {
                    double d1 = this.noiseArray[(j1 * 5 + k1) * 17 + l1];
                    double d2 = this.noiseArray[(j1 * 5 + k1 + 1) * 17 + l1];
                    double d3 = this.noiseArray[((j1 + 1) * 5 + k1) * 17 + l1];
                    double d4 = this.noiseArray[((j1 + 1) * 5 + k1 + 1) * 17 + l1];
                    double d5 = (this.noiseArray[(j1 * 5 + k1) * 17 + l1 + 1] - d1) * 0.125;
                    double d6 = (this.noiseArray[(j1 * 5 + k1 + 1) * 17 + l1 + 1] - d2) * 0.125;
                    double d7 = (this.noiseArray[((j1 + 1) * 5 + k1) * 17 + l1 + 1] - d3) * 0.125;
                    double d8 = (this.noiseArray[((j1 + 1) * 5 + k1 + 1) * 17 + l1 + 1] - d4) * 0.125;
                    for (int i2 = 0; i2 < 8; ++i2) {
                        double d10 = d1;
                        double d11 = d2;
                        double d12 = (d3 - d1) * 0.25;
                        double d13 = (d4 - d2) * 0.25;
                        for (int j2 = 0; j2 < 4; ++j2) {
                            double d15 = d10;
                            double d16 = (d11 - d10) * 0.25;
                            for (int k2 = 0; k2 < 4; ++k2) {
                                IBlockState iblockstate = null;
                                if (d15 > 0.0) {
                                    iblockstate = BlockRegister.stoneCrystevia.func_176223_P();
                                }
                                int l2 = j2 + j1 * 4;
                                int i3 = i2 + l1 * 8;
                                int j3 = k2 + k1 * 4;
                                this.primer.func_177855_a(l2, i3, j3, iblockstate);
                                d15 += d16;
                            }
                            d10 += d12;
                            d11 += d13;
                        }
                        d1 += d5;
                        d2 += d6;
                        d3 += d7;
                        d4 += d8;
                    }
                }
            }
        }
    }

    private void replaceBiomeBlocks() {
        if (!ForgeEventFactory.onReplaceBiomeBlocks((IChunkGenerator)this, (int)this.curChunkX, (int)this.curChunkZ, (ChunkPrimer)this.primer, (World)this.world)) {
            return;
        }
        int i = this.world.func_181545_F() + 1;
        this.depthBuffer = this.stoneNoiseGen.func_76304_a(this.depthBuffer, this.curChunkX * 16, this.curChunkZ * 16, 0, 16, 16, 1, 0.0625, 0.0625, 0.0625);
        for (int j = 0; j < 16; ++j) {
            for (int k = 0; k < 16; ++k) {
                int l = (int)(this.depthBuffer[j + k * 16] / 3.0 + 3.0 + this.rand.nextDouble() * 0.25);
                int i1 = -1;
                IBlockState iblockstate = BlockRegister.stoneCrystevia.func_176223_P();
                IBlockState iblockstate1 = BlockRegister.stoneCrystevia.func_176223_P();
                for (int j1 = 127; j1 >= 0; --j1) {
                    if (j1 < 125 && j1 > 2) {
                        IBlockState iblockstate2 = this.primer.func_177856_a(k, j1, j);
                        if (iblockstate2.func_185904_a() != Material.field_151579_a) {
                            if (iblockstate2.func_177230_c() != BlockRegister.stoneCrystevia) continue;
                            if (i1 == -1) {
                                if (l <= 0) {
                                    iblockstate = Blocks.field_150350_a.func_176223_P();
                                    iblockstate1 = BlockRegister.stoneCrystevia.func_176223_P();
                                } else if (j1 >= i - 4 && j1 <= i + 1) {
                                    iblockstate = BlockRegister.stoneCrystevia.func_176223_P();
                                    iblockstate1 = BlockRegister.stoneCrystevia.func_176223_P();
                                }
                                if (j1 < i && iblockstate.func_185904_a() == Material.field_151579_a) {
                                    iblockstate = Blocks.field_150355_j.func_176223_P();
                                }
                                i1 = l;
                                if (j1 >= i - 1) {
                                    this.primer.func_177855_a(k, j1, j, iblockstate);
                                    continue;
                                }
                                this.primer.func_177855_a(k, j1, j, iblockstate1);
                                continue;
                            }
                            if (i1 <= 0) continue;
                            --i1;
                            this.primer.func_177855_a(k, j1, j, iblockstate1);
                            continue;
                        }
                        i1 = -1;
                        continue;
                    }
                    this.primer.func_177855_a(k, j1, j, BlockRegister.dimensionalFabric.func_176223_P());
                }
            }
        }
    }

    public void func_185931_b(int chunkX, int chunkZ) {
        int y;
        int z;
        int x;
        this.rand.setSeed(this.world.func_72905_C());
        long a = this.rand.nextLong() / 2L * 2L + 1L;
        long b = this.rand.nextLong() / 2L * 2L + 1L;
        int baseX = chunkX * 16 + 1;
        int baseZ = chunkZ * 16 + 1;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        BlockPos basePos = new BlockPos(baseX, 0, baseZ);
        Biome biome = this.world.func_180494_b(basePos);
        this.rand.setSeed((long)chunkX * a + (long)chunkZ * b ^ this.world.func_72905_C());
        if (ConfigurationUtil.StructureConfig.crystevia.crystalBuildingSpawnChance > 0 && this.rand.nextInt(ConfigurationUtil.StructureConfig.crystevia.crystalBuildingSpawnChance) == 0) {
            x = baseX + this.rand.nextInt(16);
            z = baseZ + this.rand.nextInt(16);
            y = 20 + this.rand.nextInt(80);
            switch (this.rand.nextInt(4)) {
                case 0: {
                    if (this.world.func_180495_p((BlockPos)pos.func_181079_c(x + 5, y + 3, z + 5)).func_177230_c() != Blocks.field_150350_a) break;
                    StructuresHandler.generateStructure("CrystalExtensionStation", this.world, this.rand, (BlockPos)pos.func_181079_c(x, y, z));
                    break;
                }
                case 1: {
                    if (this.world.func_180495_p((BlockPos)pos.func_181079_c(x + 4, y + 3, z + 4)).func_177230_c() != Blocks.field_150350_a) break;
                    StructuresHandler.generateStructure("CrystalLottoOverlook", this.world, this.rand, (BlockPos)pos.func_181079_c(x, y, z));
                    break;
                }
                case 2: {
                    if (this.world.func_180495_p((BlockPos)pos.func_181079_c(x + 3, y + 3, z + 3)).func_177230_c() != Blocks.field_150350_a) break;
                    StructuresHandler.generateStructure("PowerStation", this.world, this.rand, (BlockPos)pos.func_181079_c(x, y, z));
                    break;
                }
                case 3: {
                    if (this.world.func_180495_p((BlockPos)pos.func_181079_c(x + 4, y + 1, z + 4)).func_177230_c() != Blocks.field_150350_a) break;
                    StructuresHandler.generateStructure("CrystalTradingPost", this.world, this.rand, (BlockPos)pos.func_181079_c(x, y, z));
                }
            }
        }
        if (ConfigurationUtil.StructureConfig.crystevia.crystalTransferHutSpawnChance > 0 && this.rand.nextInt(ConfigurationUtil.StructureConfig.crystevia.crystalTransferHutSpawnChance) == 0) {
            x = baseX + this.rand.nextInt(16);
            z = baseZ + this.rand.nextInt(16);
            y = 20 + this.rand.nextInt(80);
            if (this.world.func_180495_p((BlockPos)pos.func_181079_c(x + 5, y, z + 5)).func_177230_c() == Blocks.field_150350_a && this.world.func_180495_p((BlockPos)pos.func_181079_c(x + 5, y + 9, z + 5)).func_177230_c() == Blocks.field_150350_a) {
                AoAStructure structure = StructuresHandler.EMPTY_STRUCTURE;
                switch (this.rand.nextInt(6)) {
                    case 0: {
                        structure = StructuresHandler.getStructure("BlueCrystalTransferHut");
                        break;
                    }
                    case 1: {
                        structure = StructuresHandler.getStructure("GreenCrystalTransferHut");
                        break;
                    }
                    case 2: {
                        structure = StructuresHandler.getStructure("PurpleCrystalTransferHut");
                        break;
                    }
                    case 3: {
                        structure = StructuresHandler.getStructure("RedCrystalTransferHut");
                        break;
                    }
                    case 4: {
                        structure = StructuresHandler.getStructure("WhiteCrystalTransferHut");
                        break;
                    }
                    case 5: {
                        structure = StructuresHandler.getStructure("YellowCrystalTransferHut");
                    }
                }
                StructuresHandler.generateStructure(structure, this.world, this.rand, (BlockPos)pos.func_181079_c(x, y, z));
            }
        }
        this.rand.setSeed((long)chunkX * a + (long)chunkZ * b ^ this.world.func_72905_C());
        biome.func_180624_a(this.world, this.rand, basePos);
    }

    public boolean func_185933_a(Chunk chunkIn, int x, int z) {
        return false;
    }

    public List<Biome.SpawnListEntry> func_177458_a(EnumCreatureType creatureType, BlockPos pos) {
        return this.world.func_180494_b(pos).func_76747_a(creatureType);
    }

    @Nullable
    public BlockPos func_180513_a(World worldIn, String structureName, BlockPos position, boolean findUnexplored) {
        return null;
    }

    public void func_180514_a(Chunk chunkIn, int x, int z) {
    }

    public boolean func_193414_a(World worldIn, String structureName, BlockPos pos) {
        return false;
    }
}

