/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.dimension.crystevia.biomes;

import com.google.common.base.Predicate;
import java.awt.Color;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.common.registration.BlockRegister;
import net.tslat.aoa3.dimension.AoABiomeDecorator;
import net.tslat.aoa3.structure.StructuresHandler;
import net.tslat.aoa3.utils.ConfigurationUtil;

public class BiomeCrystevia
extends Biome {
    private static final Biome.BiomeProperties properties = new Biome.BiomeProperties("Crystevia");

    public BiomeCrystevia() {
        super(properties);
        this.setRegistryName("aoa3", "crystevia");
        this.field_76752_A = BlockRegister.getUnmappedBlock("crystevia_stone").func_176223_P();
        this.field_76753_B = BlockRegister.getUnmappedBlock("crystevia_stone").func_176223_P();
        this.field_82914_M.clear();
        this.field_76762_K.clear();
        this.field_76761_J.clear();
        this.field_76755_L.clear();
        this.field_76760_I = new BiomeCrysteviaDecorator();
    }

    public void biomeInit() {
        BiomeDictionary.addTypes((Biome)this, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.WET});
    }

    @SideOnly(value=Side.CLIENT)
    public int func_76731_a(float currentTemperature) {
        return Color.YELLOW.getRGB();
    }

    static {
        properties.func_185396_a();
        properties.func_185410_a(0.4f);
        properties.func_185395_b(100.0f);
        properties.func_185402_a(0xCC0066);
        properties.func_185396_a();
        properties.func_185398_c(0.1f);
        properties.func_185400_d(0.2f);
    }

    public class BiomeCrysteviaDecorator
    extends AoABiomeDecorator {
        @Override
        protected void doOreGen(World world, Biome biome, Random rand, BlockPos basePos, BlockPos.MutableBlockPos pos, int posX, int posY, int posZ) {
            int i;
            for (i = 0; i < ConfigurationUtil.OreConfig.blueCrystal.veinsPerChunk; ++i) {
                new WorldGenMinable(BlockRegister.oreBlueGemstone.func_176223_P(), Math.max(ConfigurationUtil.OreConfig.blueCrystal.minOresPerVein, rand.nextInt(ConfigurationUtil.OreConfig.blueCrystal.maxOresPerVein) + 1), (Predicate)BlockMatcher.func_177642_a((Block)BlockRegister.stoneCrystevia)).func_180709_b(world, rand, basePos.func_177982_a(rand.nextInt(16), rand.nextInt(100) + 10, rand.nextInt(16)));
            }
            for (i = 0; i < ConfigurationUtil.OreConfig.greenCrystal.veinsPerChunk; ++i) {
                new WorldGenMinable(BlockRegister.oreGreenGemstone.func_176223_P(), Math.max(ConfigurationUtil.OreConfig.greenCrystal.minOresPerVein, rand.nextInt(ConfigurationUtil.OreConfig.greenCrystal.maxOresPerVein) + 1), (Predicate)BlockMatcher.func_177642_a((Block)BlockRegister.stoneCrystevia)).func_180709_b(world, rand, basePos.func_177982_a(rand.nextInt(16), rand.nextInt(100) + 10, rand.nextInt(16)));
            }
            for (i = 0; i < ConfigurationUtil.OreConfig.redCrystal.veinsPerChunk; ++i) {
                new WorldGenMinable(BlockRegister.oreRedGemstone.func_176223_P(), Math.max(ConfigurationUtil.OreConfig.redCrystal.minOresPerVein, rand.nextInt(ConfigurationUtil.OreConfig.redCrystal.maxOresPerVein) + 1), (Predicate)BlockMatcher.func_177642_a((Block)BlockRegister.stoneCrystevia)).func_180709_b(world, rand, basePos.func_177982_a(rand.nextInt(16), rand.nextInt(100) + 10, rand.nextInt(16)));
            }
            for (i = 0; i < ConfigurationUtil.OreConfig.purpleCrystal.veinsPerChunk; ++i) {
                new WorldGenMinable(BlockRegister.orePurpleGemstone.func_176223_P(), Math.max(ConfigurationUtil.OreConfig.purpleCrystal.minOresPerVein, rand.nextInt(ConfigurationUtil.OreConfig.purpleCrystal.maxOresPerVein) + 1), (Predicate)BlockMatcher.func_177642_a((Block)BlockRegister.stoneCrystevia)).func_180709_b(world, rand, basePos.func_177982_a(rand.nextInt(16), rand.nextInt(100) + 10, rand.nextInt(16)));
            }
            for (i = 0; i < ConfigurationUtil.OreConfig.whiteCrystal.veinsPerChunk; ++i) {
                new WorldGenMinable(BlockRegister.oreWhiteGemstone.func_176223_P(), Math.max(ConfigurationUtil.OreConfig.whiteCrystal.minOresPerVein, rand.nextInt(ConfigurationUtil.OreConfig.whiteCrystal.maxOresPerVein) + 1), (Predicate)BlockMatcher.func_177642_a((Block)BlockRegister.stoneCrystevia)).func_180709_b(world, rand, basePos.func_177982_a(rand.nextInt(16), rand.nextInt(100) + 10, rand.nextInt(16)));
            }
            for (i = 0; i < ConfigurationUtil.OreConfig.yellowCrystal.veinsPerChunk; ++i) {
                new WorldGenMinable(BlockRegister.oreYellowGemstone.func_176223_P(), Math.max(ConfigurationUtil.OreConfig.yellowCrystal.minOresPerVein, rand.nextInt(ConfigurationUtil.OreConfig.yellowCrystal.maxOresPerVein) + 1), (Predicate)BlockMatcher.func_177642_a((Block)BlockRegister.stoneCrystevia)).func_180709_b(world, rand, basePos.func_177982_a(rand.nextInt(16), rand.nextInt(100) + 10, rand.nextInt(16)));
            }
        }

        @Override
        protected void doPlantGen(World world, Biome biome, Random rand, BlockPos basePos, BlockPos.MutableBlockPos pos, int posX, int posY, int posZ) {
            block8: for (int i = 0; i < 15; ++i) {
                posX = basePos.func_177958_n() + rand.nextInt(16);
                posZ = basePos.func_177952_p() + rand.nextInt(16);
                posY = this.findNextSuitableYCoord(world, posX, 20 + rand.nextInt(80), posZ);
                if (world.func_180495_p((BlockPos)pos.func_181079_c(posX, posY - 1, posZ)) != biome.field_76752_A || posY <= 0) continue;
                switch (rand.nextInt(6)) {
                    case 0: {
                        world.func_175656_a((BlockPos)pos.func_181079_c(posX, posY, posZ), BlockRegister.plantCrystalBlue.func_176223_P());
                        continue block8;
                    }
                    case 1: {
                        world.func_175656_a((BlockPos)pos.func_181079_c(posX, posY, posZ), BlockRegister.plantCrystalGreen.func_176223_P());
                        continue block8;
                    }
                    case 2: {
                        world.func_175656_a((BlockPos)pos.func_181079_c(posX, posY, posZ), BlockRegister.plantCrystalPurple.func_176223_P());
                        continue block8;
                    }
                    case 3: {
                        world.func_175656_a((BlockPos)pos.func_181079_c(posX, posY, posZ), BlockRegister.plantCrystalRed.func_176223_P());
                        continue block8;
                    }
                    case 4: {
                        world.func_175656_a((BlockPos)pos.func_181079_c(posX, posY, posZ), BlockRegister.plantCrystalWhite.func_176223_P());
                        continue block8;
                    }
                    case 5: {
                        world.func_175656_a((BlockPos)pos.func_181079_c(posX, posY, posZ), BlockRegister.plantCrystalYellow.func_176223_P());
                    }
                }
            }
        }

        @Override
        protected void doTreeGen(World world, Biome biome, Random rand, BlockPos basePos, BlockPos.MutableBlockPos pos, int posX, int posY, int posZ) {
            block15: for (int i = 0; i < rand.nextInt(6); ++i) {
                String colour;
                switch (rand.nextInt(6)) {
                    case 0: {
                        colour = "Blue";
                        break;
                    }
                    case 1: {
                        colour = "Green";
                        break;
                    }
                    case 2: {
                        colour = "Purple";
                        break;
                    }
                    case 3: {
                        colour = "Red";
                        break;
                    }
                    case 4: {
                        colour = "White";
                        break;
                    }
                    default: {
                        colour = "Yellow";
                    }
                }
                switch (rand.nextInt(6)) {
                    case 0: {
                        posX = basePos.func_177958_n() + rand.nextInt(16);
                        posZ = basePos.func_177952_p() + rand.nextInt(16);
                        posY = this.findNextSuitableYCoord(world, posX + 1, 20 + rand.nextInt(80), posZ + 1);
                        if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 1, posY - 1, posZ + 1)) != biome.field_76752_A) continue block15;
                        StructuresHandler.generateStructure(colour + "CrystalChunk1", world, rand, (BlockPos)pos.func_181079_c(posX, posY, posZ));
                        continue block15;
                    }
                    case 1: {
                        posX = basePos.func_177958_n() + rand.nextInt(16);
                        posZ = basePos.func_177952_p() + rand.nextInt(16);
                        posY = this.findNextSuitableYCoord(world, posX, 20 + rand.nextInt(80), posZ);
                        if (world.func_180495_p((BlockPos)pos.func_181079_c(posX, posY - 1, posZ)) != biome.field_76752_A) continue block15;
                        StructuresHandler.generateStructure(colour + "CrystalChunk2", world, rand, (BlockPos)pos.func_181079_c(posX, posY, posZ));
                        continue block15;
                    }
                    case 2: {
                        posX = basePos.func_177958_n() + rand.nextInt(16);
                        posZ = basePos.func_177952_p() + rand.nextInt(16);
                        posY = this.findNextSuitableYCoord(world, posX + 1, 20 + rand.nextInt(80), posZ + 1);
                        if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 1, posY - 1, posZ + 1)) != biome.field_76752_A) continue block15;
                        StructuresHandler.generateStructure(colour + "CrystalChunk3", world, rand, (BlockPos)pos.func_181079_c(posX, posY, posZ));
                        continue block15;
                    }
                    case 3: {
                        posX = basePos.func_177958_n() + rand.nextInt(16);
                        posZ = basePos.func_177952_p() + rand.nextInt(16);
                        posY = this.findNextSuitableYCoord(world, posX, 20 + rand.nextInt(80), posZ);
                        if (world.func_180495_p((BlockPos)pos.func_181079_c(posX, posY - 1, posZ)) != biome.field_76752_A) continue block15;
                        StructuresHandler.generateStructure(colour + "CrystalChunk4", world, rand, (BlockPos)pos.func_181079_c(posX, posY, posZ));
                        continue block15;
                    }
                    case 4: {
                        posX = basePos.func_177958_n() + rand.nextInt(16);
                        posZ = basePos.func_177952_p() + rand.nextInt(16);
                        posY = this.findNextSuitableYCoord(world, posX + 1, 20 + rand.nextInt(80), posZ + 1);
                        if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 1, posY - 1, posZ + 1)) != biome.field_76752_A) continue block15;
                        StructuresHandler.generateStructure(colour + "CrystalChunk5", world, rand, (BlockPos)pos.func_181079_c(posX, posY, posZ));
                        continue block15;
                    }
                    case 5: {
                        posX = basePos.func_177958_n() + rand.nextInt(16);
                        posZ = basePos.func_177952_p() + rand.nextInt(16);
                        posY = this.findNextSuitableYCoord(world, posX, 20 + rand.nextInt(80), posZ);
                        if (world.func_180495_p((BlockPos)pos.func_181079_c(posX, posY - 1, posZ)) != biome.field_76752_A) continue block15;
                        StructuresHandler.generateStructure(colour + "CrystalChunk6", world, rand, (BlockPos)pos.func_181079_c(posX, posY, posZ));
                    }
                }
            }
        }

        @Override
        protected void doMiscGen(World world, Biome biome, Random rand, BlockPos basePos, BlockPos.MutableBlockPos pos, int posX, int posY, int posZ) {
            if (rand.nextInt(10) == 0) {
                posX = basePos.func_177958_n() + rand.nextInt(16);
                posZ = basePos.func_177952_p() + rand.nextInt(16);
                posY = 110 + rand.nextInt(10);
                if (world.func_180495_p((BlockPos)pos.func_181079_c(posX, posY, posZ)) == biome.field_76752_A) {
                    world.func_175656_a((BlockPos)pos.func_181079_c(posX, posY, posZ), Blocks.field_150355_j.func_176223_P());
                    while (world.func_180495_p((BlockPos)pos.func_181079_c(posX, posY - 1, posZ)).func_177230_c() != Blocks.field_150350_a) {
                        world.func_175656_a((BlockPos)pos.func_181079_c(posX, posY - 1, posZ), Blocks.field_150350_a.func_176223_P());
                        --posY;
                    }
                }
            }
        }

        private int findNextSuitableYCoord(World world, int posX, int posY, int posZ) {
            BlockPos.MutableBlockPos testPos = new BlockPos.MutableBlockPos(posX, posY, posZ);
            if (world.func_180495_p((BlockPos)testPos).func_177230_c() == Blocks.field_150350_a) {
                while (testPos.func_177956_o() >= 0 && world.func_180495_p((BlockPos)testPos.func_189536_c(EnumFacing.DOWN)).func_177230_c() == Blocks.field_150350_a) {
                }
                if (world.func_180495_p((BlockPos)testPos).func_177230_c() == BlockRegister.stoneCrystevia) {
                    return testPos.func_177956_o() + 1;
                }
                return 0;
            }
            return 0;
        }
    }
}

