/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.dimension.deeplands.biomes;

import com.google.common.base.Predicate;
import java.awt.Color;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.common.registration.BlockRegister;
import net.tslat.aoa3.dimension.AoABiomeDecorator;
import net.tslat.aoa3.structure.StructuresHandler;
import net.tslat.aoa3.utils.ConfigurationUtil;

public class BiomeDeeplands
extends Biome {
    private static final Biome.BiomeProperties properties = new Biome.BiomeProperties("Deeplands");

    public BiomeDeeplands() {
        super(properties);
        this.setRegistryName("aoa3", "deeplands");
        this.field_76752_A = BlockRegister.getUnmappedBlock("deeplands_stone").func_176223_P();
        this.field_76753_B = BlockRegister.getUnmappedBlock("deeplands_stone").func_176223_P();
        this.field_82914_M.clear();
        this.field_76762_K.clear();
        this.field_76761_J.clear();
        this.field_76755_L.clear();
        this.field_76760_I = new BiomeDeeplandsDecorator();
    }

    public void biomeInit() {
        BiomeDictionary.addTypes((Biome)this, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.WASTELAND, BiomeDictionary.Type.SPOOKY, BiomeDictionary.Type.SPARSE});
    }

    @SideOnly(value=Side.CLIENT)
    public int func_76731_a(float currentTemperature) {
        return Color.GREEN.getRGB();
    }

    static {
        properties.func_185396_a();
        properties.func_185410_a(0.0f);
        properties.func_185395_b(500.0f);
        properties.func_185396_a();
        properties.func_185398_c(0.0f);
        properties.func_185400_d(0.05f);
    }

    public class BiomeDeeplandsDecorator
    extends AoABiomeDecorator {
        @Override
        protected void doOreGen(World world, Biome biome, Random rand, BlockPos basePos, BlockPos.MutableBlockPos pos, int posX, int posY, int posZ) {
            int i;
            for (i = 0; i < ConfigurationUtil.OreConfig.chargedRunium.veinsPerChunk; ++i) {
                new WorldGenMinable(BlockRegister.oreChargedRunium.func_176223_P(), Math.max(ConfigurationUtil.OreConfig.chargedRunium.minOresPerVein, rand.nextInt(ConfigurationUtil.OreConfig.chargedRunium.maxOresPerVein) + 1), (Predicate)BlockMatcher.func_177642_a((Block)BlockRegister.stoneDeeplands)).func_180709_b(world, rand, basePos.func_177982_a(rand.nextInt(16), rand.nextInt(45) + 70, rand.nextInt(16)));
            }
            for (i = 0; i < 4; ++i) {
                new WorldGenMinable(BlockRegister.deepCase.func_176223_P(), 5, (Predicate)BlockMatcher.func_177642_a((Block)BlockRegister.stoneDeeplands)).func_180709_b(world, rand, basePos.func_177982_a(rand.nextInt(16), rand.nextInt(45) + 70, rand.nextInt(16)));
            }
        }

        @Override
        protected void doPlantGen(World world, Biome biome, Random rand, BlockPos basePos, BlockPos.MutableBlockPos pos, int posX, int posY, int posZ) {
            for (int i = 0; i < 30; ++i) {
                posX = basePos.func_177958_n() + rand.nextInt(16);
                if (world.func_180495_p((BlockPos)pos.func_181079_c(posX, posY = 20, posZ = basePos.func_177952_p() + rand.nextInt(16))).func_177230_c() != Blocks.field_150350_a) continue;
                if (rand.nextBoolean()) {
                    world.func_175656_a((BlockPos)pos.func_181079_c(posX, posY, posZ), BlockRegister.plantDeepGrass.func_176223_P());
                    continue;
                }
                world.func_175656_a((BlockPos)pos.func_181079_c(posX, posY, posZ), BlockRegister.plantDeepBlooms.func_176223_P());
            }
        }

        @Override
        protected void doTreeGen(World world, Biome biome, Random rand, BlockPos basePos, BlockPos.MutableBlockPos pos, int posX, int posY, int posZ) {
            if (rand.nextInt(3) == 0) {
                posX = basePos.func_177958_n() + rand.nextInt(16);
                posZ = basePos.func_177952_p() + rand.nextInt(16);
                posY = 20;
                if (rand.nextBoolean()) {
                    if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 3, posY, posZ + 3)).func_177230_c() == Blocks.field_150350_a) {
                        StructuresHandler.generateStructure("Deepshroom1", world, rand, (BlockPos)pos.func_181079_c(posX, posY, posZ));
                    }
                } else if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 4, posY, posZ + 4)).func_177230_c() == Blocks.field_150350_a) {
                    StructuresHandler.generateStructure("Deepshroom2", world, rand, (BlockPos)pos.func_181079_c(posX, posY, posZ));
                }
            }
        }

        @Override
        protected void doMiscGen(World world, Biome biome, Random rand, BlockPos basePos, BlockPos.MutableBlockPos pos, int posX, int posY, int posZ) {
            posX = basePos.func_177958_n() + rand.nextInt(16);
            posZ = basePos.func_177952_p() + rand.nextInt(16);
            posY = 19;
            world.func_175656_a((BlockPos)pos.func_181079_c(posX, posY, posZ), BlockRegister.lightDeepCrystal.func_176223_P());
            block10: for (int i = 0; i < 25; ++i) {
                switch (rand.nextInt(3)) {
                    case 0: {
                        new WorldGenMinable(BlockRegister.deeplandsTrapExplosion.func_176223_P(), 20, (Predicate)BlockMatcher.func_177642_a((Block)BlockRegister.stoneDeeplands)).func_180709_b(world, rand, basePos.func_177982_a(rand.nextInt(16), rand.nextInt(45) + 70, rand.nextInt(16)));
                        continue block10;
                    }
                    case 1: {
                        new WorldGenMinable(BlockRegister.deeplandsTrapLava.func_176223_P(), 20, (Predicate)BlockMatcher.func_177642_a((Block)BlockRegister.stoneDeeplands)).func_180709_b(world, rand, basePos.func_177982_a(rand.nextInt(16), rand.nextInt(45) + 70, rand.nextInt(16)));
                        continue block10;
                    }
                    case 2: {
                        new WorldGenMinable(BlockRegister.deeplandsTrapNipper.func_176223_P(), 20, (Predicate)BlockMatcher.func_177642_a((Block)BlockRegister.stoneDeeplands)).func_180709_b(world, rand, basePos.func_177982_a(rand.nextInt(16), rand.nextInt(45) + 70, rand.nextInt(16)));
                    }
                }
            }
            if (rand.nextInt(25) == 0) {
                posX = basePos.func_177958_n() + rand.nextInt(16);
                posZ = basePos.func_177952_p() + rand.nextInt(16);
                posY = 20 - rand.nextInt(2);
                if (world.func_180495_p((BlockPos)pos.func_181079_c(posX, 20, posZ)).func_177230_c() == Blocks.field_150350_a) {
                    if (rand.nextBoolean()) {
                        StructuresHandler.generateStructure("DeepSpire1", world, rand, (BlockPos)pos.func_181079_c(posX, posY, posZ));
                    } else {
                        StructuresHandler.generateStructure("DeepSpire2", world, rand, (BlockPos)pos.func_181079_c(posX, posY, posZ));
                    }
                }
            }
            if (rand.nextInt(6) == 0) {
                posX = basePos.func_177958_n() + rand.nextInt(16);
                posZ = basePos.func_177952_p() + rand.nextInt(16);
                posY = 20;
                switch (rand.nextInt(3)) {
                    case 0: {
                        if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 6, posY, posZ + 6)).func_177230_c() != Blocks.field_150350_a) break;
                        StructuresHandler.generateStructure("FossilisedRibs1", world, rand, (BlockPos)pos.func_181079_c(posX, posY, posZ));
                        break;
                    }
                    case 1: {
                        if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 6, posY, posZ + 6)).func_177230_c() != Blocks.field_150350_a) break;
                        StructuresHandler.generateStructure("FossilisedRibs2", world, rand, (BlockPos)pos.func_181079_c(posX, posY, posZ));
                        break;
                    }
                    case 2: {
                        if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 7, posY, posZ + 7)).func_177230_c() != Blocks.field_150350_a) break;
                        StructuresHandler.generateStructure("BoneCircle", world, rand, (BlockPos)pos.func_181079_c(posX, posY, posZ));
                    }
                }
            }
        }
    }
}

