/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.dimension.dustopia.biomes;

import java.awt.Color;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.common.registration.BlockRegister;
import net.tslat.aoa3.dimension.AoABiomeDecorator;
import net.tslat.aoa3.structure.StructuresHandler;

public class BiomeDustopia
extends Biome {
    private static final Biome.BiomeProperties properties = new Biome.BiomeProperties("Dustopian Forest");

    public BiomeDustopia() {
        super(properties);
        this.setRegistryName("aoa3", "dustopia");
        this.field_76752_A = BlockRegister.getUnmappedBlock("dustopia_grass").func_176223_P();
        this.field_76753_B = BlockRegister.getUnmappedBlock("dustopia_dirt").func_176223_P();
        this.field_82914_M.clear();
        this.field_76762_K.clear();
        this.field_76761_J.clear();
        this.field_76755_L.clear();
        this.field_76760_I = new BiomeDustopiaDecorator();
    }

    public void biomeInit() {
        BiomeDictionary.addTypes((Biome)this, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.WASTELAND, BiomeDictionary.Type.SPOOKY, BiomeDictionary.Type.FOREST});
    }

    @SideOnly(value=Side.CLIENT)
    public int func_76731_a(float currentTemperature) {
        return Color.BLACK.getRGB();
    }

    static {
        properties.func_185396_a();
        properties.func_185410_a(0.25f);
        properties.func_185395_b(500.0f);
        properties.func_185402_a(Color.BLACK.getRGB());
        properties.func_185396_a();
        properties.func_185398_c(0.0f);
        properties.func_185400_d(0.25f);
    }

    public class BiomeDustopiaDecorator
    extends AoABiomeDecorator {
        @Override
        protected void doPlantGen(World world, Biome biome, Random rand, BlockPos basePos, BlockPos.MutableBlockPos pos, int posX, int posY, int posZ) {
            int i;
            for (i = 0; i < 8; ++i) {
                posX = basePos.func_177958_n() + rand.nextInt(16);
                if (world.func_180495_p((BlockPos)pos.func_181079_c(posX, (posY = world.func_189649_b(posX, posZ = basePos.func_177952_p() + rand.nextInt(16))) - 1, posZ)) != biome.field_76752_A) continue;
                if (rand.nextBoolean()) {
                    world.func_175656_a((BlockPos)pos.func_181079_c(posX, posY, posZ), BlockRegister.plantDawnBush.func_176223_P());
                    continue;
                }
                world.func_175656_a((BlockPos)pos.func_181079_c(posX, posY, posZ), BlockRegister.plantDawnFlower.func_176223_P());
            }
            for (i = 0; i < 25; ++i) {
                posX = basePos.func_177958_n() + rand.nextInt(16);
                if (world.func_180495_p((BlockPos)pos.func_181079_c(posX, (posY = world.func_189649_b(posX, posZ = basePos.func_177952_p() + rand.nextInt(16))) - 1, posZ)) != biome.field_76752_A) continue;
                world.func_175656_a((BlockPos)pos.func_181079_c(posX, posY, posZ), BlockRegister.plantDawnGrass.func_176223_P());
            }
        }

        @Override
        protected void doTreeGen(World world, Biome biome, Random rand, BlockPos basePos, BlockPos.MutableBlockPos pos, int posX, int posY, int posZ) {
            block5: for (int i = 0; i < 5; ++i) {
                switch (rand.nextInt(3)) {
                    case 0: {
                        posX = basePos.func_177958_n() + rand.nextInt(16);
                        posZ = basePos.func_177952_p() + rand.nextInt(16);
                        posY = world.func_189649_b(posX + 1, posZ + 1);
                        if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 1, posY - 1, posZ + 1)) != biome.field_76752_A) continue block5;
                        StructuresHandler.generateStructure("DawnTree1", world, rand, (BlockPos)pos.func_181079_c(posX, posY, posZ));
                        continue block5;
                    }
                    case 1: {
                        posX = basePos.func_177958_n() + rand.nextInt(16);
                        posZ = basePos.func_177952_p() + rand.nextInt(16);
                        posY = world.func_189649_b(posX + 1, posZ + 1);
                        if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 1, posY - 1, posZ + 1)) != biome.field_76752_A) continue block5;
                        StructuresHandler.generateStructure("DawnTree2", world, rand, (BlockPos)pos.func_181079_c(posX, posY, posZ));
                        continue block5;
                    }
                    case 2: {
                        posX = basePos.func_177958_n() + rand.nextInt(16);
                        posZ = basePos.func_177952_p() + rand.nextInt(16);
                        posY = world.func_189649_b(posX + 3, posZ + 3);
                        if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 3, posY - 1, posZ + 3)) != biome.field_76752_A) continue block5;
                        StructuresHandler.generateStructure("DawnTree3", world, rand, (BlockPos)pos.func_181079_c(posX, posY, posZ));
                    }
                }
            }
        }

        @Override
        protected void doMiscGen(World world, Biome biome, Random rand, BlockPos basePos, BlockPos.MutableBlockPos pos, int posX, int posY, int posZ) {
            if (rand.nextInt(5) == 0) {
                switch (rand.nextInt(3)) {
                    case 0: {
                        posX = basePos.func_177958_n() + rand.nextInt(16);
                        posZ = basePos.func_177952_p() + rand.nextInt(16);
                        posY = world.func_189649_b(posX + 2, posZ + 2);
                        if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 2, posY - 1, posZ + 2)) != biome.field_76752_A) break;
                        StructuresHandler.generateStructure("DawnCage1", world, rand, (BlockPos)pos.func_181079_c(posX, posY, posZ));
                        break;
                    }
                    case 1: {
                        posX = basePos.func_177958_n() + rand.nextInt(16);
                        posZ = basePos.func_177952_p() + rand.nextInt(16);
                        posY = world.func_189649_b(posX + 1, posZ + 5);
                        if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 1, posY - 1, posZ + 5)) != biome.field_76752_A) break;
                        StructuresHandler.generateStructure("DawnCage2", world, rand, (BlockPos)pos.func_181079_c(posX, posY, posZ));
                        break;
                    }
                    case 2: {
                        posX = basePos.func_177958_n() + rand.nextInt(16);
                        posZ = basePos.func_177952_p() + rand.nextInt(16);
                        posY = world.func_189649_b(posX + 5, posZ + 1);
                        if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 5, posY - 1, posZ + 1)) != biome.field_76752_A) break;
                        StructuresHandler.generateStructure("DawnCage3", world, rand, (BlockPos)pos.func_181079_c(posX, posY, posZ));
                    }
                }
            }
        }
    }
}

