/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.dimension.gardencia.biomes;

import java.awt.Color;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.common.registration.BlockRegister;
import net.tslat.aoa3.dimension.AoABiomeDecorator;
import net.tslat.aoa3.structure.AoAStructure;
import net.tslat.aoa3.structure.StructuresHandler;

public class BiomeGardencia
extends Biome {
    private static final Biome.BiomeProperties properties = new Biome.BiomeProperties("Gardencia");

    public BiomeGardencia() {
        super(properties);
        this.setRegistryName("aoa3", "gardencia");
        this.field_76752_A = BlockRegister.getUnmappedBlock("gardencia_grass").func_176223_P();
        this.field_76753_B = BlockRegister.getUnmappedBlock("gardencia_dirt").func_176223_P();
        this.field_82914_M.clear();
        this.field_76762_K.clear();
        this.field_76761_J.clear();
        this.field_76755_L.clear();
        this.field_76760_I = new BiomeGardenciaDecorator();
    }

    public void biomeInit() {
        BiomeDictionary.addTypes((Biome)this, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.WET, BiomeDictionary.Type.HILLS});
    }

    @SideOnly(value=Side.CLIENT)
    public int func_76731_a(float currentTemperature) {
        return Color.GREEN.getRGB();
    }

    static {
        properties.func_185410_a(0.5f);
        properties.func_185395_b(0.7f);
        properties.func_185402_a(0x19D119);
        properties.func_185398_c(0.0f);
        properties.func_185400_d(0.3f);
    }

    public class BiomeGardenciaDecorator
    extends AoABiomeDecorator {
        @Override
        protected void doPlantGen(World world, Biome biome, Random rand, BlockPos basePos, BlockPos.MutableBlockPos pos, int posX, int posY, int posZ) {
            block5: for (int i = 0; i < 59; ++i) {
                posX = basePos.func_177958_n() + rand.nextInt(16);
                posY = world.func_189649_b(posX, posZ = basePos.func_177952_p() + rand.nextInt(16));
                if (posY <= 67 || world.func_180495_p((BlockPos)pos.func_181079_c(posX, posY - 1, posZ)) != biome.field_76752_A || world.func_180495_p((BlockPos)pos.func_181079_c(posX, posY, posZ)).func_177230_c() != Blocks.field_150350_a) continue;
                switch (rand.nextInt(3)) {
                    case 0: {
                        world.func_175656_a((BlockPos)pos.func_181079_c(posX, posY, posZ), BlockRegister.plantDaileers.func_176223_P());
                        continue block5;
                    }
                    case 1: {
                        world.func_175656_a((BlockPos)pos.func_181079_c(posX, posY, posZ), BlockRegister.plantLylips.func_176223_P());
                        continue block5;
                    }
                    case 2: {
                        StructuresHandler.generateStructure("GardenGrass", world, rand, (BlockPos)pos.func_181079_c(posX, posY, posZ));
                    }
                }
            }
        }

        @Override
        protected void doTreeGen(World world, Biome biome, Random rand, BlockPos basePos, BlockPos.MutableBlockPos pos, int posX, int posY, int posZ) {
            for (int i = 0; i < 2; ++i) {
                if (rand.nextBoolean() || (posY = world.func_189649_b(posX = basePos.func_177958_n() + rand.nextInt(16), posZ = basePos.func_177952_p() + rand.nextInt(16))) <= 67) continue;
                AoAStructure structure = StructuresHandler.EMPTY_STRUCTURE;
                switch (rand.nextInt(10)) {
                    case 0: {
                        if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 4, posY - 1, posZ + 3)) != biome.field_76752_A) break;
                        structure = StructuresHandler.getStructure("RoseTree");
                        break;
                    }
                    case 1: {
                        if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 5, posY - 1, posZ)) != biome.field_76752_A) break;
                        structure = StructuresHandler.getStructure("BlueStarflower1");
                        break;
                    }
                    case 2: {
                        if (world.func_180495_p((BlockPos)pos.func_181079_c(posX, posY - 1, posZ + 5)) != biome.field_76752_A) break;
                        structure = StructuresHandler.getStructure("BlueStarflower2");
                        break;
                    }
                    case 3: {
                        if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 5, posY - 1, posZ)) != biome.field_76752_A) break;
                        structure = StructuresHandler.getStructure("RoseStarflower1");
                        break;
                    }
                    case 4: {
                        if (world.func_180495_p((BlockPos)pos.func_181079_c(posX, posY - 1, posZ + 5)) != biome.field_76752_A) break;
                        structure = StructuresHandler.getStructure("RoseStarflower2");
                        break;
                    }
                    case 5: {
                        if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 1, posY - 1, posZ + 5)) != biome.field_76752_A) break;
                        structure = StructuresHandler.getStructure("Sunflower1");
                        break;
                    }
                    case 6: {
                        if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 5, posY - 1, posZ + 1)) != biome.field_76752_A) break;
                        structure = StructuresHandler.getStructure("Sunflower2");
                        break;
                    }
                    case 7: {
                        if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 5, posY - 1, posZ + 1)) != biome.field_76752_A) break;
                        structure = StructuresHandler.getStructure("BlueTulip");
                        break;
                    }
                    case 8: {
                        if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 5, posY - 1, posZ + 1)) != biome.field_76752_A) break;
                        structure = StructuresHandler.getStructure("PurpleTulip");
                        break;
                    }
                    case 9: {
                        if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 5, posY - 1, posZ + 1)) != biome.field_76752_A) break;
                        structure = StructuresHandler.getStructure("MagentaTulip");
                    }
                }
                StructuresHandler.generateStructure(structure, world, rand, (BlockPos)pos.func_181079_c(posX, posY, posZ));
            }
        }
    }
}

