/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.dimension.immortallis;

import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.tslat.aoa3.block.functional.portal.PortalBlock;
import net.tslat.aoa3.capabilities.providers.AdventPlayerProvider;
import net.tslat.aoa3.common.registration.BlockRegister;
import net.tslat.aoa3.dimension.AoATeleporter;
import net.tslat.aoa3.library.misc.PortalCoordinatesContainer;
import net.tslat.aoa3.utils.ConfigurationUtil;
import net.tslat.aoa3.utils.player.PlayerDataManager;
import net.tslat.aoa3.utils.player.PlayerUtil;

public class ImmortallisTeleporter
extends AoATeleporter {
    private static final HashMap<Long, BlockPos> cachedPortalMap = new HashMap();

    public ImmortallisTeleporter(WorldServer world) {
        super(world);
    }

    @Override
    public HashMap<Long, BlockPos> getCachedPortalMap() {
        return cachedPortalMap;
    }

    @Override
    public BlockPos findExistingPortal(World world, Entity entity) {
        if (world.field_73011_w.getDimension() == ConfigurationUtil.MainConfig.dimensionIds.immortallis) {
            if (entity.hasCapability(AdventPlayerProvider.ADVENT_PLAYER, null)) {
                PlayerDataManager plData = PlayerUtil.getAdventPlayer((EntityPlayer)entity);
                PortalCoordinatesContainer portalLoc = new PortalCoordinatesContainer(world.field_73011_w.getDimension(), entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
                plData.setPortalReturnLocation(entity.field_70170_p.field_73011_w.getDimension(), portalLoc);
            }
            return new BlockPos(-5, 20, 3);
        }
        return super.findExistingPortal(world, entity);
    }

    @Override
    public BlockPos makePortal(World world, Entity entity, BlockPos pos) {
        return pos;
    }

    @Override
    public PortalBlock getPortalBlock() {
        return BlockRegister.portalImmortallis;
    }

    @Override
    public Block getBorderBlock() {
        return BlockRegister.archaicTiles;
    }
}

