/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.dimension.lunalus.biomes;

import java.awt.Color;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.common.registration.BlockRegister;
import net.tslat.aoa3.dimension.AoABiomeDecorator;
import net.tslat.aoa3.structure.StructuresHandler;

public class BiomeLunalus
extends Biome {
    private static final Biome.BiomeProperties properties = new Biome.BiomeProperties("Lunalus");

    public BiomeLunalus() {
        super(properties);
        this.setRegistryName("aoa3", "lunalus");
        this.field_76752_A = BlockRegister.getUnmappedBlock("lunasole_grass").func_176223_P();
        this.field_76753_B = BlockRegister.getUnmappedBlock("lunasole_dirt").func_176223_P();
        this.field_82914_M.clear();
        this.field_76762_K.clear();
        this.field_76761_J.clear();
        this.field_76755_L.clear();
        this.field_76760_I = new BiomeLunalusDecorator();
    }

    public void biomeInit() {
        BiomeDictionary.addTypes((Biome)this, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.VOID, BiomeDictionary.Type.SPARSE});
    }

    @SideOnly(value=Side.CLIENT)
    public int func_76731_a(float currentTemperature) {
        return Color.PINK.getRGB();
    }

    static {
        properties.func_185396_a();
        properties.func_185410_a(0.0f);
        properties.func_185395_b(0.0f);
        properties.func_185402_a(0x191919);
        properties.func_185396_a();
        properties.func_185398_c(0.1f);
        properties.func_185400_d(0.2f);
    }

    public class BiomeLunalusDecorator
    extends AoABiomeDecorator {
        @Override
        protected void doPlantGen(World world, Biome biome, Random rand, BlockPos basePos, BlockPos.MutableBlockPos pos, int posX, int posY, int posZ) {
            Block bl;
            int y;
            int z;
            int x;
            for (x = 0; x < 16; ++x) {
                for (z = 0; z < 16; ++z) {
                    for (y = 36; y <= 60; ++y) {
                        bl = world.func_180495_p((BlockPos)pos.func_181079_c(basePos.func_177958_n() + x, y - 1, basePos.func_177952_p() + z)).func_177230_c();
                        if (rand.nextInt(10) != 0 || bl != BlockRegister.grassLunasole && bl != BlockRegister.grassLunalyte || world.func_180495_p(pos.func_177984_a()).func_177230_c() != Blocks.field_150350_a) continue;
                        if (rand.nextBoolean()) {
                            world.func_175656_a(pos.func_177984_a(), BlockRegister.plantLuntar.func_176223_P());
                            continue;
                        }
                        world.func_175656_a(pos.func_177984_a(), BlockRegister.plantLunalip.func_176223_P());
                    }
                }
            }
            for (x = 0; x < 16; ++x) {
                for (z = 0; z < 16; ++z) {
                    for (y = 61; y <= 85; ++y) {
                        bl = world.func_180495_p((BlockPos)pos.func_181079_c(basePos.func_177958_n() + x, y - 1, basePos.func_177952_p() + z)).func_177230_c();
                        if (rand.nextInt(10) != 0 || bl != BlockRegister.grassLunasole && bl != BlockRegister.grassLunalyte || world.func_180495_p(pos.func_177984_a()).func_177230_c() != Blocks.field_150350_a) continue;
                        if (rand.nextBoolean()) {
                            world.func_175656_a(pos.func_177984_a(), BlockRegister.plantLuntar.func_176223_P());
                            continue;
                        }
                        world.func_175656_a(pos.func_177984_a(), BlockRegister.plantLunalip.func_176223_P());
                    }
                }
            }
        }

        @Override
        protected void doTreeGen(World world, Biome biome, Random rand, BlockPos basePos, BlockPos.MutableBlockPos pos, int posX, int posY, int posZ) {
            Block bl;
            int y;
            int z;
            int x;
            int count = 0;
            block12: for (x = 0; x < 16; ++x) {
                for (z = 0; z < 16; ++z) {
                    for (y = 36; y <= 60; ++y) {
                        if (rand.nextInt(25) != 0) continue;
                        switch (rand.nextInt(4)) {
                            case 0: {
                                bl = world.func_180495_p((BlockPos)pos.func_181079_c(basePos.func_177958_n() + x + 1, y - 1, basePos.func_177952_p() + z + 1)).func_177230_c();
                                if (bl != BlockRegister.grassLunalyte && bl != BlockRegister.grassLunasole) break;
                                StructuresHandler.generateStructure("LunossoTree1", world, rand, pos.func_177982_a(-1, 1, -1));
                                ++count;
                                break;
                            }
                            case 1: {
                                bl = world.func_180495_p((BlockPos)pos.func_181079_c(basePos.func_177958_n() + x + 2, y - 1, basePos.func_177952_p() + z + 2)).func_177230_c();
                                if (bl != BlockRegister.grassLunalyte && bl != BlockRegister.grassLunasole) break;
                                StructuresHandler.generateStructure("LunossoTree2", world, rand, pos.func_177982_a(-2, 1, -2));
                                ++count;
                                break;
                            }
                            case 2: {
                                bl = world.func_180495_p((BlockPos)pos.func_181079_c(basePos.func_177958_n() + x + 2, y - 1, basePos.func_177952_p() + z + 2)).func_177230_c();
                                if (bl != BlockRegister.grassLunalyte && bl != BlockRegister.grassLunasole) break;
                                StructuresHandler.generateStructure("LuniciaTree1", world, rand, pos.func_177982_a(-2, 1, -2));
                                ++count;
                                break;
                            }
                            case 3: {
                                bl = world.func_180495_p((BlockPos)pos.func_181079_c(basePos.func_177958_n() + x + 2, y - 1, basePos.func_177952_p() + z + 2)).func_177230_c();
                                if (bl != BlockRegister.grassLunalyte && bl != BlockRegister.grassLunasole) break;
                                StructuresHandler.generateStructure("LuniciaTree2", world, rand, pos.func_177982_a(-2, 1, -2));
                                ++count;
                            }
                        }
                        if (count == 2) break block12;
                    }
                }
            }
            count = 0;
            block15: for (x = 0; x < 16; ++x) {
                for (z = 0; z < 16; ++z) {
                    for (y = 61; y <= 85; ++y) {
                        if (rand.nextInt(25) != 0) continue;
                        switch (rand.nextInt(4)) {
                            case 0: {
                                bl = world.func_180495_p((BlockPos)pos.func_181079_c(basePos.func_177958_n() + x + 1, y - 1, basePos.func_177952_p() + z + 1)).func_177230_c();
                                if (bl != BlockRegister.grassLunalyte && bl != BlockRegister.grassLunasole) break;
                                StructuresHandler.generateStructure("LunossoTree1", world, rand, pos.func_177982_a(-1, 1, -1));
                                ++count;
                                break;
                            }
                            case 1: {
                                bl = world.func_180495_p((BlockPos)pos.func_181079_c(basePos.func_177958_n() + x + 2, y - 1, basePos.func_177952_p() + z + 2)).func_177230_c();
                                if (bl != BlockRegister.grassLunalyte && bl != BlockRegister.grassLunasole) break;
                                StructuresHandler.generateStructure("LunossoTree2", world, rand, pos.func_177982_a(-2, 1, -2));
                                ++count;
                                break;
                            }
                            case 2: {
                                bl = world.func_180495_p((BlockPos)pos.func_181079_c(basePos.func_177958_n() + x + 2, y - 1, basePos.func_177952_p() + z + 2)).func_177230_c();
                                if (bl != BlockRegister.grassLunalyte && bl != BlockRegister.grassLunasole) break;
                                StructuresHandler.generateStructure("LuniciaTree1", world, rand, pos.func_177982_a(-2, 1, -2));
                                ++count;
                                break;
                            }
                            case 3: {
                                bl = world.func_180495_p((BlockPos)pos.func_181079_c(basePos.func_177958_n() + x + 2, y - 1, basePos.func_177952_p() + z + 2)).func_177230_c();
                                if (bl != BlockRegister.grassLunalyte && bl != BlockRegister.grassLunasole) break;
                                StructuresHandler.generateStructure("LuniciaTree2", world, rand, pos.func_177982_a(-2, 1, -2));
                                ++count;
                            }
                        }
                        if (count == 2) break block15;
                    }
                }
            }
        }
    }
}

