/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.dimension.voxponds;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.IChunkGenerator;
import net.tslat.aoa3.common.registration.BiomeRegister;
import net.tslat.aoa3.common.registration.BlockRegister;
import net.tslat.aoa3.structure.AoAStructure;
import net.tslat.aoa3.structure.StructuresHandler;
import net.tslat.aoa3.utils.ConfigurationUtil;

public class ChunkGenVoxPonds
implements IChunkGenerator {
    private final World world;
    private final Random rand;
    private ChunkPrimer primer;
    private final Biome biome = BiomeRegister.biomeVoxPonds;
    private int x;
    private int y;
    private int z;

    protected ChunkGenVoxPonds(World world) {
        this.world = world;
        this.rand = new Random(world.func_72905_C());
        this.world.func_181544_b(0);
    }

    public Chunk func_185932_a(int chunkX, int chunkZ) {
        this.rand.setSeed((long)chunkX * 341873128712L + (long)chunkZ * 132897987541L);
        this.primer = new ChunkPrimer();
        this.setBlocksInChunk();
        Chunk chunk = new Chunk(this.world, this.primer, chunkX, chunkZ);
        byte[] biomeArray = chunk.func_76605_m();
        for (int i = 0; i < biomeArray.length; ++i) {
            biomeArray[i] = (byte)Biome.func_185362_a((Biome)this.biome);
        }
        chunk.func_76603_b();
        return chunk;
    }

    private void setBlocksInChunk() {
        IBlockState toxicStone = BlockRegister.stoneToxic.func_176223_P();
        IBlockState toxicWaste = BlockRegister.toxicWaste.func_176223_P();
        this.setAllBlocksBetweenYCoords(0, 15, toxicStone);
        this.setAllBlocksBetweenYCoords(16, 17, Blocks.field_150355_j.func_176223_P());
        this.setAllBlocksBetweenYCoords(32, 35, toxicStone);
        if (this.rand.nextBoolean()) {
            this.setAllBlocksBetweenYCoords(36, 36, toxicStone);
            this.setAllBlocksBetweenYCoords(37, 37, toxicWaste);
            this.x = 0;
            while (this.x <= 15) {
                this.z = 0;
                while (this.z <= 15) {
                    if (this.rand.nextBoolean()) {
                        this.primer.func_177855_a(this.x, 36, this.z, toxicWaste);
                    }
                    ++this.z;
                }
                ++this.x;
            }
        } else {
            this.setAllBlocksBetweenYCoords(36, 37, BlockRegister.dirtToxic.func_176223_P());
            this.setAllBlocksBetweenYCoords(38, 38, BlockRegister.grassToxic.func_176223_P());
            this.x = 0;
            while (this.x <= 15) {
                this.z = 0;
                while (this.z <= 15) {
                    if (this.rand.nextBoolean()) {
                        this.primer.func_177855_a(this.x, 36, this.z, toxicStone);
                    }
                    ++this.z;
                }
                ++this.x;
            }
        }
        this.x = 0;
        while (this.x <= 15) {
            this.y = 0;
            while (this.y <= 2) {
                this.z = 0;
                while (this.z <= 15) {
                    this.primer.func_177855_a(this.x, this.y, this.z, BlockRegister.dimensionalFabric.func_176223_P());
                    ++this.z;
                }
                ++this.y;
            }
            ++this.x;
        }
    }

    private void setAllBlocksBetweenYCoords(int lowerY, int upperY, IBlockState block) {
        this.setAllBlocksInRegion(0, lowerY, 0, 15, upperY, 15, block);
    }

    private void setAllBlocksInRegion(int lowerX, int lowerY, int lowerZ, int upperX, int upperY, int upperZ, IBlockState block) {
        this.x = lowerX;
        while (this.x <= upperX) {
            this.y = lowerY;
            while (this.y <= upperY) {
                this.z = lowerZ;
                while (this.z <= upperZ) {
                    this.primer.func_177855_a(this.x, this.y, this.z, block);
                    ++this.z;
                }
                ++this.y;
            }
            ++this.x;
        }
    }

    public void func_185931_b(int chunkX, int chunkZ) {
        int y;
        int z;
        int x;
        this.rand.setSeed(this.world.func_72905_C());
        long a = this.rand.nextLong() / 2L * 2L + 1L;
        long b = this.rand.nextLong() / 2L * 2L + 1L;
        int baseX = chunkX * 16 + 1;
        int baseZ = chunkZ * 16 + 1;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        BlockPos basePos = new BlockPos(baseX, 0, baseZ);
        Biome biome = this.world.func_180494_b(basePos);
        this.rand.setSeed((long)chunkX * a + (long)chunkZ * b ^ this.world.func_72905_C());
        if (this.rand.nextInt(6) == 0) {
            x = baseX + this.rand.nextInt(16);
            z = baseZ + this.rand.nextInt(16);
            if (this.rand.nextBoolean()) {
                StructuresHandler.generateStructure("HangingDegradedLampPost", this.world, this.rand, (BlockPos)pos.func_181079_c(x, 27, z));
            } else {
                StructuresHandler.generateStructure("DegradedLampPost", this.world, this.rand, (BlockPos)pos.func_181079_c(x, 16, z));
            }
        }
        if (ConfigurationUtil.StructureConfig.voxPonds.enigmaStationSpawnChance > 0 && this.rand.nextInt(ConfigurationUtil.StructureConfig.voxPonds.enigmaStationSpawnChance) == 0) {
            x = baseX + this.rand.nextInt(16);
            if (this.world.func_180495_p((BlockPos)pos.func_181079_c(x + 6, y = 18, (z = baseZ + this.rand.nextInt(16)) + 6)).func_177230_c() == Blocks.field_150350_a) {
                StructuresHandler.generateStructure("EnigmaStation", this.world, this.rand, (BlockPos)pos.func_181079_c(x, y, z));
            }
        } else if (ConfigurationUtil.StructureConfig.voxPonds.controlTowerSpawnChance > 0 && this.rand.nextInt(ConfigurationUtil.StructureConfig.voxPonds.controlTowerSpawnChance) == 0) {
            x = baseX + this.rand.nextInt(16);
            if (this.world.func_180495_p((BlockPos)pos.func_181079_c(x + 6, (y = 39) - 1, (z = baseZ + this.rand.nextInt(16)) + 6)) == biome.field_76752_A && this.world.func_180495_p(pos.func_177984_a()).func_177230_c() == Blocks.field_150350_a) {
                StructuresHandler.generateStructure("ControlTower", this.world, this.rand, (BlockPos)pos.func_181079_c(x, y, z));
            }
        } else if (ConfigurationUtil.StructureConfig.voxPonds.cellTowerSpawnChance > 0 && this.rand.nextInt(ConfigurationUtil.StructureConfig.voxPonds.cellTowerSpawnChance) == 0) {
            x = baseX + this.rand.nextInt(16);
            if (this.world.func_180495_p((BlockPos)pos.func_181079_c(x + 5, (y = 39) - 1, (z = baseZ + this.rand.nextInt(16)) + 5)) == biome.field_76752_A && this.world.func_180495_p(pos.func_177984_a()).func_177230_c() == Blocks.field_150350_a) {
                StructuresHandler.generateStructure("CellTower", this.world, this.rand, (BlockPos)pos.func_181079_c(x, y, z));
            }
        } else if (ConfigurationUtil.StructureConfig.voxPonds.observationTowerSpawnChance > 0 && this.rand.nextInt(ConfigurationUtil.StructureConfig.voxPonds.observationTowerSpawnChance) == 0) {
            x = baseX + this.rand.nextInt(14);
            if (this.world.func_180495_p((BlockPos)pos.func_181079_c(x + 8, (y = 39) - 1, (z = baseZ + this.rand.nextInt(10)) + 11)) == biome.field_76752_A && this.world.func_180495_p(pos.func_177984_a()).func_177230_c() == Blocks.field_150350_a) {
                StructuresHandler.generateStructure("ObservationTower", this.world, this.rand, (BlockPos)pos.func_181079_c(x, y, z));
            }
        } else if (ConfigurationUtil.StructureConfig.voxPonds.voxBuildingSpawnChance > 0 && this.rand.nextInt(ConfigurationUtil.StructureConfig.voxPonds.voxBuildingSpawnChance) == 0) {
            x = baseX;
            y = 39;
            z = baseZ;
            if (this.world.func_180495_p((BlockPos)pos.func_181079_c(x + 8, y - 1, z + 8)) == biome.field_76752_A) {
                AoAStructure structure = StructuresHandler.EMPTY_STRUCTURE;
                switch (this.rand.nextInt(4)) {
                    case 0: {
                        structure = StructuresHandler.getStructure("DestroyedStore1");
                        break;
                    }
                    case 1: {
                        structure = StructuresHandler.getStructure("DestroyedStore2");
                        break;
                    }
                    case 2: {
                        structure = StructuresHandler.getStructure("ExoidPlatform");
                        break;
                    }
                    case 3: {
                        structure = StructuresHandler.getStructure("VoxxulonBeacon");
                    }
                }
                StructuresHandler.generateStructure(structure, this.world, this.rand, (BlockPos)pos.func_181079_c(x, y, z));
            }
        } else if (ConfigurationUtil.StructureConfig.voxPonds.nightwingIslandSpawnChance > 0 && this.rand.nextInt(ConfigurationUtil.StructureConfig.voxPonds.nightwingIslandSpawnChance) == 0) {
            x = baseX + this.rand.nextInt(16);
            if (this.world.func_180495_p((BlockPos)pos.func_181079_c(x + 2, y = 18, (z = baseZ + this.rand.nextInt(16)) + 2)).func_177230_c() == Blocks.field_150350_a) {
                StructuresHandler.generateStructure("NightwingIsland", this.world, this.rand, (BlockPos)pos.func_181079_c(x, y, z));
            }
        } else if (ConfigurationUtil.StructureConfig.voxPonds.voxLottoOutpostSpawnChance > 0 && this.rand.nextInt(ConfigurationUtil.StructureConfig.voxPonds.voxLottoOutpostSpawnChance) == 0 && this.world.func_180495_p((BlockPos)pos.func_181079_c((x = baseX + this.rand.nextInt(16)) + 6, (y = 39) - 1, (z = baseZ + this.rand.nextInt(16)) + 6)) == biome.field_76752_A && this.world.func_180495_p(pos.func_177984_a()).func_177230_c() == Blocks.field_150350_a) {
            StructuresHandler.generateStructure("VoxLottoOutpost", this.world, this.rand, (BlockPos)pos.func_181079_c(x, y, z));
        }
        if (ConfigurationUtil.StructureConfig.voxPonds.poisonRuneShrineSpawnChance > 0 && this.rand.nextInt(ConfigurationUtil.StructureConfig.voxPonds.poisonRuneShrineSpawnChance) == 0 && this.world.func_180495_p((BlockPos)pos.func_181079_c((x = baseX + this.rand.nextInt(16)) + 3, y = 47, (z = baseZ + this.rand.nextInt(16)) + 3)).func_177230_c() == Blocks.field_150350_a) {
            StructuresHandler.generateStructure("PoisonRuneShrine", this.world, this.rand, (BlockPos)pos.func_181079_c(x, y, z));
        }
        this.rand.setSeed((long)chunkX * a + (long)chunkZ * b ^ this.world.func_72905_C());
        biome.func_180624_a(this.world, this.rand, basePos);
    }

    public boolean func_185933_a(Chunk chunkIn, int x, int z) {
        return false;
    }

    public List<Biome.SpawnListEntry> func_177458_a(EnumCreatureType creatureType, BlockPos pos) {
        return this.world.func_180494_b(pos).func_76747_a(creatureType);
    }

    @Nullable
    public BlockPos func_180513_a(World worldIn, String structureName, BlockPos position, boolean findUnexplored) {
        return null;
    }

    public void func_180514_a(Chunk chunkIn, int x, int z) {
    }

    public boolean func_193414_a(World worldIn, String structureName, BlockPos pos) {
        return false;
    }
}

