/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.base;

import java.util.Collection;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.INpc;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIMoveIndoors;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAIRestrictOpenDoor;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest2;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.entity.base.AoAMeleeMob;
import net.tslat.aoa3.entity.base.AoATraderRecipe;
import net.tslat.aoa3.entity.base.ai.npc.EntityAIFaceCustomer;
import net.tslat.aoa3.entity.base.ai.npc.EntityAITradeWithPlayer;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.StringUtil;
import net.tslat.aoa3.utils.WorldUtil;

public abstract class AoATrader
extends EntityCreature
implements INpc,
IMerchant {
    private static final DataParameter<String> TRADE_STATUSES = EntityDataManager.func_187226_a(AoATrader.class, (DataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<Integer> ADDITIONAL_TRADES = EntityDataManager.func_187226_a(AoATrader.class, (DataSerializer)DataSerializers.field_187192_b);
    private MerchantRecipeList trades;
    private int maxTradesCount = 0;
    private String currentTradesInfo = "";
    private int additionalTrades = 0;
    private EntityPlayer latestCustomer;

    public AoATrader(World world, float entityWidth, float entityHeight) {
        super(world);
        this.func_70105_a(entityWidth, entityHeight);
        ((PathNavigateGround)this.func_70661_as()).func_179688_b(true);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, AoAMeleeMob.class, 8.0f, (double)0.8f, 1.0));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAITradeWithPlayer(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIFaceCustomer(this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMoveIndoors((EntityCreature)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIRestrictOpenDoor((EntityCreature)this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)this, true));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWatchClosest2((EntityLiving)this, EntityPlayer.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 0.6));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(TRADE_STATUSES, (Object)"");
        this.field_70180_af.func_187214_a(ADDITIONAL_TRADES, (Object)0);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(this.getBaseMaxHealth());
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(this.getBaseMovementSpeed());
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(16.0);
    }

    public int func_70641_bl() {
        return 1;
    }

    protected abstract double getBaseMaxHealth();

    protected abstract double getBaseMovementSpeed();

    protected boolean isFixedTradesList() {
        return false;
    }

    public void func_70932_a_(@Nullable EntityPlayer player) {
        this.latestCustomer = player;
    }

    @Nullable
    public EntityPlayer func_70931_l_() {
        return this.latestCustomer;
    }

    public boolean isTrading() {
        return this.latestCustomer != null;
    }

    public boolean isCreatureType(EnumCreatureType type, boolean forSpawnCount) {
        return type == EnumCreatureType.AMBIENT;
    }

    public boolean func_70601_bi() {
        if (this.field_70170_p.func_175624_G() == WorldType.field_77138_c) {
            return false;
        }
        return this.checkSpawnChance() && this.checkWorldSpawnConditions() && this.isValidLightLevel() && this.canSpawnOnBlock(this.field_70170_p.func_180495_p(this.func_180425_c().func_177977_b()));
    }

    protected boolean canSpawnOnBlock(IBlockState block) {
        return block.func_189884_a((Entity)this) && WorldUtil.isNaturalDimensionBlock(this.field_70170_p, this.func_180425_c(), block);
    }

    protected boolean checkWorldSpawnConditions() {
        if (this.isOverworldNPC() && this.field_70170_p.field_73011_w.getDimension() != 0) {
            EntityRegistry.removeSpawn(((Object)((Object)this)).getClass(), (EnumCreatureType)EnumCreatureType.AMBIENT, (Biome[])new Biome[]{this.field_70170_p.func_180494_b(this.func_180425_c())});
            return false;
        }
        return true;
    }

    protected boolean func_70692_ba() {
        return this.isOverworldNPC() ? this.field_70170_p.field_73011_w.getDimension() != 0 : super.func_70692_ba();
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74778_a("TradeStatuses", this.currentTradesInfo);
        compound.func_74768_a("AdditionalTrades", this.additionalTrades);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.currentTradesInfo = compound.func_74764_b("TradeStatuses") ? compound.func_74779_i("TradeStatuses") : "";
        int n = this.additionalTrades = compound.func_74764_b("AdditionalTrades") ? compound.func_74762_e("AdditionalTrades") : 0;
        if (!this.field_70170_p.field_72995_K) {
            this.field_70180_af.func_187227_b(TRADE_STATUSES, (Object)this.currentTradesInfo);
            this.field_70180_af.func_187227_b(ADDITIONAL_TRADES, (Object)this.additionalTrades);
            this.deserializeTradeStatuses(this.currentTradesInfo);
        }
    }

    public void func_70071_h_() {
        String currentInfo;
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K && !(currentInfo = (String)this.field_70180_af.func_187225_a(TRADE_STATUSES)).equals(this.currentTradesInfo)) {
            this.currentTradesInfo = currentInfo;
            int extraTrades = (Integer)this.field_70180_af.func_187225_a(ADDITIONAL_TRADES);
            if (extraTrades != this.additionalTrades) {
                this.additionalTrades = extraTrades;
                this.generateTrades();
            }
            this.deserializeTradeStatuses(currentInfo);
        }
    }

    protected boolean isOverworldNPC() {
        return false;
    }

    protected int getSpawnChanceFactor() {
        return 10;
    }

    private boolean checkSpawnChance() {
        return this.getSpawnChanceFactor() <= 1 || this.field_70146_Z.nextInt(this.getSpawnChanceFactor()) == 0;
    }

    protected boolean isValidLightLevel() {
        if (this.field_70170_p.field_73011_w.getDimension() != 0) {
            return true;
        }
        BlockPos blockpos = new BlockPos(this.field_70165_t, this.func_174813_aQ().field_72338_b, this.field_70161_v);
        if (this.field_70170_p.func_175642_b(EnumSkyBlock.SKY, blockpos) > this.field_70146_Z.nextInt(32)) {
            return true;
        }
        int i = this.field_70170_p.func_175671_l(blockpos);
        if (this.field_70170_p.func_72911_I()) {
            int j = this.field_70170_p.func_175657_ab();
            this.field_70170_p.func_175692_b(10);
            i = this.field_70170_p.func_175671_l(blockpos);
            this.field_70170_p.func_175692_b(j);
        }
        return i > this.field_70146_Z.nextInt(8);
    }

    protected abstract Enums.ModGuis getTraderGui();

    protected boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack heldStack = player.func_184586_b(hand);
        if (heldStack.func_77973_b() == Items.field_151057_cb) {
            heldStack.func_111282_a(player, (EntityLivingBase)this, hand);
            return true;
        }
        if (this.func_70089_S() && !player.func_70093_af()) {
            if (!this.field_70170_p.field_72995_K) {
                this.func_70934_b(player);
                this.func_70932_a_(player);
                player.openGui((Object)AdventOfAscension.instance(), this.getTraderGui().guiId, this.field_70170_p, this.func_145782_y(), 0, 0);
            }
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    @Nullable
    public MerchantRecipeList func_70934_b(EntityPlayer player) {
        if (this.trades == null) {
            this.generateTrades();
        }
        return this.trades;
    }

    private void generateTrades() {
        Random rand = new Random(1L + this.func_110124_au().getMostSignificantBits() + this.func_110124_au().getLeastSignificantBits());
        NonNullList allTrades = NonNullList.func_191196_a();
        this.trades = new MerchantRecipeList();
        this.getTradesList((NonNullList<AoATraderRecipe>)allTrades);
        this.maxTradesCount = allTrades.size();
        if (!this.isFixedTradesList()) {
            int newTradesSize = Math.max(rand.nextInt(allTrades.size()), 1);
            if (this.additionalTrades > 0 && newTradesSize < allTrades.size()) {
                newTradesSize = Math.min(newTradesSize + this.additionalTrades, allTrades.size());
            }
            for (int i = 0; i < newTradesSize; ++i) {
                int pick = rand.nextInt(allTrades.size());
                this.trades.add(allTrades.get(pick));
                allTrades.remove(pick);
            }
        } else {
            this.trades.addAll((Collection)allTrades);
        }
    }

    protected abstract void getTradesList(NonNullList<AoATraderRecipe> var1);

    @SideOnly(value=Side.CLIENT)
    public void func_70930_a(@Nullable MerchantRecipeList recipeList) {
    }

    protected void func_184610_a(boolean wasRecentlyHit, int lootingModifier, DamageSource source) {
        if (this.func_184647_J() != null) {
            LootTable lootTable = this.field_70170_p.func_184146_ak().func_186521_a(this.func_184647_J());
            LootContext.Builder lootBuilder = new LootContext.Builder((WorldServer)this.field_70170_p).func_186472_a((Entity)this).func_186473_a(source);
            if (wasRecentlyHit && this.field_70717_bb != null) {
                lootBuilder.func_186470_a(this.field_70717_bb).func_186469_a(this.field_70717_bb.func_184817_da() + (float)lootingModifier);
            }
            for (ItemStack stack : lootTable.func_186462_a(this.field_70146_Z, lootBuilder.func_186471_a())) {
                this.func_70099_a(stack, 0.0f);
            }
            this.func_82160_b(wasRecentlyHit, lootingModifier);
        } else {
            super.func_184610_a(wasRecentlyHit, lootingModifier, source);
        }
    }

    public void func_70933_a(MerchantRecipe recipe) {
        if (this.isFixedTradesList() || this.trades.size() >= this.maxTradesCount) {
            return;
        }
        recipe.func_77399_f();
        if (!this.field_70170_p.field_72995_K) {
            if (recipe.func_180321_e() >= recipe.func_180320_f()) {
                boolean tradesComplete = true;
                for (MerchantRecipe trade : this.trades) {
                    if (trade.func_82784_g()) continue;
                    tradesComplete = false;
                    break;
                }
                if (tradesComplete) {
                    this.addNewTrade();
                }
            }
            this.currentTradesInfo = this.serializeTradeStatuses();
            this.field_70180_af.func_187227_b(TRADE_STATUSES, (Object)this.currentTradesInfo);
            this.field_70180_af.func_187227_b(ADDITIONAL_TRADES, (Object)this.additionalTrades);
        }
    }

    public void func_110297_a_(ItemStack stack) {
    }

    public World func_190670_t_() {
        return this.field_70170_p;
    }

    public BlockPos func_190671_u_() {
        return new BlockPos((Entity)this);
    }

    private void addNewTrade() {
        ++this.additionalTrades;
        this.generateTrades();
    }

    private String serializeTradeStatuses() {
        if (this.trades == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (MerchantRecipe trade : this.trades) {
            builder.append("|");
            builder.append(trade.func_180321_e());
        }
        return builder.toString().substring(1);
    }

    private void deserializeTradeStatuses(String string) {
        if (!this.currentTradesInfo.equals(string)) {
            this.currentTradesInfo = string;
        }
        if (this.trades == null) {
            this.generateTrades();
        }
        int tradeIndex = 0;
        if (!this.trades.isEmpty() && !this.currentTradesInfo.isEmpty()) {
            for (String s : this.currentTradesInfo.split("\\|")) {
                MerchantRecipe trade = (MerchantRecipe)this.trades.get(tradeIndex);
                for (int i = 0; i < StringUtil.toInteger(s) - trade.func_180321_e(); ++i) {
                    trade.func_77399_f();
                }
                ++tradeIndex;
            }
        }
    }
}

