/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.boss.clunkhead;

import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.LootSystemRegister;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.entity.base.AoARangedMob;
import net.tslat.aoa3.entity.projectiles.mob.BaseMobProjectile;
import net.tslat.aoa3.entity.projectiles.mob.EntityCyanShot;
import net.tslat.aoa3.entity.properties.BossEntity;
import net.tslat.aoa3.entity.properties.SpecialPropertyEntity;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.EntityUtil;
import net.tslat.aoa3.utils.StringUtil;

public class EntityClunkhead
extends AoARangedMob
implements SpecialPropertyEntity,
BossEntity {
    private static final ResourceLocation bossBarTexture = new ResourceLocation("aoa3", "textures/gui/bossbars/clunkhead.png");
    public static final float entityWidth = 1.0f;
    private int stasisCountdown = 500;

    public EntityClunkhead(World world) {
        super(world, 1.0f, 2.0625f);
        this.mobProperties.add(Enums.MobProperties.RANGED_IMMUNE);
    }

    public float func_70047_e() {
        return 1.8125f;
    }

    @Override
    protected double getBaseKnockbackResistance() {
        return 1.0;
    }

    @Override
    protected double getBaseMaxHealth() {
        return 2200.0;
    }

    @Override
    public double getBaseProjectileDamage() {
        return 1 + this.field_70146_Z.nextInt(35);
    }

    @Override
    protected double getBaseMovementSpeed() {
        return 0.207;
    }

    @Override
    @Nullable
    protected SoundEvent func_184615_bR() {
        return SoundsRegister.mobClunkheadDeath;
    }

    @Override
    @Nullable
    protected SoundEvent getShootSound() {
        return SoundsRegister.shotClunkheadFire;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootSystemRegister.entityClunkhead;
    }

    public boolean func_184222_aU() {
        return false;
    }

    @Override
    protected BaseMobProjectile getNewProjectileInstance() {
        return new EntityCyanShot(this, Enums.MobProjectileType.MAGIC);
    }

    @Override
    @Nonnull
    public TreeSet<Enums.MobProperties> getMobProperties() {
        return this.mobProperties;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K && this.field_70173_aa == 1) {
            this.playMusic((Entity)this);
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        if ((double)EntityUtil.getCurrentHealthPercent((EntityLivingBase)this) < 0.5) {
            --this.stasisCountdown;
            if (this.stasisCountdown < 100) {
                this.func_70691_i(1.0f);
                this.field_70159_w = 0.0;
                this.field_70181_x = 0.0;
                this.field_70179_y = 0.0;
                if (this.stasisCountdown == 0) {
                    this.stasisCountdown = 500;
                }
            }
        }
    }

    @Override
    protected boolean isSpecialImmuneTo(DamageSource source, int damage) {
        return EntityUtil.isRangedDamage(source, (Entity)this, 1.0f);
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K) {
            Entity source = cause.func_76346_g();
            EntityPlayer killer = null;
            if (source != null) {
                if (source instanceof EntityPlayer) {
                    killer = (EntityPlayer)source;
                } else if (source instanceof EntityTameable && ((EntityTameable)source).func_70902_q() instanceof EntityPlayer) {
                    killer = (EntityPlayer)((EntityTameable)source).func_70902_q();
                }
            }
            if (killer != null) {
                StringUtil.sendMessageWithinRadius(StringUtil.getLocaleWithArguments("message.mob.clunkhead.kill", killer.getDisplayNameString()), (Entity)this, 50);
            }
        }
    }

    public boolean func_184205_a(Entity entity, boolean force) {
        return false;
    }

    @Override
    @Nonnull
    public ResourceLocation getBossBarTexture() {
        return bossBarTexture;
    }

    @Override
    @Nullable
    public SoundEvent getBossMusic() {
        return SoundsRegister.musicClunkhead;
    }

    public void func_70624_b(@Nullable EntityLivingBase target) {
        if (target instanceof BossEntity) {
            return;
        }
        super.func_70624_b(target);
    }
}

