/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.boss.horon;

import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.LootSystemRegister;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.entity.base.AoAMeleeMob;
import net.tslat.aoa3.entity.properties.BossEntity;
import net.tslat.aoa3.entity.properties.SpecialPropertyEntity;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.EntityUtil;
import net.tslat.aoa3.utils.WorldUtil;
import net.tslat.aoa3.utils.player.PlayerDataManager;
import net.tslat.aoa3.utils.player.PlayerUtil;

public class EntityHoron
extends AoAMeleeMob
implements BossEntity,
SpecialPropertyEntity {
    private static final ResourceLocation bossBarTexture = new ResourceLocation("aoa3", "textures/gui/bossbars/horon.png");
    public static final float entityWidth = 1.5f;

    public EntityHoron(World world) {
        super(world, 1.5f, 2.6875f);
        this.mobProperties.add(Enums.MobProperties.RANGED_IMMUNE);
    }

    public float func_70047_e() {
        return 2.28125f;
    }

    @Override
    protected double getBaseKnockbackResistance() {
        return 0.3;
    }

    @Override
    protected double getBaseMaxHealth() {
        return 3000.0;
    }

    @Override
    protected double getBaseMeleeDamage() {
        return 24.0;
    }

    @Override
    protected double getBaseMovementSpeed() {
        return 0.2875;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return SoundsRegister.mobHoronLiving;
    }

    @Override
    @Nullable
    protected SoundEvent func_184615_bR() {
        return SoundsRegister.mobHoronDeath;
    }

    @Override
    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundsRegister.mobHoronHit;
    }

    @Override
    protected SoundEvent getStepSound() {
        return SoundsRegister.heavyStep;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootSystemRegister.entityHoron;
    }

    public boolean func_184222_aU() {
        return false;
    }

    @Override
    protected boolean isSpecialImmuneTo(DamageSource source, int damage) {
        return EntityUtil.isRangedDamage(source, (Entity)this, 1.0f);
    }

    @Override
    protected void doMeleeEffect(Entity target) {
        if (target instanceof EntityPlayer) {
            PlayerDataManager plData = PlayerUtil.getAdventPlayer((EntityPlayer)target);
            plData.stats().consumeResource(Enums.Resources.ENERGY, 60.0f, true);
            plData.stats().consumeResource(Enums.Resources.CREATION, 20.0f, true);
            plData.stats().consumeResource(Enums.Resources.SOUL, 20.0f, true);
        }
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K && this.field_70173_aa == 1) {
            this.playMusic((Entity)this);
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K) {
            if (this.field_70146_Z.nextInt(60) == 0) {
                WorldUtil.createExplosion((Entity)this, this.field_70170_p, 2.0f);
            }
            if (this.func_70638_az() != null && this.field_70146_Z.nextInt(400) == 0) {
                this.func_70638_az().func_70690_d(new PotionEffect(MobEffects.field_76437_t, 120, 3, true, true));
            }
        }
    }

    public boolean func_184205_a(Entity entity, boolean force) {
        return false;
    }

    @Override
    public ResourceLocation getBossBarTexture() {
        return bossBarTexture;
    }

    @Override
    @Nullable
    public SoundEvent getBossMusic() {
        return SoundsRegister.musicHoron;
    }

    @Override
    @Nonnull
    public TreeSet<Enums.MobProperties> getMobProperties() {
        return this.mobProperties;
    }

    public void func_70624_b(@Nullable EntityLivingBase target) {
        if (target instanceof BossEntity) {
            return;
        }
        super.func_70624_b(target);
    }
}

