/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.boss.hydrolisk;

import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.ItemRegister;
import net.tslat.aoa3.common.registration.LootSystemRegister;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.entity.base.AoAMeleeMob;
import net.tslat.aoa3.entity.boss.hydrolisk.EntityHydrolon;
import net.tslat.aoa3.entity.minions.AoAMinion;
import net.tslat.aoa3.entity.properties.BossEntity;
import net.tslat.aoa3.entity.properties.SpecialPropertyEntity;
import net.tslat.aoa3.library.Enums;

public class EntityHydrolisk
extends AoAMeleeMob
implements BossEntity,
SpecialPropertyEntity {
    private static final ResourceLocation bossBarTexture = new ResourceLocation("aoa3", "textures/gui/bossbars/hydrolisk.png");
    private static final ResourceLocation shieldedBossBarTexture = new ResourceLocation("aoa3", "textures/gui/bossbars/hydrolisk_armour.png");
    private static final DataParameter<Boolean> SHIELDED = EntityDataManager.func_187226_a(EntityHydrolisk.class, (DataSerializer)DataSerializers.field_187198_h);
    private boolean shielded = true;
    public static final float entityWidth = 1.9f;

    public EntityHydrolisk(World world) {
        super(world, 1.9f, 3.0f);
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, false));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, AoAMinion.class, 10, true, false, minion -> minion.func_70909_n()));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
    }

    public float func_70047_e() {
        return 2.625f;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SHIELDED, (Object)true);
    }

    @Override
    protected double getBaseKnockbackResistance() {
        return 0.8;
    }

    @Override
    protected double getBaseMaxHealth() {
        return 609.0;
    }

    @Override
    protected double getBaseMeleeDamage() {
        return 12.0;
    }

    @Override
    protected double getBaseMovementSpeed() {
        return 0.2875;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return SoundsRegister.mobHydroliskLiving;
    }

    @Override
    @Nullable
    protected SoundEvent func_184615_bR() {
        return SoundsRegister.mobHydroliskDeath;
    }

    @Override
    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundsRegister.mobHydroliskHit;
    }

    @Override
    protected SoundEvent getStepSound() {
        return SoundsRegister.mobEmperorBeastStep;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootSystemRegister.entityHydrolisk;
    }

    public boolean func_184222_aU() {
        return false;
    }

    public boolean func_190530_aW() {
        return (Boolean)this.field_70180_af.func_187225_a(SHIELDED);
    }

    public boolean isShielded() {
        return (Boolean)this.field_70180_af.func_187225_a(SHIELDED);
    }

    private void disableShield() {
        this.field_70180_af.func_187227_b(SHIELDED, (Object)false);
        this.shielded = false;
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(800.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(16.0);
        this.func_70606_j(800.0f);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K && this.field_70173_aa == 1) {
            this.playMusic((Entity)this);
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.func_70090_H()) {
            this.func_70691_i(1.0f);
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.shielded) {
                if (this.field_70146_Z.nextInt(80) == 0) {
                    this.field_70170_p.func_72838_d((Entity)new EntityHydrolon(this));
                }
            } else if (this.field_70146_Z.nextInt(120) == 0 && !this.field_70170_p.field_73011_w.func_177500_n() && this.field_70170_p.func_180495_p(this.func_180425_c()).func_185904_a().func_76222_j()) {
                this.field_70170_p.func_175656_a(this.func_180425_c(), Blocks.field_150358_i.func_176223_P());
            }
        }
    }

    protected boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack heldItem;
        if (this.shielded && (heldItem = player.func_184586_b(hand)).func_77973_b() == ItemRegister.hydroStone) {
            if (!player.field_71075_bZ.field_75098_d) {
                heldItem.func_190918_g(1);
            }
            if (this.func_110143_aJ() <= 50.0f) {
                this.disableShield();
            } else {
                this.func_70606_j(this.func_110143_aJ() - 50.0f);
            }
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    @Override
    public ResourceLocation getBossBarTexture() {
        return (Boolean)this.field_70180_af.func_187225_a(SHIELDED) != false ? shieldedBossBarTexture : bossBarTexture;
    }

    @Override
    @Nullable
    public SoundEvent getBossMusic() {
        return SoundsRegister.musicHydrolisk;
    }

    @Override
    @Nonnull
    public TreeSet<Enums.MobProperties> getMobProperties() {
        return this.mobProperties;
    }

    public void func_70624_b(@Nullable EntityLivingBase target) {
        if (target instanceof BossEntity) {
            return;
        }
        super.func_70624_b(target);
    }
}

