/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.boss.penumbra;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.LootSystemRegister;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.entity.base.AoAMeleeMob;
import net.tslat.aoa3.entity.base.AoARangedMob;
import net.tslat.aoa3.entity.mobs.abyss.EntityApparition;
import net.tslat.aoa3.entity.mobs.abyss.EntityOcculent;
import net.tslat.aoa3.entity.mobs.dustopia.EntityBasilisk;
import net.tslat.aoa3.entity.mobs.dustopia.EntityDevourer;
import net.tslat.aoa3.entity.mobs.dustopia.EntityStalker;
import net.tslat.aoa3.entity.mobs.greckon.EntityShifter;
import net.tslat.aoa3.entity.mobs.nether.EntityHellspot;
import net.tslat.aoa3.entity.mobs.voxponds.EntityAlarmo;
import net.tslat.aoa3.entity.projectiles.mob.BaseMobProjectile;
import net.tslat.aoa3.entity.projectiles.mob.EntityPenumbraShot;
import net.tslat.aoa3.entity.properties.BossEntity;
import net.tslat.aoa3.library.Enums;

public class EntityPenumbra
extends AoARangedMob
implements BossEntity {
    private static final ResourceLocation bossBarTexture = new ResourceLocation("aoa3", "textures/gui/bossbars/penumbra.png");
    public static final float entityWidth = 0.9f;

    public EntityPenumbra(World world) {
        super(world, 0.9f, 3.1875f);
    }

    public float func_70047_e() {
        return 3.0625f;
    }

    @Override
    protected double getBaseKnockbackResistance() {
        return 0.0;
    }

    @Override
    protected double getBaseMaxHealth() {
        return 3000.0;
    }

    @Override
    public double getBaseProjectileDamage() {
        return 18.0;
    }

    @Override
    protected double getBaseMovementSpeed() {
        return 0.207;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return SoundsRegister.mobPenumbraLiving;
    }

    @Override
    @Nullable
    protected SoundEvent func_184615_bR() {
        return SoundsRegister.mobPenumbraDeath;
    }

    @Override
    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundsRegister.mobPenumbraHit;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootSystemRegister.entityPenumbra;
    }

    public boolean func_184222_aU() {
        return false;
    }

    @Override
    @Nullable
    protected SoundEvent getShootSound() {
        return null;
    }

    @Override
    public void doProjectileEntityImpact(BaseMobProjectile projectile, Entity target) {
        if (target instanceof EntityOcculent || target instanceof EntityAlarmo || target instanceof EntityShifter || target instanceof EntityDevourer || target instanceof EntityBasilisk || target instanceof EntityApparition || target instanceof EntityStalker || target instanceof EntityHellspot) {
            return;
        }
        super.doProjectileEntityImpact(projectile, target);
    }

    @Override
    public void doProjectileImpactEffect(BaseMobProjectile projectile, Entity target) {
        AoAMeleeMob entity = null;
        switch (this.field_70146_Z.nextInt(8)) {
            case 0: {
                entity = new EntityOcculent(this.field_70170_p);
                break;
            }
            case 1: {
                entity = new EntityAlarmo(this.field_70170_p);
                break;
            }
            case 2: {
                entity = new EntityShifter(this.field_70170_p);
                break;
            }
            case 3: {
                entity = new EntityDevourer(this.field_70170_p);
                break;
            }
            case 4: {
                entity = new EntityBasilisk(this.field_70170_p);
                break;
            }
            case 5: {
                entity = new EntityApparition(this.field_70170_p);
                break;
            }
            case 6: {
                entity = new EntityStalker(this.field_70170_p);
                break;
            }
            case 7: {
                entity = new EntityHellspot(this.field_70170_p);
            }
        }
        entity.func_70107_b(projectile.field_70165_t, projectile.field_70163_u, projectile.field_70161_v);
        this.field_70170_p.func_72838_d((Entity)entity);
    }

    public boolean func_184205_a(Entity entity, boolean force) {
        return false;
    }

    @Override
    protected BaseMobProjectile getNewProjectileInstance() {
        return new EntityPenumbraShot(this, Enums.MobProjectileType.MAGIC);
    }

    @Override
    public ResourceLocation getBossBarTexture() {
        return bossBarTexture;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K && this.field_70173_aa == 1) {
            this.playMusic((Entity)this);
        }
    }

    @Override
    @Nullable
    public SoundEvent getBossMusic() {
        return SoundsRegister.musicPenumbra;
    }

    public void func_70624_b(@Nullable EntityLivingBase target) {
        if (target instanceof BossEntity) {
            return;
        }
        super.func_70624_b(target);
    }
}

