/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.boss.primordialfive;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.LootSystemRegister;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.entity.base.AoARangedMob;
import net.tslat.aoa3.entity.boss.primordialfive.EntityHarkos;
import net.tslat.aoa3.entity.boss.primordialfive.EntityKajaros;
import net.tslat.aoa3.entity.projectiles.mob.BaseMobProjectile;
import net.tslat.aoa3.entity.projectiles.mob.EntityWhiteBall;
import net.tslat.aoa3.entity.properties.BossEntity;
import net.tslat.aoa3.library.Enums;

public class EntityMiskel
extends AoARangedMob
implements BossEntity {
    private static final ResourceLocation bossBarTexture = new ResourceLocation("aoa3", "textures/gui/bossbars/miskel.png");
    public static final float entityWidth = 0.7f;

    public EntityMiskel(EntityKajaros kajaros) {
        this(kajaros.field_70170_p);
        this.func_70012_b(kajaros.field_70165_t, kajaros.field_70163_u, kajaros.field_70161_v, kajaros.field_70177_z, kajaros.field_70125_A);
    }

    public EntityMiskel(World world) {
        super(world, 0.7f, 2.375f);
    }

    public float func_70047_e() {
        return 2.009375f;
    }

    @Override
    protected double getBaseKnockbackResistance() {
        return 0.4;
    }

    @Override
    protected double getBaseMaxHealth() {
        return 1300.0;
    }

    @Override
    public double getBaseProjectileDamage() {
        return 14.0;
    }

    @Override
    protected double getBaseMovementSpeed() {
        return 0.207;
    }

    @Override
    @Nullable
    protected SoundEvent getShootSound() {
        return null;
    }

    @Override
    protected BaseMobProjectile getNewProjectileInstance() {
        return new EntityWhiteBall(this, Enums.MobProjectileType.MAGIC);
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return SoundsRegister.mobPrimordialLiving;
    }

    @Override
    @Nullable
    protected SoundEvent func_184615_bR() {
        return SoundsRegister.mobPrimordialDeath;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootSystemRegister.entityMiskel;
    }

    public boolean func_184222_aU() {
        return false;
    }

    @Override
    public void doProjectileImpactEffect(BaseMobProjectile projectile, Entity target) {
        if (target instanceof EntityLivingBase) {
            if (this.field_70146_Z.nextBoolean()) {
                ((EntityLivingBase)target).func_70690_d(new PotionEffect(MobEffects.field_76440_q, 120, 15, true, true));
            } else {
                ((EntityLivingBase)target).func_70690_d(new PotionEffect(MobEffects.field_82731_v, 80, 6, true, true));
            }
        }
        this.func_70691_i(40.0f);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K && this.field_70173_aa == 1) {
            this.playMusic((Entity)this);
        }
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K) {
            EntityHarkos harkos = new EntityHarkos(this);
            this.field_70170_p.func_72838_d((Entity)harkos);
            this.func_70106_y();
        }
    }

    @Override
    public ResourceLocation getBossBarTexture() {
        return bossBarTexture;
    }

    @Override
    @Nullable
    public SoundEvent getBossMusic() {
        return SoundsRegister.musicPrimordialFive;
    }

    public void func_70624_b(@Nullable EntityLivingBase target) {
        if (target instanceof BossEntity) {
            return;
        }
        super.func_70624_b(target);
    }
}

