/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.boss.skeletalarmy;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.LootSystemRegister;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.common.registration.WeaponRegister;
import net.tslat.aoa3.entity.base.AoAMeleeMob;
import net.tslat.aoa3.entity.properties.BossEntity;
import net.tslat.aoa3.item.armour.AdventArmour;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.ModUtil;
import net.tslat.aoa3.utils.StringUtil;

public class EntitySkeletron
extends AoAMeleeMob
implements BossEntity {
    private static final ResourceLocation bossBarTexture = new ResourceLocation("aoa3", "textures/gui/bossbars/skeletron.png");
    public static final float entityWidth = 1.2f;

    public EntitySkeletron(World world, BlockPos armyBlockPos) {
        this(world);
        this.func_70012_b(armyBlockPos.func_177958_n(), armyBlockPos.func_177956_o() + 2, armyBlockPos.func_177952_p(), this.field_70146_Z.nextFloat() * 360.0f, 0.0f);
    }

    public EntitySkeletron(World world) {
        super(world, 1.2f, 1.25f);
    }

    public float func_70047_e() {
        return 1.0f;
    }

    @Override
    protected double getBaseKnockbackResistance() {
        return 0.0;
    }

    @Override
    protected double getBaseMaxHealth() {
        return 1100.0;
    }

    @Override
    protected double getBaseMeleeDamage() {
        return 70.0;
    }

    @Override
    protected double getBaseMovementSpeed() {
        return 0.2875;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return SoundsRegister.mobSkeletronLiving;
    }

    @Override
    @Nullable
    protected SoundEvent func_184615_bR() {
        return SoundsRegister.mobSkeletronDeath;
    }

    @Override
    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundsRegister.mobSkeletronHit;
    }

    @Override
    protected SoundEvent getStepSound() {
        return SoundsRegister.heavyStep;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootSystemRegister.entitySkeletron;
    }

    @Override
    public ResourceLocation getBossBarTexture() {
        return bossBarTexture;
    }

    @Override
    @Nullable
    public SoundEvent getBossMusic() {
        return SoundsRegister.musicSkeletron;
    }

    public boolean func_184222_aU() {
        return false;
    }

    public boolean func_184205_a(Entity entity, boolean force) {
        return false;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K && this.field_70173_aa == 1) {
            this.playMusic((Entity)this);
        }
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K) {
            Entity source = cause.func_76346_g();
            EntityPlayer killer = null;
            if (source != null) {
                if (source instanceof EntityPlayer) {
                    killer = (EntityPlayer)source;
                } else if (source instanceof EntityTameable && ((EntityTameable)source).func_70902_q() instanceof EntityPlayer) {
                    killer = (EntityPlayer)((EntityTameable)source).func_70902_q();
                }
            }
            if (killer != null) {
                StringUtil.sendMessageWithinRadius(StringUtil.getLocaleWithArguments("message.mob.skeletalArmy.kill", killer.getDisplayNameString()), (Entity)this, 50);
                if (killer instanceof EntityPlayerMP && killer.func_184614_ca().func_77973_b() == WeaponRegister.swordSkeletal) {
                    for (ItemStack stack : killer.func_184193_aE()) {
                        if (stack.func_77973_b() instanceof AdventArmour && ((AdventArmour)stack.func_77973_b()).setType() == Enums.ArmourSets.SKELETAL) continue;
                        return;
                    }
                    ModUtil.completeAdvancement((EntityPlayerMP)killer, "precasia/spooky_scary_skeletons", "full_set_kill");
                }
            }
        }
    }

    public void func_70624_b(@Nullable EntityLivingBase target) {
        if (target instanceof BossEntity) {
            return;
        }
        super.func_70624_b(target);
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.UNDEAD;
    }
}

