/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.boss.tyrosaur;

import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.LootSystemRegister;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.entity.base.AoAMeleeMob;
import net.tslat.aoa3.entity.properties.BossEntity;
import net.tslat.aoa3.entity.properties.SpecialPropertyEntity;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.EntityUtil;
import net.tslat.aoa3.utils.PredicateUtil;
import net.tslat.aoa3.utils.StringUtil;

public class EntityTyrosaur
extends AoAMeleeMob
implements BossEntity,
SpecialPropertyEntity {
    private static final ResourceLocation bossBarTexture = new ResourceLocation("aoa3", "textures/gui/bossbars/tyrosaur.png");
    public static final float entityWidth = 0.8f;
    private int stompCooldown = 100;

    public EntityTyrosaur(World world) {
        super(world, 0.8f, 1.3125f);
        this.mobProperties.add(Enums.MobProperties.GUN_IMMUNE);
        this.mobProperties.add(Enums.MobProperties.RANGED_IMMUNE);
    }

    public float func_70047_e() {
        return 0.96875f;
    }

    @Override
    protected double getBaseKnockbackResistance() {
        return 0.9;
    }

    @Override
    protected double getBaseMaxHealth() {
        return 4000.0;
    }

    @Override
    protected double getBaseMeleeDamage() {
        return 15.0;
    }

    @Override
    protected double getBaseMovementSpeed() {
        return 0.2875;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return SoundsRegister.mobTyrosaurLiving;
    }

    @Override
    @Nullable
    protected SoundEvent func_184615_bR() {
        return SoundsRegister.mobTyrosaurDeath;
    }

    @Override
    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundsRegister.mobTyrosaurHit;
    }

    @Override
    protected SoundEvent getStepSound() {
        return SoundsRegister.mobTyrosaurStep;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootSystemRegister.entityTyrosaur;
    }

    @Override
    protected boolean isSpecialImmuneTo(DamageSource source, int damage) {
        return EntityUtil.isGunDamage(source) || EntityUtil.isRangedDamage(source, (Entity)this, 1.0f);
    }

    public boolean func_184222_aU() {
        return false;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K && this.field_70173_aa == 1) {
            this.playMusic((Entity)this);
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70128_L) {
            return;
        }
        if (this.stompCooldown > 0) {
            --this.stompCooldown;
        }
        if (this.stompCooldown > 70) {
            if (this.func_70638_az() != null && this.field_70146_Z.nextInt(150) == 0) {
                if (!this.field_70170_p.field_72995_K) {
                    this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundsRegister.mobTyrosaurCharge, SoundCategory.HOSTILE, 1.0f, 1.0f);
                }
                this.func_70024_g(Math.signum(this.func_70638_az().field_70165_t - this.field_70165_t) * 1.029, (this.func_70638_az().field_70163_u - this.field_70163_u) * 0.0429, Math.signum(this.func_70638_az().field_70161_v - this.field_70161_v) * 1.029);
            }
        } else if (this.stompCooldown == 40) {
            if (!this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundsRegister.mobTyrosaurReadyStomp, SoundCategory.HOSTILE, 1.0f, 1.0f);
            }
        } else if (this.stompCooldown == 0) {
            this.stompCooldown = 100;
            if (!this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundsRegister.mobTyrosaurStomp, SoundCategory.HOSTILE, 1.0f, 1.0f);
            }
            for (EntityPlayer pl : this.field_70170_p.func_175647_a(EntityPlayer.class, this.func_174813_aQ().func_186662_g(35.0), PredicateUtil.IS_VULNERABLE_PLAYER)) {
                if (!pl.field_70122_E || this.field_70170_p.field_72995_K || !EntityUtil.dealAoeDamage(null, (EntityLivingBase)this, (Entity)pl, 10.0f, false)) continue;
                pl.func_145747_a((ITextComponent)StringUtil.getColourLocale("message.mob.tyrosaur.stomp", TextFormatting.DARK_GREEN));
            }
        }
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K) {
            Entity source = cause.func_76346_g();
            EntityPlayer killer = null;
            if (source != null) {
                if (source instanceof EntityPlayer) {
                    killer = (EntityPlayer)source;
                } else if (source instanceof EntityTameable && ((EntityTameable)source).func_70902_q() instanceof EntityPlayer) {
                    killer = (EntityPlayer)((EntityTameable)source).func_70902_q();
                }
            }
            if (killer != null) {
                StringUtil.sendMessageWithinRadius(StringUtil.getLocaleWithArguments("message.mob.tyrosaur.kill", killer.getDisplayNameString()), (Entity)this, 50);
            }
        }
    }

    public boolean func_184205_a(Entity entity, boolean force) {
        return false;
    }

    @Override
    public ResourceLocation getBossBarTexture() {
        return bossBarTexture;
    }

    @Override
    @Nullable
    public SoundEvent getBossMusic() {
        return SoundsRegister.musicTyrosaur;
    }

    @Override
    @Nonnull
    public TreeSet<Enums.MobProperties> getMobProperties() {
        return this.mobProperties;
    }

    public void func_70624_b(@Nullable EntityLivingBase target) {
        if (target instanceof BossEntity) {
            return;
        }
        super.func_70624_b(target);
    }
}

