/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.boss.voxxulon;

import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.LootSystemRegister;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.entity.base.AoAMeleeMob;
import net.tslat.aoa3.entity.base.AoARangedAttacker;
import net.tslat.aoa3.entity.projectiles.mob.BaseMobProjectile;
import net.tslat.aoa3.entity.projectiles.mob.EntityVoxxulonMeteor;
import net.tslat.aoa3.entity.properties.BossEntity;
import net.tslat.aoa3.entity.properties.SpecialPropertyEntity;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.EntityUtil;
import net.tslat.aoa3.utils.PredicateUtil;
import net.tslat.aoa3.utils.StringUtil;
import net.tslat.aoa3.utils.WorldUtil;

public class EntityVoxxulon
extends AoAMeleeMob
implements BossEntity,
SpecialPropertyEntity,
AoARangedAttacker {
    private static final ResourceLocation bossBarTexture = new ResourceLocation("aoa3", "textures/gui/bossbars/voxxulon.png");
    public static final float entityWidth = 2.0f;

    public EntityVoxxulon(World world) {
        super(world, 2.0f, 2.375f);
        this.mobProperties.add(Enums.MobProperties.GUN_IMMUNE);
    }

    public float func_70047_e() {
        return 1.8125f;
    }

    @Override
    protected double getBaseKnockbackResistance() {
        return 0.8;
    }

    @Override
    protected double getBaseMaxHealth() {
        return 2000.0;
    }

    @Override
    protected double getBaseMeleeDamage() {
        return 30.0;
    }

    @Override
    protected double getBaseMovementSpeed() {
        return 0.0;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return SoundsRegister.mobVoxxulonLiving;
    }

    @Override
    @Nullable
    protected SoundEvent func_184615_bR() {
        return SoundsRegister.mobVoxxulonDeath;
    }

    @Override
    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundsRegister.mobVoxxulonHit;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootSystemRegister.entityVoxxulon;
    }

    @Override
    protected SoundEvent getStepSound() {
        return null;
    }

    @Override
    protected boolean isSpecialImmuneTo(DamageSource source, int damage) {
        return EntityUtil.isGunDamage(source);
    }

    public boolean func_184222_aU() {
        return false;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K && this.field_70173_aa == 1) {
            this.playMusic((Entity)this);
        }
    }

    public void func_70636_d() {
        EntityPlayer pl;
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K && this.func_70638_az() != null && this.field_70146_Z.nextInt(200) == 0 && this.func_70638_az().func_70032_d((Entity)this) < 60.0f) {
            this.func_70634_a(this.func_70638_az().field_70165_t, this.func_70638_az().field_70163_u, this.func_70638_az().field_70161_v);
        }
        if (this.field_70146_Z.nextInt(200) == 0) {
            for (EntityPlayer pl2 : this.field_70170_p.func_175647_a(EntityPlayer.class, this.func_174813_aQ().func_186662_g(40.0), PredicateUtil.IS_VULNERABLE_PLAYER)) {
                pl2.func_70690_d(new PotionEffect(MobEffects.field_76436_u, 100, 4, true, true));
            }
        }
        if (this.field_70146_Z.nextInt(10) == 0 && (pl = this.field_70170_p.func_184137_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, 30.0, false)) != null && !pl.field_71075_bZ.field_75098_d) {
            this.field_70170_p.func_72838_d((Entity)new EntityVoxxulonMeteor(this, (Entity)pl, Enums.MobProjectileType.MAGIC));
        }
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K) {
            Entity source = cause.func_76346_g();
            EntityPlayer killer = null;
            if (source != null) {
                if (source instanceof EntityPlayer) {
                    killer = (EntityPlayer)source;
                } else if (source instanceof EntityTameable && ((EntityTameable)source).func_70902_q() instanceof EntityPlayer) {
                    killer = (EntityPlayer)((EntityTameable)source).func_70902_q();
                }
            }
            if (killer != null) {
                StringUtil.sendMessageWithinRadius(StringUtil.getLocaleWithArguments("message.mob.voxxulon.kill", killer.getDisplayNameString()), (Entity)this, 50);
            }
        }
    }

    @Override
    public ResourceLocation getBossBarTexture() {
        return bossBarTexture;
    }

    @Override
    @Nullable
    public SoundEvent getBossMusic() {
        return SoundsRegister.musicVoxxulon;
    }

    @Override
    @Nonnull
    public TreeSet<Enums.MobProperties> getMobProperties() {
        return this.mobProperties;
    }

    @Override
    public void doProjectileEntityImpact(BaseMobProjectile projectile, Entity target) {
        EntityUtil.dealBlasterDamage((EntityLivingBase)this, target, (Entity)projectile, 25.0f, false);
    }

    public boolean func_184205_a(Entity entity, boolean force) {
        return false;
    }

    @Override
    public void doProjectileBlockImpact(BaseMobProjectile projectile, IBlockState blockHit, BlockPos pos, EnumFacing sideHit) {
        WorldUtil.createExplosion((Entity)this, this.field_70170_p, (Entity)projectile, 1.0f);
    }

    @Override
    public void doProjectileImpactEffect(BaseMobProjectile projectile, Entity target) {
        WorldUtil.createExplosion((Entity)this, this.field_70170_p, (Entity)projectile, 1.0f);
    }

    public void func_70624_b(@Nullable EntityLivingBase target) {
        if (target instanceof BossEntity) {
            return;
        }
        super.func_70624_b(target);
    }
}

