/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.mobs.abyss;

import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.LootSystemRegister;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.entity.base.AoAMeleeMob;
import net.tslat.aoa3.entity.properties.SpecialPropertyEntity;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.EntityUtil;

public class EntityDistorter
extends AoAMeleeMob
implements SpecialPropertyEntity {
    public static final float entityWidth = 0.6f;
    private int effectTick = 60;

    public EntityDistorter(World world) {
        super(world, 0.6f, 2.125f);
        this.mobProperties.add(Enums.MobProperties.MAGIC_IMMUNE);
        this.mobProperties.add(Enums.MobProperties.BLASTER_IMMUNE);
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 15.0f));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
    }

    public float func_70047_e() {
        return 1.675f;
    }

    @Override
    protected double getBaseKnockbackResistance() {
        return 0.1;
    }

    @Override
    protected double getBaseMaxHealth() {
        return 95.0;
    }

    @Override
    protected double getBaseMeleeDamage() {
        return 0.0;
    }

    @Override
    protected double getBaseMovementSpeed() {
        return 0.0;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return SoundsRegister.mobDistorterLiving;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return SoundsRegister.mobDistorterDeath;
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundsRegister.mobDistorterHit;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootSystemRegister.entityDistorter;
    }

    @Override
    protected boolean isSpecialImmuneTo(DamageSource source, int damage) {
        return EntityUtil.isBlasterDamage(source) || EntityUtil.isMagicDamage(source, (Entity)this, damage);
    }

    public void func_70636_d() {
        super.func_70636_d();
        --this.effectTick;
        if (this.field_70173_aa % 5 == 0) {
            Potion currentEffect = this.effectTick <= 30 ? MobEffects.field_76421_d : MobEffects.field_76424_c;
            for (EntityPlayer pl2 : this.field_70170_p.func_175647_a(EntityPlayer.class, this.func_174813_aQ().func_186662_g(2.0), pl -> pl != null && !pl.func_175149_v() && !pl.func_184812_l_() && this.func_70685_l((Entity)pl))) {
                pl2.func_70690_d(new PotionEffect(currentEffect, 5, 5, true, false));
            }
        }
        if (this.effectTick <= 0) {
            this.effectTick = 60;
        }
    }

    @Override
    @Nonnull
    public TreeSet<Enums.MobProperties> getMobProperties() {
        return this.mobProperties;
    }
}

