/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.mobs.candyland;

import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.LootSystemRegister;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.entity.base.AoAFlyingRangedMob;
import net.tslat.aoa3.entity.projectiles.mob.BaseMobProjectile;
import net.tslat.aoa3.entity.projectiles.mob.EntitySkyShot;
import net.tslat.aoa3.entity.properties.SpecialPropertyEntity;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.ConfigurationUtil;
import net.tslat.aoa3.utils.EntityUtil;

public class EntityAirhead
extends AoAFlyingRangedMob
implements SpecialPropertyEntity {
    public static final float entityWidth = 1.0f;

    public EntityAirhead(World world) {
        super(world, 1.0f, 1.6875f);
        this.mobProperties.add(Enums.MobProperties.BLASTER_IMMUNE);
    }

    public float func_70047_e() {
        return 0.53125f;
    }

    @Override
    protected double getBaseKnockbackResistance() {
        return 0.0;
    }

    @Override
    protected double getBaseMaxHealth() {
        return 2.0;
    }

    @Override
    public double getBaseProjectileDamage() {
        return 14.0;
    }

    @Override
    protected double getBaseMovementSpeed() {
        return 0.1;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return SoundsRegister.mobAirheadLiving;
    }

    @Override
    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundsRegister.mobAirheadHit;
    }

    @Override
    @Nullable
    protected SoundEvent func_184615_bR() {
        return SoundsRegister.mobAirheadDeath;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootSystemRegister.entityAirhead;
    }

    @Override
    protected double getSpawnChanceFactor() {
        return ConfigurationUtil.EntityConfig.mobSpawnFrequencyModifier / 7.0;
    }

    @Override
    @Nullable
    protected SoundEvent getShootSound() {
        return null;
    }

    @Override
    protected boolean isSpecialImmuneTo(DamageSource source, int damage) {
        return EntityUtil.isBlasterDamage(source);
    }

    @Override
    protected BaseMobProjectile getNewProjectileInstance() {
        return new EntitySkyShot(this, Enums.MobProjectileType.PHYSICAL);
    }

    @Override
    @Nonnull
    public TreeSet<Enums.MobProperties> getMobProperties() {
        return this.mobProperties;
    }
}

